/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.https;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelHttpsSinkConnectorConfig extends CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_HTTPS_PATH_HTTP_URI_CONF = "camel.sink.path.httpUri";
    public static final String CAMEL_SINK_HTTPS_PATH_HTTP_URI_DOC = "The url of the HTTP endpoint to call.";
    public static final String CAMEL_SINK_HTTPS_PATH_HTTP_URI_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_DISABLE_STREAM_CACHE_CONF = "camel.sink.endpoint.disableStreamCache";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_DISABLE_STREAM_CACHE_DOC = "Determines whether or not the raw input stream from Servlet is cached or not (Camel will read the stream into a in memory/overflow to file, Stream caching) cache. By default Camel will cache the Servlet input stream to support reading it multiple times to ensure it Camel can retrieve all data from the stream. However you can set this option to true when you for example need to access the raw stream, such as streaming it directly to a file or other persistent store. DefaultHttpBinding will copy the request input stream into a stream cache and put it into message body if this option is false to support reading the stream multiple times. If you use Servlet to bridge/proxy an endpoint then consider enabling this option to improve performance, in case you do not need to read the message payload multiple times. The http producer will by default cache the response body stream. If setting this option to true, then the producers will not cache the response body stream but use the response stream as-is as the message body.";
    public static final Boolean CAMEL_SINK_HTTPS_ENDPOINT_DISABLE_STREAM_CACHE_DEFAULT = false;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_HEADER_FILTER_STRATEGY_CONF = "camel.sink.endpoint.headerFilterStrategy";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_HEADER_FILTER_STRATEGY_DOC = "To use a custom HeaderFilterStrategy to filter header to and from Camel message.";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_HEADER_FILTER_STRATEGY_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_BRIDGE_ENDPOINT_CONF = "camel.sink.endpoint.bridgeEndpoint";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_BRIDGE_ENDPOINT_DOC = "If the option is true, HttpProducer will ignore the Exchange.HTTP_URI header, and use the endpoint's URI for request. You may also set the option throwExceptionOnFailure to be false to let the HttpProducer send all the fault response back.";
    public static final Boolean CAMEL_SINK_HTTPS_ENDPOINT_BRIDGE_ENDPOINT_DEFAULT = false;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_CONNECTION_CLOSE_CONF = "camel.sink.endpoint.connectionClose";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_CONNECTION_CLOSE_DOC = "Specifies whether a Connection Close header must be added to HTTP Request. By default connectionClose is false.";
    public static final Boolean CAMEL_SINK_HTTPS_ENDPOINT_CONNECTION_CLOSE_DEFAULT = false;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_FOLLOW_REDIRECTS_CONF = "camel.sink.endpoint.followRedirects";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_FOLLOW_REDIRECTS_DOC = "Whether to the HTTP request should follow redirects. By default the HTTP request does not follow redirects";
    public static final Boolean CAMEL_SINK_HTTPS_ENDPOINT_FOLLOW_REDIRECTS_DEFAULT = false;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_HTTP_METHOD_CONF = "camel.sink.endpoint.httpMethod";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_HTTP_METHOD_DOC = "Configure the HTTP method to use. The HttpMethod header cannot override this option if set. One of: [GET] [POST] [PUT] [DELETE] [HEAD] [OPTIONS] [TRACE] [PATCH]";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_HTTP_METHOD_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_THROW_EXCEPTION_ON_FAILURE_CONF = "camel.sink.endpoint.throwExceptionOnFailure";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_THROW_EXCEPTION_ON_FAILURE_DOC = "Option to disable throwing the HttpOperationFailedException in case of failed responses from the remote server. This allows you to get all responses regardless of the HTTP status code.";
    public static final Boolean CAMEL_SINK_HTTPS_ENDPOINT_THROW_EXCEPTION_ON_FAILURE_DEFAULT = true;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_CLEAR_EXPIRED_COOKIES_CONF = "camel.sink.endpoint.clearExpiredCookies";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_CLEAR_EXPIRED_COOKIES_DOC = "Whether to clear expired cookies before sending the HTTP request. This ensures the cookies store does not keep growing by adding new cookies which is newer removed when they are expired. If the component has disabled cookie management then this option is disabled too.";
    public static final Boolean CAMEL_SINK_HTTPS_ENDPOINT_CLEAR_EXPIRED_COOKIES_DEFAULT = true;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_COOKIE_HANDLER_CONF = "camel.sink.endpoint.cookieHandler";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_COOKIE_HANDLER_DOC = "Configure a cookie handler to maintain a HTTP session";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_COOKIE_HANDLER_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_COOKIE_STORE_CONF = "camel.sink.endpoint.cookieStore";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_COOKIE_STORE_DOC = "To use a custom CookieStore. By default the BasicCookieStore is used which is an in-memory only cookie store. Notice if bridgeEndpoint=true then the cookie store is forced to be a noop cookie store as cookie shouldn't be stored as we are just bridging (eg acting as a proxy). If a cookieHandler is set then the cookie store is also forced to be a noop cookie store as cookie handling is then performed by the cookieHandler.";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_COOKIE_STORE_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_COPY_HEADERS_CONF = "camel.sink.endpoint.copyHeaders";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_COPY_HEADERS_DOC = "If this option is true then IN exchange headers will be copied to OUT exchange headers according to copy strategy. Setting this to false, allows to only include the headers from the HTTP response (not propagating IN headers).";
    public static final Boolean CAMEL_SINK_HTTPS_ENDPOINT_COPY_HEADERS_DEFAULT = true;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_CUSTOM_HOST_HEADER_CONF = "camel.sink.endpoint.customHostHeader";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_CUSTOM_HOST_HEADER_DOC = "To use custom host header for producer. When not set in query will be ignored. When set will override host header derived from url.";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_CUSTOM_HOST_HEADER_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_DELETE_WITH_BODY_CONF = "camel.sink.endpoint.deleteWithBody";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_DELETE_WITH_BODY_DOC = "Whether the HTTP DELETE should include the message body or not. By default HTTP DELETE do not include any HTTP body. However in some rare cases users may need to be able to include the message body.";
    public static final Boolean CAMEL_SINK_HTTPS_ENDPOINT_DELETE_WITH_BODY_DEFAULT = false;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_GET_WITH_BODY_CONF = "camel.sink.endpoint.getWithBody";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_GET_WITH_BODY_DOC = "Whether the HTTP GET should include the message body or not. By default HTTP GET do not include any HTTP body. However in some rare cases users may need to be able to include the message body.";
    public static final Boolean CAMEL_SINK_HTTPS_ENDPOINT_GET_WITH_BODY_DEFAULT = false;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_IGNORE_RESPONSE_BODY_CONF = "camel.sink.endpoint.ignoreResponseBody";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_IGNORE_RESPONSE_BODY_DOC = "If this option is true, The http producer won't read response body and cache the input stream";
    public static final Boolean CAMEL_SINK_HTTPS_ENDPOINT_IGNORE_RESPONSE_BODY_DEFAULT = false;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_LAZY_START_PRODUCER_CONF = "camel.sink.endpoint.lazyStartProducer";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_HTTPS_ENDPOINT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_OK_STATUS_CODE_RANGE_CONF = "camel.sink.endpoint.okStatusCodeRange";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_OK_STATUS_CODE_RANGE_DOC = "The status codes which are considered a success response. The values are inclusive. Multiple ranges can be defined, separated by comma, e.g. 200-204,209,301-304. Each range must be a single number or from-to with the dash included.";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_OK_STATUS_CODE_RANGE_DEFAULT = "200-299";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_PRESERVE_HOST_HEADER_CONF = "camel.sink.endpoint.preserveHostHeader";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_PRESERVE_HOST_HEADER_DOC = "If the option is true, HttpProducer will set the Host header to the value contained in the current exchange Host header, useful in reverse proxy applications where you want the Host header received by the downstream server to reflect the URL called by the upstream client, this allows applications which use the Host header to generate accurate URL's for a proxied service";
    public static final Boolean CAMEL_SINK_HTTPS_ENDPOINT_PRESERVE_HOST_HEADER_DEFAULT = false;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_SKIP_REQUEST_HEADERS_CONF = "camel.sink.endpoint.skipRequestHeaders";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_SKIP_REQUEST_HEADERS_DOC = "Whether to skip mapping all the Camel headers as HTTP request headers. If there are no data from Camel headers needed to be included in the HTTP request then this can avoid parsing overhead with many object allocations for the JVM garbage collector.";
    public static final Boolean CAMEL_SINK_HTTPS_ENDPOINT_SKIP_REQUEST_HEADERS_DEFAULT = false;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_SKIP_RESPONSE_HEADERS_CONF = "camel.sink.endpoint.skipResponseHeaders";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_SKIP_RESPONSE_HEADERS_DOC = "Whether to skip mapping all the HTTP response headers to Camel headers. If there are no data needed from HTTP headers then this can avoid parsing overhead with many object allocations for the JVM garbage collector.";
    public static final Boolean CAMEL_SINK_HTTPS_ENDPOINT_SKIP_RESPONSE_HEADERS_DEFAULT = false;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_USER_AGENT_CONF = "camel.sink.endpoint.userAgent";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_USER_AGENT_DOC = "To set a custom HTTP User-Agent request header";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_USER_AGENT_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_CLIENT_BUILDER_CONF = "camel.sink.endpoint.clientBuilder";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_CLIENT_BUILDER_DOC = "Provide access to the http client request parameters used on new RequestConfig instances used by producers or consumers of this endpoint.";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_CLIENT_BUILDER_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_CLIENT_CONNECTION_MANAGER_CONF = "camel.sink.endpoint.clientConnectionManager";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_CLIENT_CONNECTION_MANAGER_DOC = "To use a custom HttpClientConnectionManager to manage connections";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_CLIENT_CONNECTION_MANAGER_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_CONNECTIONS_PER_ROUTE_CONF = "camel.sink.endpoint.connectionsPerRoute";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_CONNECTIONS_PER_ROUTE_DOC = "The maximum number of connections per route.";
    public static final Integer CAMEL_SINK_HTTPS_ENDPOINT_CONNECTIONS_PER_ROUTE_DEFAULT = 20;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_HTTP_CLIENT_CONF = "camel.sink.endpoint.httpClient";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_HTTP_CLIENT_DOC = "Sets a custom HttpClient to be used by the producer";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_HTTP_CLIENT_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_HTTP_CLIENT_CONFIGURER_CONF = "camel.sink.endpoint.httpClientConfigurer";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_HTTP_CLIENT_CONFIGURER_DOC = "Register a custom configuration strategy for new HttpClient instances created by producers or consumers such as to configure authentication mechanisms etc.";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_HTTP_CLIENT_CONFIGURER_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_HTTP_CLIENT_OPTIONS_CONF = "camel.sink.endpoint.httpClientOptions";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_HTTP_CLIENT_OPTIONS_DOC = "To configure the HttpClient using the key/values from the Map.";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_HTTP_CLIENT_OPTIONS_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_HTTP_CONNECTION_OPTIONS_CONF = "camel.sink.endpoint.httpConnectionOptions";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_HTTP_CONNECTION_OPTIONS_DOC = "To configure the connection and the socket using the key/values from the Map.";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_HTTP_CONNECTION_OPTIONS_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_HTTP_CONTEXT_CONF = "camel.sink.endpoint.httpContext";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_HTTP_CONTEXT_DOC = "To use a custom HttpContext instance";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_HTTP_CONTEXT_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_MAX_TOTAL_CONNECTIONS_CONF = "camel.sink.endpoint.maxTotalConnections";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_MAX_TOTAL_CONNECTIONS_DOC = "The maximum number of connections.";
    public static final Integer CAMEL_SINK_HTTPS_ENDPOINT_MAX_TOTAL_CONNECTIONS_DEFAULT = 200;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_USE_SYSTEM_PROPERTIES_CONF = "camel.sink.endpoint.useSystemProperties";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_USE_SYSTEM_PROPERTIES_DOC = "To use System Properties as fallback for configuration";
    public static final Boolean CAMEL_SINK_HTTPS_ENDPOINT_USE_SYSTEM_PROPERTIES_DEFAULT = false;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_DOMAIN_CONF = "camel.sink.endpoint.proxyAuthDomain";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_DOMAIN_DOC = "Proxy authentication domain to use with NTML";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_DOMAIN_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_HOST_CONF = "camel.sink.endpoint.proxyAuthHost";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_HOST_DOC = "Proxy authentication host";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_HOST_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_METHOD_CONF = "camel.sink.endpoint.proxyAuthMethod";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_METHOD_DOC = "Proxy authentication method to use One of: [Basic] [Digest] [NTLM]";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_METHOD_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_NT_HOST_CONF = "camel.sink.endpoint.proxyAuthNtHost";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_NT_HOST_DOC = "Proxy authentication domain (workstation name) to use with NTML";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_NT_HOST_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_PASSWORD_CONF = "camel.sink.endpoint.proxyAuthPassword";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_PASSWORD_DOC = "Proxy authentication password";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_PORT_CONF = "camel.sink.endpoint.proxyAuthPort";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_PORT_DOC = "Proxy authentication port";
    public static final Integer CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_PORT_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_SCHEME_CONF = "camel.sink.endpoint.proxyAuthScheme";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_SCHEME_DOC = "Proxy authentication scheme to use One of: [http] [https]";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_SCHEME_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_USERNAME_CONF = "camel.sink.endpoint.proxyAuthUsername";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_USERNAME_DOC = "Proxy authentication username";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_USERNAME_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_PROXY_HOST_CONF = "camel.sink.endpoint.proxyHost";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_PROXY_HOST_DOC = "Proxy hostname to use";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_PROXY_HOST_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_PROXY_PORT_CONF = "camel.sink.endpoint.proxyPort";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_PROXY_PORT_DOC = "Proxy port to use";
    public static final Integer CAMEL_SINK_HTTPS_ENDPOINT_PROXY_PORT_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_AUTH_DOMAIN_CONF = "camel.sink.endpoint.authDomain";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_AUTH_DOMAIN_DOC = "Authentication domain to use with NTML";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_AUTH_DOMAIN_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_AUTHENTICATION_PREEMPTIVE_CONF = "camel.sink.endpoint.authenticationPreemptive";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_AUTHENTICATION_PREEMPTIVE_DOC = "If this option is true, camel-http sends preemptive basic authentication to the server.";
    public static final Boolean CAMEL_SINK_HTTPS_ENDPOINT_AUTHENTICATION_PREEMPTIVE_DEFAULT = false;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_AUTH_HOST_CONF = "camel.sink.endpoint.authHost";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_AUTH_HOST_DOC = "Authentication host to use with NTML";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_AUTH_HOST_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_AUTH_METHOD_CONF = "camel.sink.endpoint.authMethod";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_AUTH_METHOD_DOC = "Authentication methods allowed to use as a comma separated list of values Basic, Digest or NTLM.";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_AUTH_METHOD_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_AUTH_METHOD_PRIORITY_CONF = "camel.sink.endpoint.authMethodPriority";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_AUTH_METHOD_PRIORITY_DOC = "Which authentication method to prioritize to use, either as Basic, Digest or NTLM. One of: [Basic] [Digest] [NTLM]";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_AUTH_METHOD_PRIORITY_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_AUTH_PASSWORD_CONF = "camel.sink.endpoint.authPassword";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_AUTH_PASSWORD_DOC = "Authentication password";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_AUTH_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_AUTH_USERNAME_CONF = "camel.sink.endpoint.authUsername";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_AUTH_USERNAME_DOC = "Authentication username";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_AUTH_USERNAME_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_SSL_CONTEXT_PARAMETERS_CONF = "camel.sink.endpoint.sslContextParameters";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_SSL_CONTEXT_PARAMETERS_DOC = "To configure security using SSLContextParameters. Important: Only one instance of org.apache.camel.util.jsse.SSLContextParameters is supported per HttpComponent. If you need to use 2 or more different instances, you need to define a new HttpComponent per instance you need.";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_SSL_CONTEXT_PARAMETERS_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_X509HOSTNAME_VERIFIER_CONF = "camel.sink.endpoint.x509HostnameVerifier";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_X509HOSTNAME_VERIFIER_DOC = "To use a custom X509HostnameVerifier such as DefaultHostnameVerifier or NoopHostnameVerifier";
    public static final String CAMEL_SINK_HTTPS_ENDPOINT_X509HOSTNAME_VERIFIER_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_COMPONENT_FOLLOW_REDIRECTS_CONF = "camel.component.https.followRedirects";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_FOLLOW_REDIRECTS_DOC = "Whether to the HTTP request should follow redirects. By default the HTTP request does not follow redirects";
    public static final Boolean CAMEL_SINK_HTTPS_COMPONENT_FOLLOW_REDIRECTS_DEFAULT = false;
    public static final String CAMEL_SINK_HTTPS_COMPONENT_LAZY_START_PRODUCER_CONF = "camel.component.https.lazyStartProducer";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_HTTPS_COMPONENT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_HTTPS_COMPONENT_COOKIE_STORE_CONF = "camel.component.https.cookieStore";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_COOKIE_STORE_DOC = "To use a custom org.apache.hc.client5.http.cookie.CookieStore. By default the org.apache.hc.client5.http.cookie.BasicCookieStore is used which is an in-memory only cookie store. Notice if bridgeEndpoint=true then the cookie store is forced to be a noop cookie store as cookie shouldn't be stored as we are just bridging (eg acting as a proxy).";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_COOKIE_STORE_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_COMPONENT_COPY_HEADERS_CONF = "camel.component.https.copyHeaders";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_COPY_HEADERS_DOC = "If this option is true then IN exchange headers will be copied to OUT exchange headers according to copy strategy. Setting this to false, allows to only include the headers from the HTTP response (not propagating IN headers).";
    public static final Boolean CAMEL_SINK_HTTPS_COMPONENT_COPY_HEADERS_DEFAULT = true;
    public static final String CAMEL_SINK_HTTPS_COMPONENT_RESPONSE_PAYLOAD_STREAMING_THRESHOLD_CONF = "camel.component.https.responsePayloadStreamingThreshold";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_RESPONSE_PAYLOAD_STREAMING_THRESHOLD_DOC = "This threshold in bytes controls whether the response payload should be stored in memory as a byte array or be streaming based. Set this to -1 to always use streaming mode.";
    public static final Integer CAMEL_SINK_HTTPS_COMPONENT_RESPONSE_PAYLOAD_STREAMING_THRESHOLD_DEFAULT = 8192;
    public static final String CAMEL_SINK_HTTPS_COMPONENT_SKIP_REQUEST_HEADERS_CONF = "camel.component.https.skipRequestHeaders";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_SKIP_REQUEST_HEADERS_DOC = "Whether to skip mapping all the Camel headers as HTTP request headers. If there are no data from Camel headers needed to be included in the HTTP request then this can avoid parsing overhead with many object allocations for the JVM garbage collector.";
    public static final Boolean CAMEL_SINK_HTTPS_COMPONENT_SKIP_REQUEST_HEADERS_DEFAULT = false;
    public static final String CAMEL_SINK_HTTPS_COMPONENT_SKIP_RESPONSE_HEADERS_CONF = "camel.component.https.skipResponseHeaders";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_SKIP_RESPONSE_HEADERS_DOC = "Whether to skip mapping all the HTTP response headers to Camel headers. If there are no data needed from HTTP headers then this can avoid parsing overhead with many object allocations for the JVM garbage collector.";
    public static final Boolean CAMEL_SINK_HTTPS_COMPONENT_SKIP_RESPONSE_HEADERS_DEFAULT = false;
    public static final String CAMEL_SINK_HTTPS_COMPONENT_ALLOW_JAVA_SERIALIZED_OBJECT_CONF = "camel.component.https.allowJavaSerializedObject";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_ALLOW_JAVA_SERIALIZED_OBJECT_DOC = "Whether to allow java serialization when a request uses context-type=application/x-java-serialized-object. This is by default turned off. If you enable this then be aware that Java will deserialize the incoming data from the request to Java and that can be a potential security risk.";
    public static final Boolean CAMEL_SINK_HTTPS_COMPONENT_ALLOW_JAVA_SERIALIZED_OBJECT_DEFAULT = false;
    public static final String CAMEL_SINK_HTTPS_COMPONENT_AUTH_CACHING_DISABLED_CONF = "camel.component.https.authCachingDisabled";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_AUTH_CACHING_DISABLED_DOC = "Disables authentication scheme caching";
    public static final Boolean CAMEL_SINK_HTTPS_COMPONENT_AUTH_CACHING_DISABLED_DEFAULT = false;
    public static final String CAMEL_SINK_HTTPS_COMPONENT_AUTOMATIC_RETRIES_DISABLED_CONF = "camel.component.https.automaticRetriesDisabled";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_AUTOMATIC_RETRIES_DISABLED_DOC = "Disables automatic request recovery and re-execution";
    public static final Boolean CAMEL_SINK_HTTPS_COMPONENT_AUTOMATIC_RETRIES_DISABLED_DEFAULT = false;
    public static final String CAMEL_SINK_HTTPS_COMPONENT_AUTOWIRED_ENABLED_CONF = "camel.component.https.autowiredEnabled";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_AUTOWIRED_ENABLED_DOC = "Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc.";
    public static final Boolean CAMEL_SINK_HTTPS_COMPONENT_AUTOWIRED_ENABLED_DEFAULT = true;
    public static final String CAMEL_SINK_HTTPS_COMPONENT_CLIENT_CONNECTION_MANAGER_CONF = "camel.component.https.clientConnectionManager";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_CLIENT_CONNECTION_MANAGER_DOC = "To use a custom and shared HttpClientConnectionManager to manage connections. If this has been configured then this is always used for all endpoints created by this component.";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_CLIENT_CONNECTION_MANAGER_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_COMPONENT_CONNECTIONS_PER_ROUTE_CONF = "camel.component.https.connectionsPerRoute";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_CONNECTIONS_PER_ROUTE_DOC = "The maximum number of connections per route.";
    public static final Integer CAMEL_SINK_HTTPS_COMPONENT_CONNECTIONS_PER_ROUTE_DEFAULT = 20;
    public static final String CAMEL_SINK_HTTPS_COMPONENT_CONNECTION_STATE_DISABLED_CONF = "camel.component.https.connectionStateDisabled";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_CONNECTION_STATE_DISABLED_DOC = "Disables connection state tracking";
    public static final Boolean CAMEL_SINK_HTTPS_COMPONENT_CONNECTION_STATE_DISABLED_DEFAULT = false;
    public static final String CAMEL_SINK_HTTPS_COMPONENT_CONNECTION_TIME_TO_LIVE_CONF = "camel.component.https.connectionTimeToLive";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_CONNECTION_TIME_TO_LIVE_DOC = "The time for connection to live, the time unit is millisecond, the default value is always keep alive.";
    public static final Long CAMEL_SINK_HTTPS_COMPONENT_CONNECTION_TIME_TO_LIVE_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_COMPONENT_CONTENT_COMPRESSION_DISABLED_CONF = "camel.component.https.contentCompressionDisabled";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_CONTENT_COMPRESSION_DISABLED_DOC = "Disables automatic content decompression";
    public static final Boolean CAMEL_SINK_HTTPS_COMPONENT_CONTENT_COMPRESSION_DISABLED_DEFAULT = false;
    public static final String CAMEL_SINK_HTTPS_COMPONENT_COOKIE_MANAGEMENT_DISABLED_CONF = "camel.component.https.cookieManagementDisabled";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_COOKIE_MANAGEMENT_DISABLED_DOC = "Disables state (cookie) management";
    public static final Boolean CAMEL_SINK_HTTPS_COMPONENT_COOKIE_MANAGEMENT_DISABLED_DEFAULT = false;
    public static final String CAMEL_SINK_HTTPS_COMPONENT_DEFAULT_USER_AGENT_DISABLED_CONF = "camel.component.https.defaultUserAgentDisabled";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_DEFAULT_USER_AGENT_DISABLED_DOC = "Disables the default user agent set by this builder if none has been provided by the user";
    public static final Boolean CAMEL_SINK_HTTPS_COMPONENT_DEFAULT_USER_AGENT_DISABLED_DEFAULT = false;
    public static final String CAMEL_SINK_HTTPS_COMPONENT_HTTP_BINDING_CONF = "camel.component.https.httpBinding";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_HTTP_BINDING_DOC = "To use a custom HttpBinding to control the mapping between Camel message and HttpClient.";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_HTTP_BINDING_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_COMPONENT_HTTP_CLIENT_CONFIGURER_CONF = "camel.component.https.httpClientConfigurer";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_HTTP_CLIENT_CONFIGURER_DOC = "To use the custom HttpClientConfigurer to perform configuration of the HttpClient that will be used.";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_HTTP_CLIENT_CONFIGURER_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_COMPONENT_HTTP_CONFIGURATION_CONF = "camel.component.https.httpConfiguration";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_HTTP_CONFIGURATION_DOC = "To use the shared HttpConfiguration as base configuration.";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_HTTP_CONFIGURATION_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_COMPONENT_HTTP_CONTEXT_CONF = "camel.component.https.httpContext";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_HTTP_CONTEXT_DOC = "To use a custom org.apache.hc.core5.http.protocol.HttpContext when executing requests.";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_HTTP_CONTEXT_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_COMPONENT_MAX_TOTAL_CONNECTIONS_CONF = "camel.component.https.maxTotalConnections";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_MAX_TOTAL_CONNECTIONS_DOC = "The maximum number of connections.";
    public static final Integer CAMEL_SINK_HTTPS_COMPONENT_MAX_TOTAL_CONNECTIONS_DEFAULT = 200;
    public static final String CAMEL_SINK_HTTPS_COMPONENT_REDIRECT_HANDLING_DISABLED_CONF = "camel.component.https.redirectHandlingDisabled";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_REDIRECT_HANDLING_DISABLED_DOC = "Disables automatic redirect handling";
    public static final Boolean CAMEL_SINK_HTTPS_COMPONENT_REDIRECT_HANDLING_DISABLED_DEFAULT = false;
    public static final String CAMEL_SINK_HTTPS_COMPONENT_HEADER_FILTER_STRATEGY_CONF = "camel.component.https.headerFilterStrategy";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_HEADER_FILTER_STRATEGY_DOC = "To use a custom org.apache.camel.spi.HeaderFilterStrategy to filter header to and from Camel message.";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_HEADER_FILTER_STRATEGY_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_DOMAIN_CONF = "camel.component.https.proxyAuthDomain";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_DOMAIN_DOC = "Proxy authentication domain to use";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_DOMAIN_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_HOST_CONF = "camel.component.https.proxyAuthHost";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_HOST_DOC = "Proxy authentication host";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_HOST_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_METHOD_CONF = "camel.component.https.proxyAuthMethod";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_METHOD_DOC = "Proxy authentication method to use One of: [Basic] [Digest] [NTLM]";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_METHOD_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_NT_HOST_CONF = "camel.component.https.proxyAuthNtHost";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_NT_HOST_DOC = "Proxy authentication domain (workstation name) to use with NTML";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_NT_HOST_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_PASSWORD_CONF = "camel.component.https.proxyAuthPassword";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_PASSWORD_DOC = "Proxy authentication password";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_PORT_CONF = "camel.component.https.proxyAuthPort";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_PORT_DOC = "Proxy authentication port";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_PORT_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_SCHEME_CONF = "camel.component.https.proxyAuthScheme";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_SCHEME_DOC = "Proxy authentication protocol scheme One of: [http] [https]";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_SCHEME_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_USERNAME_CONF = "camel.component.https.proxyAuthUsername";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_USERNAME_DOC = "Proxy authentication username";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_USERNAME_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_COMPONENT_SSL_CONTEXT_PARAMETERS_CONF = "camel.component.https.sslContextParameters";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_SSL_CONTEXT_PARAMETERS_DOC = "To configure security using SSLContextParameters. Important: Only one instance of org.apache.camel.support.jsse.SSLContextParameters is supported per HttpComponent. If you need to use 2 or more different instances, you need to define a new HttpComponent per instance you need.";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_SSL_CONTEXT_PARAMETERS_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_CONF = "camel.component.https.useGlobalSslContextParameters";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DOC = "Enable usage of global SSL context parameters.";
    public static final Boolean CAMEL_SINK_HTTPS_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DEFAULT = false;
    public static final String CAMEL_SINK_HTTPS_COMPONENT_X509HOSTNAME_VERIFIER_CONF = "camel.component.https.x509HostnameVerifier";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_X509HOSTNAME_VERIFIER_DOC = "To use a custom X509HostnameVerifier such as DefaultHostnameVerifier or NoopHostnameVerifier.";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_X509HOSTNAME_VERIFIER_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPS_COMPONENT_CONNECTION_REQUEST_TIMEOUT_CONF = "camel.component.https.connectionRequestTimeout";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_CONNECTION_REQUEST_TIMEOUT_DOC = "Returns the connection lease request timeout used when requesting a connection from the connection manager. A timeout value of zero is interpreted as a disabled timeout.";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_CONNECTION_REQUEST_TIMEOUT_DEFAULT = "3 minutes";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_CONNECT_TIMEOUT_CONF = "camel.component.https.connectTimeout";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_CONNECT_TIMEOUT_DOC = "Determines the timeout until a new connection is fully established. A timeout value of zero is interpreted as an infinite timeout.";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_CONNECT_TIMEOUT_DEFAULT = "3 minutes";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_RESPONSE_TIMEOUT_CONF = "camel.component.https.responseTimeout";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_RESPONSE_TIMEOUT_DOC = "Determines the timeout until arrival of a response from the opposite endpoint. A timeout value of zero is interpreted as an infinite timeout. Please note that response timeout may be unsupported by HTTP transports with message multiplexing.";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_RESPONSE_TIMEOUT_DEFAULT = "0";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_SO_TIMEOUT_CONF = "camel.component.https.soTimeout";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_SO_TIMEOUT_DOC = "Determines the default socket timeout value for blocking I/O operations.";
    public static final String CAMEL_SINK_HTTPS_COMPONENT_SO_TIMEOUT_DEFAULT = "3 minutes";

    public CamelHttpsSinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelHttpsSinkConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_HTTPS_PATH_HTTP_URI_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_PATH_HTTP_URI_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_HTTPS_PATH_HTTP_URI_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_DISABLE_STREAM_CACHE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_HTTPS_ENDPOINT_DISABLE_STREAM_CACHE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_DISABLE_STREAM_CACHE_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_HEADER_FILTER_STRATEGY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_ENDPOINT_HEADER_FILTER_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_HEADER_FILTER_STRATEGY_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_BRIDGE_ENDPOINT_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_HTTPS_ENDPOINT_BRIDGE_ENDPOINT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_BRIDGE_ENDPOINT_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_CONNECTION_CLOSE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_HTTPS_ENDPOINT_CONNECTION_CLOSE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_CONNECTION_CLOSE_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_FOLLOW_REDIRECTS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_HTTPS_ENDPOINT_FOLLOW_REDIRECTS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_FOLLOW_REDIRECTS_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_HTTP_METHOD_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_ENDPOINT_HTTP_METHOD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_HTTP_METHOD_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_THROW_EXCEPTION_ON_FAILURE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_HTTPS_ENDPOINT_THROW_EXCEPTION_ON_FAILURE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_THROW_EXCEPTION_ON_FAILURE_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_CLEAR_EXPIRED_COOKIES_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_HTTPS_ENDPOINT_CLEAR_EXPIRED_COOKIES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_CLEAR_EXPIRED_COOKIES_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_COOKIE_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_ENDPOINT_COOKIE_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_COOKIE_HANDLER_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_COOKIE_STORE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_ENDPOINT_COOKIE_STORE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_COOKIE_STORE_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_COPY_HEADERS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_HTTPS_ENDPOINT_COPY_HEADERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_COPY_HEADERS_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_CUSTOM_HOST_HEADER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_ENDPOINT_CUSTOM_HOST_HEADER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_CUSTOM_HOST_HEADER_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_DELETE_WITH_BODY_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_HTTPS_ENDPOINT_DELETE_WITH_BODY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_DELETE_WITH_BODY_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_GET_WITH_BODY_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_HTTPS_ENDPOINT_GET_WITH_BODY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_GET_WITH_BODY_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_IGNORE_RESPONSE_BODY_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_HTTPS_ENDPOINT_IGNORE_RESPONSE_BODY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_IGNORE_RESPONSE_BODY_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_HTTPS_ENDPOINT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_OK_STATUS_CODE_RANGE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_ENDPOINT_OK_STATUS_CODE_RANGE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_OK_STATUS_CODE_RANGE_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_PRESERVE_HOST_HEADER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_HTTPS_ENDPOINT_PRESERVE_HOST_HEADER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_PRESERVE_HOST_HEADER_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_SKIP_REQUEST_HEADERS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_HTTPS_ENDPOINT_SKIP_REQUEST_HEADERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_SKIP_REQUEST_HEADERS_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_SKIP_RESPONSE_HEADERS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_HTTPS_ENDPOINT_SKIP_RESPONSE_HEADERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_SKIP_RESPONSE_HEADERS_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_USER_AGENT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_ENDPOINT_USER_AGENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_USER_AGENT_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_CLIENT_BUILDER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_ENDPOINT_CLIENT_BUILDER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_CLIENT_BUILDER_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_CLIENT_CONNECTION_MANAGER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_ENDPOINT_CLIENT_CONNECTION_MANAGER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_CLIENT_CONNECTION_MANAGER_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_CONNECTIONS_PER_ROUTE_CONF, ConfigDef.Type.INT, CAMEL_SINK_HTTPS_ENDPOINT_CONNECTIONS_PER_ROUTE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_CONNECTIONS_PER_ROUTE_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_HTTP_CLIENT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_ENDPOINT_HTTP_CLIENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_HTTP_CLIENT_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_HTTP_CLIENT_CONFIGURER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_ENDPOINT_HTTP_CLIENT_CONFIGURER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_HTTP_CLIENT_CONFIGURER_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_HTTP_CLIENT_OPTIONS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_ENDPOINT_HTTP_CLIENT_OPTIONS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_HTTP_CLIENT_OPTIONS_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_HTTP_CONNECTION_OPTIONS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_ENDPOINT_HTTP_CONNECTION_OPTIONS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_HTTP_CONNECTION_OPTIONS_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_HTTP_CONTEXT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_ENDPOINT_HTTP_CONTEXT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_HTTP_CONTEXT_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_MAX_TOTAL_CONNECTIONS_CONF, ConfigDef.Type.INT, CAMEL_SINK_HTTPS_ENDPOINT_MAX_TOTAL_CONNECTIONS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_MAX_TOTAL_CONNECTIONS_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_USE_SYSTEM_PROPERTIES_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_HTTPS_ENDPOINT_USE_SYSTEM_PROPERTIES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_USE_SYSTEM_PROPERTIES_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_DOMAIN_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_DOMAIN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_DOMAIN_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_HOST_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_HOST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_HOST_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_METHOD_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_METHOD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_METHOD_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_NT_HOST_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_NT_HOST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_NT_HOST_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_PASSWORD_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_PASSWORD_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_PORT_CONF, ConfigDef.Type.INT, CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_PORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_PORT_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_SCHEME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_SCHEME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_SCHEME_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_USERNAME_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_USERNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_PROXY_AUTH_USERNAME_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_PROXY_HOST_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_ENDPOINT_PROXY_HOST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_PROXY_HOST_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_PROXY_PORT_CONF, ConfigDef.Type.INT, CAMEL_SINK_HTTPS_ENDPOINT_PROXY_PORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_PROXY_PORT_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_AUTH_DOMAIN_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_ENDPOINT_AUTH_DOMAIN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_AUTH_DOMAIN_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_AUTHENTICATION_PREEMPTIVE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_HTTPS_ENDPOINT_AUTHENTICATION_PREEMPTIVE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_AUTHENTICATION_PREEMPTIVE_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_AUTH_HOST_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_ENDPOINT_AUTH_HOST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_AUTH_HOST_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_AUTH_METHOD_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_ENDPOINT_AUTH_METHOD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_AUTH_METHOD_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_AUTH_METHOD_PRIORITY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_ENDPOINT_AUTH_METHOD_PRIORITY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_AUTH_METHOD_PRIORITY_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_AUTH_PASSWORD_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_HTTPS_ENDPOINT_AUTH_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_AUTH_PASSWORD_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_AUTH_USERNAME_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_HTTPS_ENDPOINT_AUTH_USERNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_AUTH_USERNAME_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_SSL_CONTEXT_PARAMETERS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_ENDPOINT_SSL_CONTEXT_PARAMETERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_SSL_CONTEXT_PARAMETERS_DOC);
        conf.define(CAMEL_SINK_HTTPS_ENDPOINT_X509HOSTNAME_VERIFIER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_ENDPOINT_X509HOSTNAME_VERIFIER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_ENDPOINT_X509HOSTNAME_VERIFIER_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_FOLLOW_REDIRECTS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_HTTPS_COMPONENT_FOLLOW_REDIRECTS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_FOLLOW_REDIRECTS_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_HTTPS_COMPONENT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_COOKIE_STORE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_COMPONENT_COOKIE_STORE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_COOKIE_STORE_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_COPY_HEADERS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_HTTPS_COMPONENT_COPY_HEADERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_COPY_HEADERS_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_RESPONSE_PAYLOAD_STREAMING_THRESHOLD_CONF, ConfigDef.Type.INT, CAMEL_SINK_HTTPS_COMPONENT_RESPONSE_PAYLOAD_STREAMING_THRESHOLD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_RESPONSE_PAYLOAD_STREAMING_THRESHOLD_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_SKIP_REQUEST_HEADERS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_HTTPS_COMPONENT_SKIP_REQUEST_HEADERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_SKIP_REQUEST_HEADERS_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_SKIP_RESPONSE_HEADERS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_HTTPS_COMPONENT_SKIP_RESPONSE_HEADERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_SKIP_RESPONSE_HEADERS_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_ALLOW_JAVA_SERIALIZED_OBJECT_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_HTTPS_COMPONENT_ALLOW_JAVA_SERIALIZED_OBJECT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_ALLOW_JAVA_SERIALIZED_OBJECT_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_AUTH_CACHING_DISABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_HTTPS_COMPONENT_AUTH_CACHING_DISABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_AUTH_CACHING_DISABLED_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_AUTOMATIC_RETRIES_DISABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_HTTPS_COMPONENT_AUTOMATIC_RETRIES_DISABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_AUTOMATIC_RETRIES_DISABLED_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_AUTOWIRED_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_HTTPS_COMPONENT_AUTOWIRED_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_AUTOWIRED_ENABLED_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_CLIENT_CONNECTION_MANAGER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_COMPONENT_CLIENT_CONNECTION_MANAGER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_CLIENT_CONNECTION_MANAGER_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_CONNECTIONS_PER_ROUTE_CONF, ConfigDef.Type.INT, CAMEL_SINK_HTTPS_COMPONENT_CONNECTIONS_PER_ROUTE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_CONNECTIONS_PER_ROUTE_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_CONNECTION_STATE_DISABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_HTTPS_COMPONENT_CONNECTION_STATE_DISABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_CONNECTION_STATE_DISABLED_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_CONNECTION_TIME_TO_LIVE_CONF, ConfigDef.Type.LONG, CAMEL_SINK_HTTPS_COMPONENT_CONNECTION_TIME_TO_LIVE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_CONNECTION_TIME_TO_LIVE_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_CONTENT_COMPRESSION_DISABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_HTTPS_COMPONENT_CONTENT_COMPRESSION_DISABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_CONTENT_COMPRESSION_DISABLED_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_COOKIE_MANAGEMENT_DISABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_HTTPS_COMPONENT_COOKIE_MANAGEMENT_DISABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_COOKIE_MANAGEMENT_DISABLED_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_DEFAULT_USER_AGENT_DISABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_HTTPS_COMPONENT_DEFAULT_USER_AGENT_DISABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_DEFAULT_USER_AGENT_DISABLED_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_HTTP_BINDING_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_COMPONENT_HTTP_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_HTTP_BINDING_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_HTTP_CLIENT_CONFIGURER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_COMPONENT_HTTP_CLIENT_CONFIGURER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_HTTP_CLIENT_CONFIGURER_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_HTTP_CONFIGURATION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_COMPONENT_HTTP_CONFIGURATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_HTTP_CONFIGURATION_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_HTTP_CONTEXT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_COMPONENT_HTTP_CONTEXT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_HTTP_CONTEXT_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_MAX_TOTAL_CONNECTIONS_CONF, ConfigDef.Type.INT, CAMEL_SINK_HTTPS_COMPONENT_MAX_TOTAL_CONNECTIONS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_MAX_TOTAL_CONNECTIONS_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_REDIRECT_HANDLING_DISABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_HTTPS_COMPONENT_REDIRECT_HANDLING_DISABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_REDIRECT_HANDLING_DISABLED_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_HEADER_FILTER_STRATEGY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_COMPONENT_HEADER_FILTER_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_HEADER_FILTER_STRATEGY_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_DOMAIN_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_DOMAIN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_DOMAIN_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_HOST_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_HOST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_HOST_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_METHOD_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_METHOD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_METHOD_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_NT_HOST_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_NT_HOST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_NT_HOST_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_PASSWORD_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_PASSWORD_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_PORT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_PORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_PORT_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_SCHEME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_SCHEME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_SCHEME_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_USERNAME_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_USERNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_PROXY_AUTH_USERNAME_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_SSL_CONTEXT_PARAMETERS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_COMPONENT_SSL_CONTEXT_PARAMETERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_SSL_CONTEXT_PARAMETERS_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_HTTPS_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_X509HOSTNAME_VERIFIER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_COMPONENT_X509HOSTNAME_VERIFIER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_X509HOSTNAME_VERIFIER_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_CONNECTION_REQUEST_TIMEOUT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_COMPONENT_CONNECTION_REQUEST_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_CONNECTION_REQUEST_TIMEOUT_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_CONNECT_TIMEOUT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_COMPONENT_CONNECT_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_CONNECT_TIMEOUT_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_RESPONSE_TIMEOUT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_COMPONENT_RESPONSE_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_RESPONSE_TIMEOUT_DOC);
        conf.define(CAMEL_SINK_HTTPS_COMPONENT_SO_TIMEOUT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPS_COMPONENT_SO_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPS_COMPONENT_SO_TIMEOUT_DOC);
        return conf;
    }
}