/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.IOException;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.XMLRoutesDefinitionLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLRoutesDefinitionLoaderResolver {
    public static final String RESOURCE_PATH = "META-INF/services/org/apache/camel/";
    private static final Logger LOG = LoggerFactory.getLogger(XMLRoutesDefinitionLoaderResolver.class);
    private FactoryFinder factoryFinder;

    public XMLRoutesDefinitionLoader resolve(CamelContext context) {
        Class<?> type = null;
        try {
            type = this.findFactory("xmlroutes-loader", context);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (type != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found XMLRoutesDefinitionLoader: {} via: {}{}", new Object[]{type.getName(), this.factoryFinder.getResourcePath(), "xmlroutes-loader"});
            }
            if (XMLRoutesDefinitionLoader.class.isAssignableFrom(type)) {
                XMLRoutesDefinitionLoader answer = (XMLRoutesDefinitionLoader)context.getInjector().newInstance(type, false);
                LOG.info("Detected and using XMLRoutesDefinitionLoader: {}", (Object)answer);
                return answer;
            }
            throw new IllegalArgumentException("Type is not a XMLRoutesDefinitionLoader implementation. Found: " + type.getName());
        }
        throw new RuntimeCamelException("Cannot find XML routes loader in classpath. Add either camel-xml-io or camel-xml-jaxb to the classpath.");
    }

    private Class<?> findFactory(String name, CamelContext context) throws IOException {
        if (this.factoryFinder == null) {
            this.factoryFinder = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getFactoryFinder(RESOURCE_PATH);
        }
        return this.factoryFinder.findClass(name).orElse(null);
    }
}

