/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.loadbalancer;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.camel.model.LoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.CustomLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.FailoverLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.RandomLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.RoundRobinLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.StickyLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.TopicLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.WeightedLoadBalancerDefinition;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.reifier.AbstractReifier;
import org.apache.camel.reifier.loadbalancer.CustomLoadBalancerReifier;
import org.apache.camel.reifier.loadbalancer.FailoverLoadBalancerReifier;
import org.apache.camel.reifier.loadbalancer.RandomLoadBalancerReifier;
import org.apache.camel.reifier.loadbalancer.RoundRobinLoadBalancerReifier;
import org.apache.camel.reifier.loadbalancer.StickyLoadBalancerReifier;
import org.apache.camel.reifier.loadbalancer.TopicLoadBalancerReifier;
import org.apache.camel.reifier.loadbalancer.WeightedLoadBalancerReifier;
import org.apache.camel.spi.ReifierStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.StringHelper;

public class LoadBalancerReifier<T extends LoadBalancerDefinition>
extends AbstractReifier {
    private static final Map<Class<?>, BiFunction<RouteContext, LoadBalancerDefinition, LoadBalancerReifier<? extends LoadBalancerDefinition>>> LOAD_BALANCERS;
    protected final T definition;

    public LoadBalancerReifier(RouteContext routeContext, T definition) {
        super(routeContext);
        this.definition = definition;
    }

    public static LoadBalancerReifier<? extends LoadBalancerDefinition> reifier(RouteContext routeContext, LoadBalancerDefinition definition) {
        BiFunction<RouteContext, LoadBalancerDefinition, LoadBalancerReifier<? extends LoadBalancerDefinition>> reifier = LOAD_BALANCERS.get(definition.getClass());
        if (reifier != null) {
            return reifier.apply(routeContext, definition);
        }
        throw new IllegalStateException("Unsupported definition: " + definition);
    }

    public static void clearReifiers() {
        LOAD_BALANCERS.clear();
    }

    public LoadBalancer createLoadBalancer() {
        String loadBalancerTypeName = ((LoadBalancerDefinition)this.definition).getLoadBalancerTypeName();
        StringHelper.notEmpty((String)loadBalancerTypeName, (String)"loadBalancerTypeName", (Object)this);
        LoadBalancer answer = null;
        if (loadBalancerTypeName != null) {
            Class type = this.camelContext.getClassResolver().resolveClass(loadBalancerTypeName, LoadBalancer.class);
            if (type == null) {
                throw new IllegalArgumentException("Cannot find class: " + loadBalancerTypeName + " in the classpath");
            }
            answer = (LoadBalancer)this.camelContext.getInjector().newInstance(type, false);
            ((LoadBalancerDefinition)this.definition).configureLoadBalancer(answer);
        }
        return answer;
    }

    static {
        HashMap map = new HashMap();
        map.put(LoadBalancerDefinition.class, LoadBalancerReifier::new);
        map.put(CustomLoadBalancerDefinition.class, CustomLoadBalancerReifier::new);
        map.put(FailoverLoadBalancerDefinition.class, FailoverLoadBalancerReifier::new);
        map.put(RandomLoadBalancerDefinition.class, RandomLoadBalancerReifier::new);
        map.put(RoundRobinLoadBalancerDefinition.class, RoundRobinLoadBalancerReifier::new);
        map.put(StickyLoadBalancerDefinition.class, StickyLoadBalancerReifier::new);
        map.put(TopicLoadBalancerDefinition.class, TopicLoadBalancerReifier::new);
        map.put(WeightedLoadBalancerDefinition.class, WeightedLoadBalancerReifier::new);
        LOAD_BALANCERS = map;
        ReifierStrategy.addReifierClearer(LoadBalancerReifier::clearReifiers);
    }
}

