/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.utils.log.interval;

import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.iota.jota.utils.log.Logger;
import org.slf4j.LoggerFactory;

public class IntervalLogger
implements Logger {
    private static final int DEFAULT_LOG_INTERVAL = 3000;
    private final org.slf4j.Logger delegate;
    private final int logInterval;
    private Message lastReceivedMessage;
    private Message lastPrintedMessage;
    private AtomicBoolean outputScheduled = new AtomicBoolean(false);
    private Future<?> scheduledJob;
    private final ScheduledExecutorService outputScheduler = Executors.newScheduledThreadPool(1);
    private long lastLogTime = 0L;
    private boolean enabled = true;

    public IntervalLogger(Class<?> clazz) {
        this(clazz, 3000);
    }

    public IntervalLogger(org.slf4j.Logger delegate) {
        this(delegate, 3000);
    }

    public IntervalLogger(Class<?> clazz, int logInterval) {
        this(LoggerFactory.getLogger(clazz), logInterval);
    }

    public IntervalLogger(org.slf4j.Logger delegate, int logInterval) {
        this.delegate = delegate;
        this.logInterval = logInterval;
    }

    public org.slf4j.Logger delegate() {
        return this.delegate;
    }

    @Override
    public IntervalLogger info(String message) {
        InfoMessage newMessage = new InfoMessage(message);
        if (!newMessage.equals(this.lastReceivedMessage)) {
            this.lastReceivedMessage = newMessage;
            this.triggerOutput();
        }
        return this;
    }

    @Override
    public IntervalLogger debug(String message) {
        DebugMessage newMessage = new DebugMessage(message);
        if (!newMessage.equals(this.lastReceivedMessage)) {
            this.lastReceivedMessage = newMessage;
            this.triggerOutput();
        }
        return this;
    }

    @Override
    public IntervalLogger error(String message) {
        return this.error(message, null);
    }

    @Override
    public IntervalLogger error(String message, Throwable cause) {
        ErrorMessage newMessage = new ErrorMessage(message, cause);
        if (!((Message)newMessage).equals(this.lastReceivedMessage)) {
            this.lastReceivedMessage = newMessage;
            this.triggerOutput(true);
        }
        return this;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public IntervalLogger setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public void triggerOutput() {
        this.triggerOutput(false);
    }

    public void triggerOutput(boolean printImmediately) {
        if (this.lastReceivedMessage != null && (printImmediately || System.currentTimeMillis() - this.lastLogTime >= (long)this.logInterval)) {
            this.lastReceivedMessage.output();
        } else {
            this.scheduleOutput();
        }
    }

    private void scheduleOutput() {
        if (this.outputScheduled.compareAndSet(false, true)) {
            String currentThreadName = Thread.currentThread().getName();
            this.scheduledJob = this.outputScheduler.schedule(() -> {
                Thread.currentThread().setName(currentThreadName);
                this.triggerOutput(true);
            }, Math.max((long)this.logInterval - (System.currentTimeMillis() - this.lastLogTime), 1L), TimeUnit.MILLISECONDS);
        }
    }

    private class ErrorMessage
    extends Message {
        private final Throwable cause;

        public ErrorMessage(String message, Throwable cause) {
            super(message);
            this.cause = cause;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.getClass(), this.message, this.cause);
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && this.cause == ((ErrorMessage)obj).cause;
        }

        @Override
        protected void print() {
            if (this.cause == null) {
                IntervalLogger.this.delegate().error(this.message);
            } else {
                IntervalLogger.this.delegate().error(this.message, this.cause);
            }
        }
    }

    private class DebugMessage
    extends Message {
        public DebugMessage(String message) {
            super(message);
        }

        @Override
        protected void print() {
            IntervalLogger.this.delegate().debug(this.message);
        }
    }

    private class InfoMessage
    extends Message {
        public InfoMessage(String message) {
            super(message);
        }

        @Override
        protected void print() {
            IntervalLogger.this.delegate().info(this.message);
        }
    }

    private abstract class Message {
        protected final String message;

        public Message(String message) {
            this.message = message;
        }

        public void output() {
            if (IntervalLogger.this.scheduledJob != null) {
                IntervalLogger.this.scheduledJob.cancel(true);
            }
            if (!this.equals(IntervalLogger.this.lastPrintedMessage)) {
                if (IntervalLogger.this.enabled) {
                    this.print();
                }
                IntervalLogger.this.lastPrintedMessage = this;
                IntervalLogger.this.lastLogTime = System.currentTimeMillis();
            }
            IntervalLogger.this.outputScheduled.set(false);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.message);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            return Objects.equals(this.message, ((Message)obj).message);
        }

        protected abstract void print();
    }
}

