/*
 * Decompiled with CFR 0.152.
 */
package org.iota.mddoclet;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.Doclet;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.RootDoc;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.Version;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.iota.mddoclet.Document;
import org.iota.mddoclet.DocumentMethodAnnotation;
import org.iota.mddoclet.Parser;
import org.iota.mddoclet.Template;
import org.iota.mddoclet.Util;
import org.iota.mddoclet.example.CURL;
import org.iota.mddoclet.example.HTTP;
import org.iota.mddoclet.example.Java;
import org.iota.mddoclet.example.NodeJS;
import org.iota.mddoclet.example.Python;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MDDoclet
extends Doclet {
    private static final Logger log = LoggerFactory.getLogger(MDDoclet.class);
    private static String version = "Unknown";
    private static List<String> classesList = null;
    private static String repoUrl = null;
    private static Template template;
    private static String extension;
    private Parser parser;

    public MDDoclet(RootDoc root) {
        Configuration configuration = new Configuration(new Version(2, 3, 26));
        configuration.setClassForTemplateLoading(Parser.class, "/templates");
        configuration.setDefaultEncoding("UTF-8");
        configuration.setLocale(Locale.US);
        configuration.setBooleanFormat("yes,no");
        configuration.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        Util util = new Util();
        util.setRepoUrl(repoUrl);
        this.parser = new Parser(configuration, util);
        this.parser.addExport(new Python());
        this.parser.addExport(new NodeJS());
        this.parser.addExport(new CURL());
        this.parser.addExport(new Java());
        this.parser.addExport(new HTTP());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generate(ClassDoc apiDoc) {
        for (MethodDoc m : apiDoc.methods(false)) {
            DocumentMethodAnnotation call = this.getAnnotationData(m, Document.class.getSimpleName());
            if (call == null) continue;
            File classFile = new File(call.name() + extension);
            if (classFile.exists()) {
                classFile = new File(call.name() + "(" + this.paramString(m.parameters()) + ")" + extension);
            }
            log.info("Generating Document(" + classFile.getName() + ")");
            try (FileOutputStream fileOutputStream = new FileOutputStream(classFile);
                 BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);){
                this.parser.renderMethod(bufferedOutputStream, m, call);
            }
            catch (TemplateException | IOException e) {
                log.error("Processing method " + m.name() + " failed");
                e.printStackTrace();
            }
        }
    }

    private String paramString(Parameter[] parameters) {
        StringBuilder builder = new StringBuilder();
        for (Parameter p : parameters) {
            if (builder.length() != 0) {
                builder.append(", ");
            }
            builder.append(p.name());
        }
        return builder.toString();
    }

    private DocumentMethodAnnotation getAnnotationData(MethodDoc method, String annotationName) {
        for (AnnotationDesc anon : method.annotations()) {
            if (!anon.annotationType().name().equals(annotationName)) continue;
            AnnotationDesc.ElementValuePair[] values = anon.elementValues();
            String templateName = this.valueFromPair(values, "template");
            String name = this.valueFromPair(values, "name");
            if (null == name) {
                name = method.name();
            }
            Template template = templateName != null ? Template.getEnum(templateName) : MDDoclet.template;
            return new DocumentMethodAnnotation(method, name, this.valueFromPair(values, "returnParam"), template);
        }
        return null;
    }

    private String valueFromPair(AnnotationDesc.ElementValuePair[] values, String elemName) {
        for (AnnotationDesc.ElementValuePair pair : values) {
            if (!pair.element().name().equals(elemName)) continue;
            return pair.value().value().toString();
        }
        return null;
    }

    public static boolean start(RootDoc root) {
        if (null == template) {
            log.info("Please provide a default template name using \"-template [name]\".");
            log.info("Options are: " + Arrays.toString((Object[])Template.values()));
            return false;
        }
        log.info("Generating " + extension.toUpperCase() + " docs for " + template.getTemplateName() + " V" + version);
        MDDoclet doclet = new MDDoclet(root);
        for (ClassDoc c : root.classes()) {
            if (classesList != null && !classesList.isEmpty() && !classesList.contains(c.name())) continue;
            doclet.generate(c);
            if (classesList == null || classesList.isEmpty()) continue;
            classesList.remove(c.name());
            if (classesList.isEmpty()) break;
        }
        log.info("Documentation generated");
        return true;
    }

    public static int optionLength(String option) {
        if (option.equals("-version")) {
            return 2;
        }
        if (option.equals("-classeslist")) {
            return 2;
        }
        if (option.equals("-repolink")) {
            return 2;
        }
        if (option.equals("-template")) {
            return 2;
        }
        if (option.equals("-extension")) {
            return 2;
        }
        return Doclet.optionLength((String)option);
    }

    public static boolean validOptions(String[][] args, DocErrorReporter err) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i][0].equals("-version")) {
                version = args[i][1];
                continue;
            }
            if (args[i][0].equals("-classeslist")) {
                classesList = MDDoclet.getList(args[i][1]);
                continue;
            }
            if (args[i][0].equals("-repolink")) {
                repoUrl = args[i][1];
                continue;
            }
            if (args[i][0].equals("-template")) {
                try {
                    template = Template.getEnum(args[i][1]);
                }
                catch (IllegalArgumentException e) {
                    log.error(e.getLocalizedMessage());
                    log.info("Please provide a valid template name.");
                    log.info("Options are: ", (Object)Arrays.toString((Object[])Template.values()));
                }
                continue;
            }
            if (!args[i][0].equals("-extension")) continue;
            String extension = args[i][1];
            if (extension.charAt(0) != '.') {
                extension = "." + extension;
            }
            MDDoclet.extension = extension;
        }
        return Doclet.validOptions((String[][])args, (DocErrorReporter)err);
    }

    private static List<String> getList(String string) {
        String[] values = string.split(" ");
        if (values.length > 1) {
            return Arrays.asList(values);
        }
        return null;
    }

    public static LanguageVersion languageVersion() {
        return LanguageVersion.JAVA_1_5;
    }

    static {
        extension = ".md";
    }
}

