/*
 * Decompiled with CFR 0.152.
 */
package org.iota.mddoclet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Tag;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.iota.mddoclet.DocumentMethodAnnotation;
import org.iota.mddoclet.Util;
import org.iota.mddoclet.data.Example;
import org.iota.mddoclet.data.ReturnParam;
import org.iota.mddoclet.example.Export;

public class Parser {
    private final Configuration configuration;
    private final Util util;
    private List<Export> exports;

    Parser(Configuration configuration, Util util) {
        this.configuration = configuration;
        this.util = util;
        this.exports = new ArrayList<Export>();
    }

    public void renderMethod(OutputStream out, MethodDoc methodDoc, DocumentMethodAnnotation call) throws IOException, TemplateException {
        OutputStreamWriter w = new OutputStreamWriter(out);
        this.render(w, methodDoc, call);
    }

    private void render(Writer w, MethodDoc doc, DocumentMethodAnnotation api) throws IOException, TemplateException {
        Template template = this.configuration.getTemplate(api.getTemplate().getFileName());
        HashMap<String, Object> input = new HashMap<String, Object>();
        Tag[] returnTags = doc.tags("return");
        ClassDoc c = this.util.getReturnClass(returnTags);
        if (c != null) {
            input.put("returnclass", c);
        } else if (!doc.returnType().isPrimitive()) {
            input.put("returnclass", doc.returnType().asClassDoc());
        }
        ReturnParam[] returnFields = this.util.parseReturnTag(returnTags, c, doc, api);
        ReturnParam[] parameters = this.util.parseParameters(doc);
        Example[] examples = new Example[this.exports.size()];
        for (int i = 0; i < this.exports.size(); ++i) {
            Export x = this.exports.get(i);
            String response = x.generateResponse(doc, api, returnFields);
            examples[i] = new Example(x.generateExample(doc, api), response, x.generateError(), x.getName(), x.getLanguage());
        }
        input.put("parameters", parameters);
        input.put("returnParams", returnFields);
        input.put("examples", examples);
        input.put("lineNumber", doc.position().line() + "");
        input.put("subject", doc);
        input.put("util", this.util);
        input.put("name", api.name());
        template.process(input, w);
    }

    public void addExport(Export export) {
        this.exports.add(export);
    }
}

