/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.account.plugins.transferchecker;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.iota.jota.IotaAPI;
import org.iota.jota.account.AccountBalanceCache;
import org.iota.jota.account.AccountStateManager;
import org.iota.jota.account.addressgenerator.AddressGeneratorService;
import org.iota.jota.account.deposits.DepositRequest;
import org.iota.jota.account.deposits.StoredDepositAddress;
import org.iota.jota.account.errors.AccountError;
import org.iota.jota.account.event.AccountEvent;
import org.iota.jota.account.event.EventManager;
import org.iota.jota.account.event.events.EventNewInput;
import org.iota.jota.account.event.events.EventReceivedDeposit;
import org.iota.jota.account.event.events.EventSentTransfer;
import org.iota.jota.account.plugins.transferchecker.IncomingTransferChecker;
import org.iota.jota.account.plugins.transferchecker.IncomingTransferCheckerTask;
import org.iota.jota.account.plugins.transferchecker.TransferCheckerImpl;
import org.iota.jota.model.Input;
import org.iota.jota.model.Transaction;
import org.iota.jota.types.Address;
import org.iota.jota.utils.thread.UnboundScheduledExecutorService;

public class IncomingTransferCheckerImpl
extends TransferCheckerImpl
implements IncomingTransferChecker {
    private static final long CHECK_INCOMING_DELAY = 10000L;
    private EventManager eventManager;
    private IotaAPI api;
    private AccountStateManager accountManager;
    private ConcurrentHashMap<String, ScheduledFuture<?>> unconfirmedBundles;
    private UnboundScheduledExecutorService service;
    private AddressGeneratorService addressGen;
    private boolean skipFirst;
    private AccountBalanceCache cache;

    public IncomingTransferCheckerImpl(EventManager eventManager, IotaAPI api, AccountStateManager accountManager, AddressGeneratorService addressGen, AccountBalanceCache cache) {
        this(eventManager, api, accountManager, addressGen, cache, false);
    }

    public IncomingTransferCheckerImpl(EventManager eventManager, IotaAPI api, AccountStateManager accountManager, AddressGeneratorService addressGen, AccountBalanceCache cache, boolean skipFirst) {
        this.addressGen = addressGen;
        this.eventManager = eventManager;
        this.api = api;
        this.accountManager = accountManager;
        this.cache = cache;
        this.skipFirst = skipFirst;
    }

    @Override
    public void load() {
        this.unconfirmedBundles = new ConcurrentHashMap();
        this.service = new UnboundScheduledExecutorService();
    }

    @Override
    public boolean start() {
        for (Map.Entry<Integer, StoredDepositAddress> entry : this.accountManager.getDepositRequests().entrySet()) {
            if (entry.getValue().getSecurityLevel() != this.addressGen.getSecurityLevel()) continue;
            Address address = this.addressGen.get(entry.getKey());
            this.addUnconfirmedBundle(address);
        }
        this.skipFirst = false;
        return true;
    }

    private void addUnconfirmedBundle(Address address) {
        ScheduledFuture<?> task = this.service.scheduleAtFixedRate(new IncomingTransferCheckerTask(address, this.api, this.eventManager, this.skipFirst, this.accountManager), 0L, 10000L, TimeUnit.MILLISECONDS);
        this.unconfirmedBundles.put(address.getAddress().getHash(), task);
    }

    @AccountEvent
    public void newInput(EventNewInput event) {
        this.addUnconfirmedBundle(event.getAddress());
    }

    @AccountEvent
    public void onReceivedDeposit(EventReceivedDeposit receivedEvent) {
        Map.Entry<Input, DepositRequest> res = this.cache.getByAddress(receivedEvent.getAddress());
        if (null == res) {
            throw new AccountError("Got a received deposit which is not found in the cache!");
        }
        res.getKey().setBalance(res.getKey().getBalance() + receivedEvent.getAmount());
    }

    @AccountEvent
    public void onSpent(EventSentTransfer sentEvent) {
        for (Transaction t : sentEvent.getBundle().getTransactions()) {
            ScheduledFuture<?> runnable;
            if (t.getValue() >= 0L || null == (runnable = this.unconfirmedBundles.get(t.getAddress()))) continue;
            runnable.cancel(true);
            this.unconfirmedBundles.remove(t.getAddress());
        }
    }

    @Override
    public void shutdown() {
        this.service.shutdownNow();
    }

    @Override
    public String name() {
        return "IncomingTransferChecker";
    }
}

