/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.account.plugins.transferchecker;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.iota.jota.IotaAPI;
import org.iota.jota.account.AccountStateManager;
import org.iota.jota.account.PendingTransfer;
import org.iota.jota.account.event.AccountEvent;
import org.iota.jota.account.event.EventManager;
import org.iota.jota.account.event.events.EventSentTransfer;
import org.iota.jota.account.event.events.EventTransferConfirmed;
import org.iota.jota.account.plugins.transferchecker.OutgoingTransferChecker;
import org.iota.jota.account.plugins.transferchecker.TransferCheckerImpl;
import org.iota.jota.dto.response.GetInclusionStateResponse;
import org.iota.jota.error.ArgumentException;
import org.iota.jota.model.Bundle;
import org.iota.jota.model.Transaction;
import org.iota.jota.types.Hash;
import org.iota.jota.types.Trits;
import org.iota.jota.utils.Converter;
import org.iota.jota.utils.thread.UnboundScheduledExecutorService;

public class OutgoingTransferCheckerImpl
extends TransferCheckerImpl
implements OutgoingTransferChecker {
    private static final long CHECK_CONFIRMED_DELAY = 30000L;
    private Map<String, ScheduledFuture<?>> unconfirmedBundles;
    private UnboundScheduledExecutorService service;
    private EventManager eventManager;
    private IotaAPI api;
    private AccountStateManager accountManager;

    public OutgoingTransferCheckerImpl(EventManager eventManager, IotaAPI api, AccountStateManager accountManager) {
        this.eventManager = eventManager;
        this.api = api;
        this.accountManager = accountManager;
    }

    @Override
    public void load() {
        this.unconfirmedBundles = new ConcurrentHashMap();
        this.service = new UnboundScheduledExecutorService();
    }

    @Override
    public boolean start() {
        for (Map.Entry<String, PendingTransfer> entry : this.accountManager.getPendingTransfers().entrySet()) {
            Bundle bundle = new Bundle();
            for (Trits trits : entry.getValue().getBundleTrits()) {
                bundle.addTransaction(new Transaction(Converter.trytes(trits.getTrits())));
            }
            this.addUnconfirmedBundle(bundle);
        }
        return true;
    }

    @Override
    public void shutdown() {
        this.service.shutdownNow();
    }

    @AccountEvent
    private void onBundleBroadcast(EventSentTransfer event) {
        this.addUnconfirmedBundle(event.getBundle());
    }

    private void addUnconfirmedBundle(Bundle bundle) {
        Runnable r = () -> this.doTask(bundle);
        this.unconfirmedBundles.put(bundle.getBundleHash(), this.service.scheduleAtFixedRate(r, 0L, 30000L, TimeUnit.MILLISECONDS));
    }

    private void doTask(Bundle bundle) {
        try {
            String hash = bundle.getTransactions().get(0).getHash();
            PendingTransfer pending = this.accountManager.getPendingTransfers().get(hash);
            GetInclusionStateResponse check = this.api.getLatestInclusion((String[])pending.getTailHashes().stream().map(Hash::getHash).toArray(String[]::new));
            if (this.anyTrue(check.getStates())) {
                ScheduledFuture<?> runnable = this.unconfirmedBundles.get(bundle.getBundleHash());
                if (null != runnable) {
                    runnable.cancel(true);
                }
                this.unconfirmedBundles.remove(bundle.getBundleHash());
                this.accountManager.removePendingTransfer(new Hash(hash));
                EventTransferConfirmed event = new EventTransferConfirmed(bundle);
                this.eventManager.emit(event);
            }
        }
        catch (ArgumentException e) {
            e.printStackTrace();
        }
    }

    private boolean anyTrue(boolean[] states) {
        for (boolean b : states) {
            if (!b) continue;
            return true;
        }
        return false;
    }

    @Override
    public String name() {
        return "OutgoingTransferChecker";
    }
}

