/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.utils;

import org.iota.jota.error.ArgumentException;
import org.iota.jota.pow.ICurl;
import org.iota.jota.pow.SpongeFactory;
import org.iota.jota.utils.Converter;
import org.iota.jota.utils.InputValidator;

public class Checksum {
    public static String addChecksum(String address) throws ArgumentException {
        InputValidator.checkAddressWithoutChecksum(address);
        String addressWithChecksum = address;
        addressWithChecksum = addressWithChecksum + Checksum.calculateChecksum(address);
        return addressWithChecksum;
    }

    public static String removeChecksum(String address) throws ArgumentException {
        if (Checksum.isAddressWithChecksum(address)) {
            return Checksum.removeChecksumFromAddress(address);
        }
        if (Checksum.isAddressWithoutChecksum(address)) {
            return address;
        }
        throw new ArgumentException("Invalid addresses provided.");
    }

    private static String removeChecksumFromAddress(String addressWithChecksum) {
        return addressWithChecksum.substring(0, 81);
    }

    public static boolean isValidChecksum(String addressWithChecksum) throws ArgumentException {
        String addressWithoutChecksum = Checksum.removeChecksum(addressWithChecksum);
        String addressWithRecalculateChecksum = addressWithoutChecksum = addressWithoutChecksum + Checksum.calculateChecksum(addressWithoutChecksum);
        return addressWithRecalculateChecksum.equals(addressWithChecksum);
    }

    public static boolean isAddressWithChecksum(String address) throws ArgumentException {
        return InputValidator.checkAddress(address);
    }

    public static boolean isAddressWithoutChecksum(String address) throws ArgumentException {
        return InputValidator.checkAddressWithoutChecksum(address);
    }

    private static String calculateChecksum(String address) {
        ICurl curl = SpongeFactory.create(SpongeFactory.Mode.KERL);
        curl.reset();
        curl.absorb(Converter.trits(address));
        int[] checksumTrits = new int[243];
        curl.squeeze(checksumTrits);
        String checksum = Converter.trytes(checksumTrits);
        return checksum.substring(72, 81);
    }
}

