/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.account.deposits.methods;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iota.jota.account.deposits.ConditionalDepositAddress;
import org.iota.jota.account.deposits.DepositRequest;
import org.iota.jota.account.deposits.methods.DepositMethod;
import org.iota.jota.account.errors.MagnetError;
import org.iota.jota.pow.ICurl;
import org.iota.jota.pow.SpongeFactory;
import org.iota.jota.types.Hash;
import org.iota.jota.utils.Converter;
import org.iota.jota.utils.InputValidator;

public class MagnetMethod
implements DepositMethod<String> {
    private ICurl curl = SpongeFactory.create(SpongeFactory.Mode.KERL);
    private static final String SCHEME = "iota";
    public static final String CONDITION_EXPIRES = "timeout_at";
    public static final String CONDITION_MULTI_USE = "multi_use";
    public static final String CONDITION_AMOUNT = "expected_amount";
    private static final String magnetUrl = "iota://%s/?timeout_at=%d&multi_use=%b&expected_amount=%d";

    public void setCurl(ICurl curl) {
        this.curl = curl;
    }

    @Override
    public ConditionalDepositAddress parse(String method) throws MagnetError {
        try {
            return this.parse(new URI(method));
        }
        catch (URISyntaxException e) {
            throw new MagnetError(e);
        }
    }

    @Override
    private ConditionalDepositAddress parse(URI uri) throws MagnetError {
        if (!SCHEME.equals(uri.getScheme())) {
            throw new MagnetError("Invalid scheme: " + uri.getScheme());
        }
        String address = uri.toString().substring(SCHEME.length() + 3, SCHEME.length() + 3 + 90);
        if (!InputValidator.checkAddress(address)) {
            throw new MagnetError("Invalid Address: " + address);
        }
        Map<String, List<String>> paramsMap = this.collectParams(uri);
        long timeOut = this.parseLong(this.getParam(CONDITION_EXPIRES, paramsMap, "0"));
        boolean multiUse = Boolean.getBoolean(this.getParam(CONDITION_MULTI_USE, paramsMap, "false"));
        long expectedAmount = this.parseLong(this.getParam(CONDITION_AMOUNT, paramsMap, "0"));
        if (!this.magnetChecksum(address.substring(0, 81), timeOut, multiUse, expectedAmount).equals(address.substring(81, 90))) {
            throw new MagnetError("Magnet checksum does not match fields");
        }
        DepositRequest request = new DepositRequest(new Date(timeOut), multiUse, expectedAmount);
        ConditionalDepositAddress conditions = new ConditionalDepositAddress(request, new Hash(address.substring(0, 81)));
        return conditions;
    }

    private long parseLong(String param) {
        try {
            return Long.parseLong(param);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid number: " + param);
        }
    }

    private Map<String, List<String>> collectParams(URI uri) throws MagnetError {
        String[] params;
        HashMap<String, List<String>> paramsMap = new HashMap<String, List<String>>();
        for (String param : params = uri.getSchemeSpecificPart().substring(94).split("&")) {
            try {
                String[] parts = param.split("=");
                String name = parts[0];
                String value = parts[1];
                ArrayList<String> values = (ArrayList<String>)paramsMap.get(name);
                if (values == null) {
                    values = new ArrayList<String>();
                    paramsMap.put(name, values);
                }
                values.add(value);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new MagnetError("Magnet field param is missing a value");
            }
        }
        return paramsMap;
    }

    private String getParam(String condition, Map<String, List<String>> paramsMap, String defaultValue) {
        List map = paramsMap.getOrDefault(condition, Collections.emptyList());
        if (map.size() > 1) {
            throw new IllegalArgumentException("Only one value is allowed for: " + condition);
        }
        if (map.size() == 0) {
            return defaultValue;
        }
        return (String)map.get(0);
    }

    @Override
    public String build(ConditionalDepositAddress conditions) {
        String address = conditions.getDepositAddress().getHash();
        String magnetChecksum = this.magnetChecksum(address, conditions.getRequest().getTimeOut().getTime(), conditions.getRequest().isMultiUse(), conditions.getRequest().getExpectedAmount());
        return String.format(magnetUrl, address + magnetChecksum, conditions.getRequest().getTimeOut().getTime(), conditions.getRequest().isMultiUse(), conditions.getRequest().getExpectedAmount());
    }

    String magnetChecksum(String address, long timeout, boolean multiUse, long amount) {
        int[] addressTrits = this.calculateChecksum(Converter.trits(address));
        int[] timeoutTrits = Converter.trits(timeout);
        int[] amountTrits = Converter.trits(amount);
        int[] totalTrits = new int[243];
        int addressRest = 134;
        System.arraycopy(addressTrits, 0, totalTrits, 0, addressRest);
        System.arraycopy(timeoutTrits, 0, totalTrits, addressRest + 27 - timeoutTrits.length, timeoutTrits.length);
        totalTrits[addressRest + 27] = multiUse ? 1 : 0;
        System.arraycopy(amountTrits, 0, totalTrits, addressRest + 27 + 1 + 81 - amountTrits.length, amountTrits.length);
        int[] checksumTrits = this.calculateChecksum(totalTrits);
        String checksum = Converter.trytes(checksumTrits);
        return checksum.substring(72, 81);
    }

    private int[] calculateChecksum(int[] trits) {
        this.curl.reset();
        this.curl.absorb(trits);
        int[] checksumTrits = new int[243];
        this.curl.squeeze(checksumTrits);
        return checksumTrits;
    }
}

