/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.config.types;

import java.io.File;
import java.util.List;
import java.util.Optional;
import org.iota.jota.account.AccountStore;
import org.iota.jota.account.store.AccountFileStore;
import org.iota.jota.config.IotaClientConfig;
import org.iota.jota.connection.Connection;
import org.iota.jota.store.FlatFileStore;
import org.iota.jota.store.PropertiesStore;

public class FileConfig
extends IotaClientConfig {
    private static final String DEFAULT_CONFIG_NAME = ".." + File.separator + "node_config.properties";
    private static final String CONFIG_NODE_PRE = "iota.node";
    private static final String CONFIG_PROT = "iota.node.protocol";
    private static final String CONFIG_HOST = "iota.node.host";
    private static final String CONFIG_PORT = "iota.node.port";
    private static final String CONFIG_TIMEOUT = "connection.timeout";
    private static final String CONFIG_STORE = "accounts.storage.url";
    private static final String CONFIG_MWM = "accounts.mwm";
    private static final String CONFIG_DEPTH = "accounts.depth";
    private static final String CONFIG_SECURITY = "accounts.security";

    public FileConfig() throws Exception {
        super(new FlatFileStore(DEFAULT_CONFIG_NAME));
    }

    public FileConfig(FlatFileStore store) throws Exception {
        super(store);
    }

    public FileConfig(String url) throws Exception {
        super(new FlatFileStore(url));
    }

    public FileConfig(Optional<String> url) throws Exception {
        super(new FlatFileStore(url.isPresent() ? url.get() : DEFAULT_CONFIG_NAME));
    }

    protected FileConfig(PropertiesStore store) throws Exception {
        super(store);
    }

    @Override
    public int getLegacyPort() {
        return this.intOrNull(CONFIG_PORT);
    }

    @Override
    public String getLegacyProtocol() {
        return this.stringOrNull(CONFIG_PROT);
    }

    @Override
    public String getLegacyHost() {
        return this.stringOrNull(CONFIG_HOST);
    }

    @Override
    public AccountStore getStore() {
        return new AccountFileStore(this.stringOrNull(CONFIG_STORE));
    }

    @Override
    public int getMwm() {
        return this.intOrNull(CONFIG_MWM);
    }

    @Override
    public int getDepth() {
        return this.intOrNull(CONFIG_DEPTH);
    }

    @Override
    public int getSecurityLevel() {
        return this.intOrNull(CONFIG_SECURITY);
    }

    @Override
    public int getConnectionTimeout() {
        return this.intOrNull(CONFIG_TIMEOUT);
    }

    @Override
    public List<Connection> getNodes() {
        return this.loadNodes(CONFIG_NODE_PRE);
    }
}

