/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.pow;

import java.util.Objects;
import org.iota.jota.pow.ICurl;
import org.iota.jota.pow.JCurl;
import org.iota.jota.pow.Kerl;

public class SpongeFactory {
    private SpongeFactory() {
        throw new AssertionError((Object)"Do not instantiate!");
    }

    public static ICurl create(Mode mode) {
        Objects.requireNonNull(mode, "Mode must not be null");
        switch (mode) {
            case CURL_P81: 
            case CURL_P27: {
                return new JCurl(mode);
            }
            case KERL: {
                return new Kerl();
            }
        }
        throw new IllegalArgumentException((Object)((Object)mode) + " is currently not supported.");
    }

    public static enum Mode {
        CURL_P81,
        CURL_P27,
        KERL;

    }
}

