/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.account;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iota.jota.account.AccountBalanceCache;
import org.iota.jota.account.AccountOptions;
import org.iota.jota.account.AccountState;
import org.iota.jota.account.AccountStore;
import org.iota.jota.account.PendingTransfer;
import org.iota.jota.account.addressgenerator.AddressGeneratorService;
import org.iota.jota.account.deposits.DepositRequest;
import org.iota.jota.account.deposits.StoredDepositAddress;
import org.iota.jota.account.errors.AccountError;
import org.iota.jota.account.errors.AddressGenerationError;
import org.iota.jota.account.inputselector.InputSelectionStrategy;
import org.iota.jota.model.Input;
import org.iota.jota.types.Address;
import org.iota.jota.types.Hash;
import org.iota.jota.types.Trytes;

public class AccountStateManager {
    private static volatile Object lock = new Object();
    private AccountStore store;
    private AccountState state;
    private AccountOptions options;
    private AddressGeneratorService addressService;
    private InputSelectionStrategy inputSelector;
    private String accountId;
    private AccountBalanceCache cache;

    public AccountStateManager(AccountBalanceCache cache, String accountId, InputSelectionStrategy inputSelector, AccountState state, AddressGeneratorService addressService, AccountOptions options, AccountStore store) {
        this.cache = cache;
        this.accountId = accountId;
        this.inputSelector = inputSelector;
        this.state = state;
        this.addressService = addressService;
        this.store = store;
        this.options = options;
    }

    public AccountState getAccountState() {
        return this.store.loadAccount(this.accountId);
    }

    public void save() {
        this.store.saveAccount(this.accountId, this.state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hash nextZeroValueAddress() throws AddressGenerationError {
        Object object = lock;
        synchronized (object) {
            return new Hash(this.cache.first().getAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Address getNextAddress() {
        Object object = lock;
        synchronized (object) {
            return this.addressService.get(this.getIndexAndIncrease());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Input createRemainder(long remainder) {
        Object object = lock;
        synchronized (object) {
            int key = this.getIndexAndIncrease();
            DepositRequest deposit = new DepositRequest(null, false, remainder);
            this.addDepositRequest(key, new StoredDepositAddress(deposit, this.options.getSecurityLevel()));
            Input remainderInput = new Input(this.addressService.get(key).getAddress().getHash(), remainder, key, this.options.getSecurityLevel());
            this.cache.addBalance(remainderInput, deposit);
            return remainderInput;
        }
    }

    private int getIndexAndIncrease() {
        int key = this.state.getKeyIndex();
        this.store.writeIndex(this.accountId, key + 1);
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Input> getInputAddresses(long value) throws AccountError {
        Object object = lock;
        synchronized (object) {
            List<Input> inputs = this.inputSelector.getInput(value, false);
            for (Input i : inputs) {
                this.store.removeDepositAddress(this.accountId, i.getKeyIndex());
                this.cache.removeInput(i);
            }
            return inputs;
        }
    }

    public long getTotalBalance() {
        return this.cache.getTotalBalance();
    }

    public long getAvailableBalance() {
        return this.inputSelector.getAvailableBalance();
    }

    public boolean isNew() {
        return this.state.isNew();
    }

    public int readIndex() {
        return this.state.getKeyIndex();
    }

    public void writeIndex(int index) {
        this.store.writeIndex(this.accountId, index);
    }

    public void addDepositRequest(int index, StoredDepositAddress request) {
        this.store.addDepositAddress(this.accountId, index, request);
    }

    public void removeDepositRequest(int index) {
        this.store.removeDepositAddress(this.accountId, index);
    }

    public Map<Integer, StoredDepositAddress> getDepositRequests() {
        return new HashMap<Integer, StoredDepositAddress>(this.store.getDepositAddresses(this.accountId));
    }

    public void addPendingTransfer(Hash tailTx, Trytes[] bundleTrytes, int ... indices) {
        this.store.addPendingTransfer(this.accountId, tailTx, bundleTrytes, indices);
    }

    public void removePendingTransfer(Hash tailHash) {
        this.store.removePendingTransfer(this.accountId, tailHash);
    }

    public void addTailHash(Hash tailHash, Hash newTailTxHash) {
        this.store.addTailHash(this.accountId, tailHash, newTailTxHash);
    }

    public Map<String, PendingTransfer> getPendingTransfers() {
        return this.store.getPendingTransfers(this.accountId);
    }

    public boolean isOwnAddress(String hash) {
        for (Map.Entry<Integer, StoredDepositAddress> entry : this.getDepositRequests().entrySet()) {
            if (!this.addressService.get(entry.getKey(), entry.getValue().getSecurityLevel()).getAddress().getHash().equals(hash)) continue;
            return true;
        }
        return false;
    }
}

