/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.store;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.iota.jota.store.MemoryStore;
import org.iota.jota.store.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlatFileStore
implements Store {
    private static final Logger log = LoggerFactory.getLogger(FlatFileStore.class);
    private File file;
    private InputStream inputStream;
    private OutputStream outputStream;
    protected MemoryStore memoryStore = null;

    public FlatFileStore(InputStream inputStream, OutputStream outputStream) {
        this.inputStream = inputStream;
        this.outputStream = outputStream;
    }

    public FlatFileStore(File file) {
        this.file = file;
    }

    public FlatFileStore(String location) {
        this.file = new File(location);
    }

    public FlatFileStore(URI location) {
        this.file = new File(location);
    }

    @Override
    public void load() throws Exception {
        if (null != this.file) {
            if (!this.file.exists()) {
                this.file.createNewFile();
            }
            if (!this.file.canRead() || !this.file.canWrite()) {
                log.debug(this.file.getName() + " not found. Rolling back for another solution...");
            }
            this.inputStream = new FileInputStream(this.file);
        }
        Map<String, Serializable> store = this.loadFromInputStream(this.inputStream);
        this.memoryStore = new MemoryStore(store);
        this.memoryStore.load();
        this.inputStream.close();
    }

    protected Map<String, Serializable> loadFromInputStream(InputStream stream) {
        HashMap<String, Serializable> store = new HashMap<String, Serializable>();
        try {
            Properties properties = new Properties();
            properties.load(stream);
            return properties;
        }
        catch (IOException e) {
            e.printStackTrace();
            return store;
        }
    }

    protected void writeToOutputStream(OutputStream stream, Map<String, Serializable> store) throws IOException {
        Properties properties = new Properties();
        properties.putAll(store);
        properties.store(stream, null);
    }

    @Override
    public void save(boolean closeResources) {
        this.memoryStore.save(closeResources);
        try {
            boolean closed = false;
            if (this.file != null && this.outputStream == null) {
                this.outputStream = new FileOutputStream(this.file);
                closed = true;
            }
            this.writeToOutputStream(this.outputStream, this.memoryStore.getAll());
            if (closed) {
                this.outputStream.close();
                this.outputStream = null;
            }
        }
        catch (IOException e) {
            log.warn("Failed to save config to disk! " + e.getMessage());
        }
        finally {
            if (closeResources) {
                try {
                    if (this.outputStream != null) {
                        this.outputStream.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public Serializable get(String key) {
        return this.memoryStore.get(key, null);
    }

    @Override
    public <T extends Serializable> T get(String key, T def) {
        return this.memoryStore.get(key, def);
    }

    @Override
    public <T extends Serializable> T set(String key, T value) {
        return this.memoryStore.set(key, value);
    }

    @Override
    public Map<String, Serializable> getAll() {
        return this.memoryStore.getAll();
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    public String toString() {
        return this.file.getName();
    }

    @Override
    public Serializable delete(String key) {
        return this.memoryStore.delete(key);
    }
}

