/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.store;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.iota.jota.store.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryStore
implements Store {
    private static final Logger log = LoggerFactory.getLogger(MemoryStore.class);
    private Map<String, Serializable> store;

    public MemoryStore() {
    }

    public MemoryStore(Map<String, Serializable> store) {
        this.store = store;
    }

    @Override
    public Serializable get(String key) {
        return this.get(key, null);
    }

    @Override
    public <T extends Serializable> T get(String key, T def) {
        try {
            Serializable prop = this.store.get(key);
            return (T)(prop != null ? prop : def);
        }
        catch (ClassCastException e) {
            return def;
        }
    }

    @Override
    public <T extends Serializable> T set(String key, T value) {
        try {
            Serializable oldValue;
            Serializable old = oldValue = this.store.put(key, value);
            return (T)old;
        }
        catch (ClassCastException e) {
            log.warn("Attempted to store a different type of value for a key.");
            log.warn("Explanation: " + e.getMessage());
            return null;
        }
    }

    @Override
    public void load() {
        if (this.store == null) {
            this.store = new ConcurrentHashMap<String, Serializable>();
        }
    }

    @Override
    public void save(boolean closeResources) {
    }

    @Override
    public Map<String, Serializable> getAll() {
        return this.store;
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    @Override
    public Serializable delete(String key) {
        return this.store.remove(key);
    }
}

