/*
 * Decompiled with CFR 0.152.
 */
package org.iota.mddoclet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import com.sun.javadoc.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import org.iota.mddoclet.DocumentMethodAnnotation;
import org.iota.mddoclet.data.ReturnParam;

public final class Util {
    private String repoUrl = null;

    public void setRepoUrl(String repoUrl) {
        this.repoUrl = repoUrl;
    }

    public String getRepoUrl() {
        return this.repoUrl;
    }

    public boolean shouldDisplayDimensions(Type type) {
        try {
            if (type.asParameterizedType() != null && !type.typeName().equals("Future") && !type.typeName().equals("Optional")) {
                if (type.asParameterizedType().typeArguments().length > 1) {
                    return true;
                }
                String name = type.asParameterizedType().typeArguments()[0].qualifiedTypeName();
                return name.startsWith("com.iota.") || name.startsWith("org.iota.");
            }
            return !type.dimension().equals("");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String dimension(Type type) {
        if (type.asParameterizedType() != null) {
            return type.asParameterizedType().typeName();
        }
        if (type.dimension().equals("[]")) {
            return "Array";
        }
        if (type.dimension().equals("[][]")) {
            return "2 dimensional Array";
        }
        return "";
    }

    public String dimensionType(Type type) {
        return type.simpleTypeName();
    }

    public boolean hasReturnClass(Tag[] tags) {
        return tags.length > 0 && tags[0].text().startsWith("{");
    }

    public ClassDoc getReturnClass(Tag[] tags) {
        if (tags.length > 0) {
            Tag tag = tags[0];
            for (Tag inlineTag : tag.inlineTags()) {
                if (!(inlineTag instanceof SeeTag)) continue;
                SeeTag seeTag = (SeeTag)inlineTag;
                return seeTag.referencedClass();
            }
        }
        return null;
    }

    public ReturnParam[] parseReturnTag(Tag[] tags, ClassDoc doc, MethodDoc method, DocumentMethodAnnotation api) {
        if (tags.length > 0) {
            Tag tag = tags[0];
            for (Tag t : tag.inlineTags()) {
                if (!t.name().equals("@link")) continue;
                if (doc == null) {
                    return new ReturnParam[0];
                }
                ReturnParam[] finalTags = this.parseGetters(doc);
                return finalTags;
            }
            if (!method.returnType().typeName().equals("void") && api.hasParam()) {
                return new ReturnParam[]{new ReturnParam(api.getParam(), this.processDescriptionAsMarkdown(tag.text()), method.returnType())};
            }
            int ret = tag.text().indexOf(": ");
            String name = "";
            if (ret > -1) {
                name = tag.text().substring(0, ret);
            }
            String text = ret > -1 ? tag.text().substring(ret) : tag.text();
            return new ReturnParam[]{new ReturnParam(name, this.processDescriptionAsMarkdown(text), method.returnType())};
        }
        if (!method.returnType().typeName().equals("void")) {
            return new ReturnParam[]{new ReturnParam("", "missing description", method.returnType())};
        }
        return new ReturnParam[0];
    }

    public ReturnParam[] parseParameters(MethodDoc doc) {
        ArrayList<ReturnParam> params = new ArrayList<ReturnParam>();
        for (int i = 0; i < doc.parameters().length; ++i) {
            String description = "missing description";
            if (doc.paramTags().length > i) {
                description = this.processDescriptionAsMarkdown(this.parseTag((Tag)doc.paramTags()[i]));
            }
            Parameter param = doc.parameters()[i];
            ReturnParam rp = new ReturnParam(param.name(), description, param.type());
            params.add(rp);
        }
        if (this.hasInheritDoc(doc)) {
            ReturnParam[] superParams = this.parseParameters(this.getOverridenMethod(doc));
            block1: for (ReturnParam currentPar : params) {
                if (!currentPar.getText().equals("missing description")) continue;
                for (ReturnParam par : superParams) {
                    if (!currentPar.getName().equals(par.getName())) continue;
                    currentPar.setText(par.getText());
                    continue block1;
                }
            }
        }
        return params.toArray(new ReturnParam[params.size()]);
    }

    public ReturnParam[] parseGetters(ClassDoc doc) {
        return this.parseGetters(doc, new ArrayList<ReturnParam>()).toArray(new ReturnParam[0]);
    }

    private List<ReturnParam> parseGetters(ClassDoc doc, List<ReturnParam> tags) {
        if (doc == null) {
            return tags;
        }
        if (doc.superclass() != null && !doc.superclass().name().equals(Object.class.getSimpleName())) {
            this.parseGetters(doc.superclass(), tags);
        }
        for (MethodDoc method : doc.methods()) {
            String fieldName;
            if (method.name().startsWith("get")) {
                fieldName = method.name().substring(3, 4).toLowerCase() + method.name().substring(4);
            } else {
                if (!method.name().startsWith("is")) continue;
                fieldName = method.name().substring(2, 3).toLowerCase() + method.name().substring(3);
            }
            ReturnParam rp = new ReturnParam(fieldName, this.parseFieldText((Doc)method), method.returnType());
            tags.add(rp);
        }
        return tags;
    }

    public String parseCommentText(Doc field) {
        StringBuilder builder = new StringBuilder();
        for (Tag inlineTag : field.inlineTags()) {
            if (inlineTag.name().equals("@inheritDoc") && field instanceof MethodDoc) {
                MethodDoc overriddenMethod = this.getOverridenMethod((MethodDoc)field);
                builder.append(this.parseCommentText((Doc)overriddenMethod));
                continue;
            }
            builder.append(this.parseTag(inlineTag));
        }
        return this.processDescriptionAsMarkdown(builder.toString());
    }

    public String parseFieldText(Doc field) {
        StringBuilder builder = new StringBuilder();
        for (Tag inlineTag : field.inlineTags()) {
            builder.append(this.parseTag(inlineTag));
        }
        for (int i = field.tags().length - 1; i >= 0; --i) {
            Tag tag = field.tags()[i];
            builder.append(this.parseTag(tag));
        }
        return this.processDescriptionAsMarkdown(builder.toString());
    }

    public String parseTag(Tag tag) {
        StringBuilder builder = new StringBuilder();
        if (tag.inlineTags().length > 1) {
            for (Tag inlineTag : tag.inlineTags()) {
                builder.append(this.parseTag(inlineTag));
            }
        } else if (tag instanceof SeeTag) {
            SeeTag seeTag = (SeeTag)tag;
            if (seeTag.name().equals("@see")) {
                ReturnParam[] seeFields;
                for (ReturnParam param : seeFields = this.parseGetters(seeTag.referencedClass())) {
                    builder.append("<BR/>");
                    builder.append("<b>");
                    builder.append(param.getName());
                    builder.append("</b>");
                    if (param.getText().equals("")) continue;
                    builder.append(": ");
                    builder.append(param.getText());
                }
            } else if (seeTag.name().equals("@link")) {
                builder.append(this.parseLinkAsUrl(seeTag));
            }
        } else if (tag instanceof ParamTag) {
            ParamTag paramTag = (ParamTag)tag;
            builder.append(paramTag.parameterComment());
        } else if (tag.name().equals("Text")) {
            builder.append(tag.text());
        }
        return builder.toString();
    }

    public String parseLinkAsUrl(SeeTag seeTag) {
        if (seeTag.referencedMember() != null) {
            if (seeTag.referencedMember().isPrivate()) {
                return this.parseFieldText((Doc)seeTag.referencedMember());
            }
            if (this.repoUrl != null) {
                return "[" + seeTag.referencedMemberName() + "](" + this.repoUrl + seeTag.referencedMember().containingClass().qualifiedName().replace('.', '/') + ".java#L" + seeTag.referencedMember().position().line() + ")";
            }
            return seeTag.referencedMemberName();
        }
        if (seeTag.referencedClass() != null) {
            if (this.repoUrl != null) {
                return "[" + seeTag.referencedClass().name() + "](" + this.repoUrl + seeTag.referencedClass().qualifiedName().replace('.', '/') + ".java)";
            }
            return seeTag.referencedClass().qualifiedName();
        }
        return "";
    }

    public String processDescriptionAsMarkdown(String text) {
        return this.processDescriptionAsMarkdown(text, true);
    }

    public String processDescriptionAsMarkdown(String text, boolean removeLineEndings) {
        try {
            if (removeLineEndings) {
                text = text.replaceAll("\\r\\n|\\r|\\n", "");
            }
            text = text.replaceAll("<b>", "**").replaceAll("</b>", "**");
            text = text.replaceAll("<strike>", "~~").replaceAll("</strike>", "~~");
            text = text.replaceAll("<s>", "~~").replaceAll("</s>", "~~");
            text = text.replaceAll("<u>", "__").replaceAll("</u>", "__");
            text = text.replaceAll("<i>", "_").replaceAll("</i>", "_");
            text = text.replaceAll("<code>", "`").replaceAll("</code>", "`");
            text = text.replaceAll("<tt>", "`").replaceAll("</tt>", "`");
            text = text.replaceAll("<li>", "* ").replaceAll("</li>", "<br/>");
            text = text.replaceAll("<ol>", "").replaceAll("</ol>", "");
            text = text.replaceAll("<ul>", "").replaceAll("</ul>", "");
            text = text.replaceAll("<br/>", System.lineSeparator());
            text = text.replaceAll("<p>", "").replaceAll("</p>", System.lineSeparator());
            text = text.replaceAll("    ", "");
            text = this.parseJavadocTag(text, "code", "`");
            return text;
        }
        catch (Exception e) {
            return "";
        }
    }

    private String parseJavadocTag(String string, String name, String toReplace) {
        return this.parseJavadocTag(string, name, toReplace, null);
    }

    private String parseJavadocTag(String string, String name, String toReplace, String toReplaceEnd) {
        int index = 0;
        String newText = string;
        while ((index = newText.indexOf("{@" + name, index)) > -1) {
            int closingBracket = newText.indexOf("}", index);
            StringBuilder sb = new StringBuilder(newText.substring(0, index));
            sb.append(toReplace);
            sb.append(newText.substring(index + name.length(), closingBracket));
            sb.append(toReplaceEnd != null ? toReplaceEnd : toReplace);
            sb.append(newText.substring(closingBracket + 1));
            newText = sb.toString();
        }
        return newText;
    }

    public String getTypeParamComment(TypeVariable variable) {
        String name = variable.simpleTypeName();
        ProgramElementDoc owner = variable.owner();
        if (owner.isClass()) {
            ClassDoc asClassDoc = (ClassDoc)owner;
            for (ParamTag tag : asClassDoc.typeParamTags()) {
                if (!name.equals(tag.parameterName())) continue;
                return tag.parameterComment();
            }
        }
        return "";
    }

    public MethodDoc getOverridenMethod(MethodDoc m) {
        MethodDoc found;
        if (m.overriddenMethod() != null) {
            return m.overriddenMethod();
        }
        for (ClassDoc c : m.containingClass().interfaces()) {
            found = this.checkClassForMethod(c, m);
            if (found == null) continue;
            return found;
        }
        for (ClassDoc c : m.containingClass().innerClasses(true)) {
            found = this.checkClassForMethod(c, m);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private boolean hasInheritDoc(MethodDoc doc) {
        for (Tag t : doc.inlineTags()) {
            if (!t.name().equals("@inheritDoc")) continue;
            return true;
        }
        return false;
    }

    private MethodDoc checkClassForMethod(ClassDoc c, MethodDoc m) {
        for (MethodDoc method : c.methods(true)) {
            if (!method.name().equals(m.name())) continue;
            return method;
        }
        return null;
    }

    public String getParamComment(TypeVariable variable) {
        String name = variable.simpleTypeName();
        ProgramElementDoc owner = variable.owner();
        if (owner.isClass()) {
            ClassDoc asClassDoc = (ClassDoc)owner;
            for (ParamTag tag : asClassDoc.typeParamTags()) {
                if (!name.equals(tag.parameterName())) continue;
                return tag.parameterComment();
            }
        }
        return "";
    }

    public Tag findTag(TypeVariable typeVar) {
        ProgramElementDoc owner = typeVar.owner();
        if (owner instanceof ExecutableMemberDoc) {
            for (ParamTag paramTag : ((ExecutableMemberDoc)owner).typeParamTags()) {
                if (!paramTag.parameterName().equals(typeVar.toString())) continue;
                return paramTag;
            }
        }
        if (owner instanceof ClassDoc) {
            for (ParamTag paramTag : ((ExecutableMemberDoc)owner).typeParamTags()) {
                if (!paramTag.parameterName().equals(typeVar.toString())) continue;
                return paramTag;
            }
        }
        return null;
    }
}

