/*
 * Decompiled with CFR 0.152.
 */
package org.iota.mddoclet.example;

import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.Type;
import java.security.SecureRandom;
import java.util.Random;
import org.iota.mddoclet.DocumentMethodAnnotation;
import org.iota.mddoclet.data.ReturnParam;
import org.iota.mddoclet.example.Export;

public abstract class BaseExport
implements Export {
    protected static final String CMD = "%cmd";
    protected static final String TYPE = "%response";
    protected static final String COMMAND_NAME = "%command";
    protected static final String PARAMETERS = "%parameters";
    protected static final String EXAMPLE = "%example";
    protected String requestDelim;
    protected String responseDelim;
    protected String requestFormat;
    protected String responseFormat;
    private Random random = new Random();
    private static final char[] TRYTE_ALPHABET = "9ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();

    @Override
    public String generateExample(MethodDoc command, DocumentMethodAnnotation api) {
        String post = this.getPost(command.returnType().typeName().equalsIgnoreCase("void"), command);
        StringBuilder generatedParams = new StringBuilder();
        boolean first = true;
        for (Parameter p : command.parameters()) {
            String name = p.name();
            if (!first) {
                generatedParams.append(this.getParamDelim());
            } else {
                first = false;
            }
            generatedParams.append(this.getIndent(true) + this.generateExampleForCallAndType(api, name, p.type()));
        }
        String type = command.returnType().simpleTypeName();
        if (command.returnType().asParameterizedType() != null) {
            type = type + "<" + command.returnType().asParameterizedType().typeArguments()[0].typeName() + ">";
        } else if (command.returnType().dimension().equals("[]")) {
            type = type + "[]";
        }
        post = post.replace(COMMAND_NAME, api.name());
        post = post.replace(PARAMETERS, generatedParams.toString());
        post = post.replace(TYPE, type);
        return post;
    }

    @Override
    public String generateResponse(MethodDoc command, DocumentMethodAnnotation api) {
        String start = this.getResponse();
        String responseObject = "\"duration\": " + this.randomInt();
        if (!command.returnType().typeName().equals("void") && api.hasParam()) {
            responseObject = responseObject + ", \"" + api.getParam() + "\": " + this.generateExampleForCallAndType(api, api.getParam(), command.returnType()) + "";
        }
        return start.replace(CMD, responseObject);
    }

    @Override
    public String generateResponse(MethodDoc command, DocumentMethodAnnotation api, ReturnParam[] fields) {
        String start = this.getResponse();
        StringBuilder generatedCommand = new StringBuilder("");
        for (int i = 0; i < fields.length; ++i) {
            ReturnParam field = fields[i];
            if (i != 0) {
                generatedCommand.append(", ");
            }
            generatedCommand.append(this.getIndent(false) + this.generateExampleForCallAndType(api, field.getName(), field.getReturnType()));
        }
        start = start.replace(CMD, generatedCommand.toString());
        return start;
    }

    @Override
    public String generateError() {
        return "{\"error\": \"'command' parameter has not been specified\"}";
    }

    protected String generateExampleForCallAndType(DocumentMethodAnnotation api, String argName, Type argType) {
        String example = this.exampleParamTemplate();
        String type = argType.typeName();
        if (argType.asParameterizedType() != null) {
            type = argType.asParameterizedType().typeArguments()[0].typeName();
        }
        String q = this.addQuotes(type) ? "\"" : "";
        StringBuilder generatedCommand = new StringBuilder("");
        if (argType.dimension().equals("[]")) {
            generatedCommand.append(this.arrayStart(type));
            generatedCommand.append(q + this.getExampleData(api.name(), argName, type) + q);
            generatedCommand.append(", ");
            generatedCommand.append(q + this.getExampleData(api.name(), argName, type) + q);
            generatedCommand.append(this.arrayEnd(type));
        } else if (argType.asParameterizedType() != null) {
            if (argType.simpleTypeName().equals("Optional")) {
                generatedCommand.append("Optional.of(" + q + this.getExampleData(api.name(), argName, type) + q + "");
            } else {
                generatedCommand.append(this.parameterisedStart(type, argType));
                generatedCommand.append(q + this.getExampleData(api.name(), argName, type) + q);
                generatedCommand.append(", ");
                generatedCommand.append(q + this.getExampleData(api.name(), argName, type) + q);
                generatedCommand.append(this.parameterisedEnd(type, argType));
            }
        } else {
            generatedCommand.append(q + this.getExampleData(api.name(), argName, type) + q);
        }
        example = example.replace(EXAMPLE, generatedCommand.toString());
        example = example.replace(COMMAND_NAME, argName);
        example = example.replace(TYPE, type);
        return example;
    }

    protected String parameterisedEnd(String type, Type argType) {
        return this.arrayEnd(type);
    }

    protected String parameterisedStart(String type, Type argType) {
        return this.arrayStart(type);
    }

    protected String arrayEnd(String type) {
        return "]";
    }

    protected String arrayStart(String type) {
        return "[";
    }

    protected String getExampleData(String command, String fullName, String returnType) {
        String name = fullName.toLowerCase();
        if (name.equals("minweightmagnitude")) {
            return "18";
        }
        if (name.equals("depth")) {
            return "15";
        }
        if (name.equals("security")) {
            return "3";
        }
        if (name.equals("threshold")) {
            return "100";
        }
        if (name.startsWith("uri")) {
            return "tcp://8.8.8.8:14265";
        }
        if (name.equals("trytes") || name.equals("trytes2") || name.contains("signature")) {
            return this.generateEllipseTrytes();
        }
        if (returnType.equals("Hash") || name.contains("address") || name.contains("milestone") && !name.contains("index")) {
            return this.randomHash();
        }
        if (name.contains("tag")) {
            return "TAG9" + BaseExport.generateTrytes(23);
        }
        if (name.equals("seed")) {
            return "YOUR9SECRET9SEED9999999...";
        }
        if (name.contains("memory")) {
            return this.randomInt(6) + "G";
        }
        if (returnType.equals("Integer") || returnType.equals("int") || returnType.equals("long")) {
            return this.randomInt() + "";
        }
        if (returnType.equals("Boolean") || returnType.equals("boolean")) {
            return this.randomBoolean();
        }
        if (returnType.equals("Neighbor") || returnType.equals("GetNeighborsResponse.Neighbor")) {
            String indent = this.getIndent(false) + this.getIndent(false);
            return "{ \n" + indent + "\"address\": \"8.8.8.8:14265\", \n" + indent + "\"numberOfAllTransactions\": \"" + this.randomInt() + "\", \n" + indent + "\"numberOfRandomTransactionRequests\": \"" + this.randomInt() + "\", \n" + indent + "\"numberOfNewTransactions\": \"" + this.randomInt() + "\", \n" + indent + "\"numberOfInvalidTransactions\": \"" + this.randomInt() + "\", \n" + indent + "\"numberOfStaleTransactions\": \"" + this.randomInt() + "\", \n" + indent + "\"numberOfSentTransactions\": \"" + this.randomInt() + "\", \n" + indent + "\"connectiontype\": \"" + this.randomConnectionType() + "\", \n}";
        }
        if (command.equals("getNodeInfo")) {
            return name;
        }
        if (returnType.equals("String")) {
            return this.randomHash();
        }
        return name;
    }

    protected abstract String getPost(boolean var1, MethodDoc var2);

    protected String getIndent(boolean request) {
        return "/n  ";
    }

    protected String getParamDelim() {
        return ", /n";
    }

    protected boolean addQuotes(String type) {
        return true;
    }

    protected String getResponse() {
        return "{%cmd}";
    }

    protected String exampleParamTemplate() {
        return "\"%command\": %example";
    }

    @Override
    public String getLanguage() {
        return this.getName();
    }

    private String randomConnectionType() {
        int rand = this.random.nextInt(2);
        return rand == 0 ? "TCP" : "UDP";
    }

    protected String randomBoolean() {
        int rand = this.random.nextInt(2);
        return rand == 0 ? "true" : "false";
    }

    protected String randomHash() {
        return BaseExport.generateTrytes(81);
    }

    protected String generateEllipseTrytes() {
        return BaseExport.generateTrytes(25) + " ... " + BaseExport.generateTrytes(25);
    }

    public static String generateTrytes(int size) {
        StringBuilder builder = new StringBuilder();
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < size; ++i) {
            char c = TRYTE_ALPHABET[random.nextInt(TRYTE_ALPHABET.length)];
            builder.append(c);
        }
        return builder.toString();
    }

    protected int randomInt() {
        return this.randomInt(999);
    }

    protected int randomInt(int max) {
        return this.random.nextInt(max) + 1;
    }
}

