/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.connection;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.iota.jota.connection.Connection;
import org.iota.jota.connection.IotaNodeHTTPService;
import org.iota.jota.dto.request.IotaAttachToTangleRequest;
import org.iota.jota.dto.request.IotaBroadcastTransactionRequest;
import org.iota.jota.dto.request.IotaCheckConsistencyRequest;
import org.iota.jota.dto.request.IotaCommandRequest;
import org.iota.jota.dto.request.IotaCustomRequest;
import org.iota.jota.dto.request.IotaFindTransactionsRequest;
import org.iota.jota.dto.request.IotaGetBalancesRequest;
import org.iota.jota.dto.request.IotaGetInclusionStateRequest;
import org.iota.jota.dto.request.IotaGetTransactionsToApproveRequest;
import org.iota.jota.dto.request.IotaGetTrytesRequest;
import org.iota.jota.dto.request.IotaNeighborsRequest;
import org.iota.jota.dto.request.IotaStoreTransactionsRequest;
import org.iota.jota.dto.request.IotaWereAddressesSpentFromRequest;
import org.iota.jota.dto.response.AddNeighborsResponse;
import org.iota.jota.dto.response.BroadcastTransactionsResponse;
import org.iota.jota.dto.response.CheckConsistencyResponse;
import org.iota.jota.dto.response.FindTransactionResponse;
import org.iota.jota.dto.response.GetAttachToTangleResponse;
import org.iota.jota.dto.response.GetBalancesResponse;
import org.iota.jota.dto.response.GetInclusionStateResponse;
import org.iota.jota.dto.response.GetNeighborsResponse;
import org.iota.jota.dto.response.GetNodeInfoResponse;
import org.iota.jota.dto.response.GetTipsResponse;
import org.iota.jota.dto.response.GetTransactionsToApproveResponse;
import org.iota.jota.dto.response.GetTrytesResponse;
import org.iota.jota.dto.response.InterruptAttachingToTangleResponse;
import org.iota.jota.dto.response.IotaCustomResponse;
import org.iota.jota.dto.response.RemoveNeighborsResponse;
import org.iota.jota.dto.response.StoreTransactionsResponse;
import org.iota.jota.dto.response.WereAddressesSpentFromResponse;
import org.iota.jota.error.AccessLimitedException;
import org.iota.jota.error.ArgumentException;
import org.iota.jota.error.ConnectorException;
import org.iota.jota.error.InternalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class HttpConnector
implements Connection {
    private static final Logger log = LoggerFactory.getLogger(HttpConnector.class);
    private static final int DEFAULT_PORT = 14265;
    private URL url;
    private IotaNodeHTTPService service;
    private OkHttpClient client;

    public HttpConnector(URL url) {
        this(url, 500);
    }

    public HttpConnector(String protocol, String host) throws MalformedURLException {
        this(new URL(protocol, host, 14265, ""));
    }

    public HttpConnector(String protocol, String host, int port) throws MalformedURLException {
        this(new URL(protocol, host, port, ""));
    }

    public HttpConnector(String protocol, String host, int port, int timeout) throws MalformedURLException {
        this(new URL(protocol, host, port, ""), timeout);
    }

    public HttpConnector(URL url, int timeout) {
        Objects.requireNonNull(url, "URL cannot be null");
        this.client = new OkHttpClient.Builder().connectTimeout((long)timeout, TimeUnit.SECONDS).writeTimeout((long)timeout, TimeUnit.SECONDS).readTimeout((long)timeout, TimeUnit.SECONDS).addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request request = chain.request();
                Request newRequest = request.newBuilder().addHeader("X-IOTA-API-Version", "1").build();
                return chain.proceed(newRequest);
            }
        }).build();
        this.url = url;
    }

    public HttpConnector(OkHttpClient client, String protocol, String host) throws MalformedURLException {
        this(client, new URL(protocol, host, 14265, ""));
    }

    public HttpConnector(OkHttpClient client, String protocol, String host, int port) throws MalformedURLException {
        this(client, new URL(protocol, host, port, ""));
    }

    public HttpConnector(OkHttpClient client, URL url) {
        Objects.requireNonNull(client, "Client cannot be null");
        Objects.requireNonNull(url, "URL cannot be null");
        this.url = url;
        this.client = client;
    }

    @Override
    public URL url() {
        return this.url;
    }

    @Override
    public boolean start() {
        Retrofit retrofit = new Retrofit.Builder().baseUrl(this.url.toExternalForm()).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.client).build();
        this.service = (IotaNodeHTTPService)retrofit.create(IotaNodeHTTPService.class);
        return true;
    }

    @Override
    public void stop() {
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HttpConnector other = (HttpConnector)obj;
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }

    @Override
    public boolean isConnectedToSameNode(Connection other) {
        return other.url() != null && other.url().equals(this.url());
    }

    public String toString() {
        return "HttpConnector [url=" + this.url + "]";
    }

    protected static <T> retrofit2.Response<T> wrapCheckedException(Call<T> call) throws ArgumentException, IllegalStateException, IllegalAccessError {
        try {
            retrofit2.Response res = call.execute();
            String error = null;
            if (res.errorBody() != null) {
                error = res.errorBody().string();
            }
            if (res.code() == 400) {
                throw new ArgumentException(error);
            }
            if (res.code() == 401) {
                throw new AccessLimitedException(error);
            }
            if (res.code() == 500) {
                throw new InternalException(error);
            }
            if (error != null || res.body() == null) {
                throw new ConnectorException(res.message(), res.code());
            }
            return res;
        }
        catch (IOException e) {
            log.error("Execution of the API call raised exception. IOTA Node not reachable?", (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
    }

    @Override
    public GetNodeInfoResponse getNodeInfo(IotaCommandRequest request) throws ArgumentException {
        Call<GetNodeInfoResponse> res = this.service.getNodeInfo(IotaCommandRequest.createNodeInfoRequest());
        return (GetNodeInfoResponse)HttpConnector.wrapCheckedException(res).body();
    }

    @Override
    public GetNeighborsResponse getNeighbors(IotaCommandRequest request) throws ArgumentException {
        Call<GetNeighborsResponse> res = this.service.getNeighbors(request);
        return (GetNeighborsResponse)HttpConnector.wrapCheckedException(res).body();
    }

    @Override
    public AddNeighborsResponse addNeighbors(IotaNeighborsRequest request) throws ArgumentException {
        Call<AddNeighborsResponse> res = this.service.addNeighbors(request);
        return (AddNeighborsResponse)HttpConnector.wrapCheckedException(res).body();
    }

    @Override
    public RemoveNeighborsResponse removeNeighbors(IotaNeighborsRequest request) throws ArgumentException {
        Call<RemoveNeighborsResponse> res = this.service.removeNeighbors(request);
        return (RemoveNeighborsResponse)HttpConnector.wrapCheckedException(res).body();
    }

    @Override
    public GetTipsResponse getTips(IotaCommandRequest request) throws ArgumentException {
        Call<GetTipsResponse> res = this.service.getTips(request);
        return (GetTipsResponse)HttpConnector.wrapCheckedException(res).body();
    }

    @Override
    public FindTransactionResponse findTransactions(IotaFindTransactionsRequest request) throws ArgumentException {
        Call<FindTransactionResponse> res = this.service.findTransactions(request);
        return (FindTransactionResponse)HttpConnector.wrapCheckedException(res).body();
    }

    @Override
    public GetInclusionStateResponse getInclusionStates(IotaGetInclusionStateRequest request) throws ArgumentException {
        Call<GetInclusionStateResponse> res = this.service.getInclusionStates(request);
        return (GetInclusionStateResponse)HttpConnector.wrapCheckedException(res).body();
    }

    @Override
    public GetTrytesResponse getTrytes(IotaGetTrytesRequest request) throws ArgumentException {
        Call<GetTrytesResponse> res = this.service.getTrytes(request);
        return (GetTrytesResponse)HttpConnector.wrapCheckedException(res).body();
    }

    @Override
    public GetTransactionsToApproveResponse getTransactionsToApprove(IotaGetTransactionsToApproveRequest request) throws ArgumentException {
        Call<GetTransactionsToApproveResponse> res = this.service.getTransactionsToApprove(request);
        return (GetTransactionsToApproveResponse)HttpConnector.wrapCheckedException(res).body();
    }

    @Override
    public GetBalancesResponse getBalances(IotaGetBalancesRequest request) throws ArgumentException {
        Call<GetBalancesResponse> res = this.service.getBalances(request);
        return (GetBalancesResponse)HttpConnector.wrapCheckedException(res).body();
    }

    @Override
    public GetAttachToTangleResponse attachToTangle(IotaAttachToTangleRequest request) throws ArgumentException {
        Call<GetAttachToTangleResponse> res = this.service.attachToTangle(request);
        return (GetAttachToTangleResponse)HttpConnector.wrapCheckedException(res).body();
    }

    @Override
    public InterruptAttachingToTangleResponse interruptAttachingToTangle(IotaCommandRequest request) throws ArgumentException {
        Call<InterruptAttachingToTangleResponse> res = this.service.interruptAttachingToTangle(request);
        return (InterruptAttachingToTangleResponse)HttpConnector.wrapCheckedException(res).body();
    }

    @Override
    public BroadcastTransactionsResponse broadcastTransactions(IotaBroadcastTransactionRequest request) throws ArgumentException {
        Call<BroadcastTransactionsResponse> res = this.service.broadcastTransactions(request);
        return (BroadcastTransactionsResponse)HttpConnector.wrapCheckedException(res).body();
    }

    @Override
    public StoreTransactionsResponse storeTransactions(IotaStoreTransactionsRequest request) throws ArgumentException {
        Call<StoreTransactionsResponse> res = this.service.storeTransactions(request);
        return (StoreTransactionsResponse)HttpConnector.wrapCheckedException(res).body();
    }

    @Override
    public CheckConsistencyResponse checkConsistency(IotaCheckConsistencyRequest request) throws ArgumentException {
        Call<CheckConsistencyResponse> res = this.service.checkConsistency(request);
        return (CheckConsistencyResponse)HttpConnector.wrapCheckedException(res).body();
    }

    @Override
    public WereAddressesSpentFromResponse wereAddressesSpentFrom(IotaWereAddressesSpentFromRequest request) throws ArgumentException {
        Call<WereAddressesSpentFromResponse> res = this.service.wereAddressesSpentFrom(request);
        return (WereAddressesSpentFromResponse)HttpConnector.wrapCheckedException(res).body();
    }

    @Override
    public IotaCustomResponse customRequest(IotaCustomRequest customRequest) {
        Call<IotaCustomResponse> res = this.service.customRequest(customRequest);
        return (IotaCustomResponse)HttpConnector.wrapCheckedException(res).body();
    }
}

