/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.iota.jota.config.Config;
import org.iota.jota.config.types.EnvConfig;
import org.iota.jota.config.types.IotaDefaultConfig;
import org.iota.jota.config.types.PropertiesConfig;
import org.iota.jota.store.PropertiesStore;
import org.slf4j.Logger;

public abstract class AbstractBuilder<T, E, F extends Config> {
    private Logger log;
    private Config config;

    public AbstractBuilder(Logger log) {
        this.log = log;
    }

    public E build() {
        try {
            this.generate();
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
            e.printStackTrace();
            return null;
        }
        return this.compile();
    }

    protected abstract E compile();

    protected abstract T generate() throws Exception;

    public T config(F config) {
        try {
            this.setConfig((Config)config);
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
        }
        return (T)this;
    }

    public T config(Properties properties) {
        try {
            this.setConfig(new PropertiesConfig(new PropertiesStore(properties)));
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
        }
        return (T)this;
    }

    public T config(PropertiesConfig properties) {
        this.setConfig(properties);
        return (T)this;
    }

    protected List<F> getConfigs() throws Exception {
        EnvConfig env = new EnvConfig();
        ArrayList<Config> array = new ArrayList<Config>();
        array.add(env);
        if (this.config != null) {
            array.add(this.config);
        }
        array.add(new IotaDefaultConfig());
        return array;
    }

    public Config getConfig() {
        return this.config;
    }

    private void setConfig(Config config) {
        this.config = config;
    }
}

