/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.utils.log.interval;

import java.text.DecimalFormat;
import org.iota.jota.utils.log.ProgressLogger;
import org.iota.jota.utils.log.interval.IntervalLogger;
import org.slf4j.Logger;

public class IntervalProgressLogger
implements ProgressLogger {
    private static final int DEFAULT_LOG_INTERVAL = 3000;
    private final String taskName;
    private final IntervalLogger intervalLogger;
    private int currentStep = 0;
    private int stepCount = 1;

    public IntervalProgressLogger(String taskName, Class<?> clazz) {
        this(taskName, clazz, 3000);
    }

    public IntervalProgressLogger(String taskName, Logger logger) {
        this(taskName, logger, 3000);
    }

    public IntervalProgressLogger(String taskName, Class<?> clazz, int logInterval) {
        this.taskName = taskName;
        this.intervalLogger = new IntervalLogger(clazz, logInterval);
    }

    public IntervalProgressLogger(String taskName, Logger logger, int logInterval) {
        this.taskName = taskName;
        this.intervalLogger = new IntervalLogger(logger, logInterval);
    }

    @Override
    public IntervalProgressLogger start() {
        return this.setCurrentStep(0).triggerOutput();
    }

    @Override
    public IntervalProgressLogger start(int stepCount) {
        return this.setStepCount(stepCount).setCurrentStep(0).triggerOutput();
    }

    @Override
    public IntervalProgressLogger progress() {
        return this.setCurrentStep(++this.currentStep).triggerOutput();
    }

    @Override
    public IntervalProgressLogger progress(int currentStep) {
        return this.setCurrentStep(currentStep).triggerOutput();
    }

    @Override
    public IntervalProgressLogger finish() {
        return this.setCurrentStep(this.stepCount).triggerOutput(true);
    }

    @Override
    public IntervalProgressLogger abort() {
        return this.abort(null);
    }

    @Override
    public IntervalProgressLogger abort(Throwable cause) {
        double progress = Math.min(100.0, (double)this.currentStep / (double)this.stepCount * 100.0);
        String logMessage = this.taskName + ": " + new DecimalFormat("#.00").format(progress) + "% ... [FAILED]";
        if (cause != null) {
            this.intervalLogger.error(logMessage, cause);
        } else {
            this.intervalLogger.error(logMessage);
        }
        return this;
    }

    @Override
    public int getCurrentStep() {
        return this.currentStep;
    }

    @Override
    public IntervalProgressLogger setCurrentStep(int currentStep) {
        this.currentStep = currentStep;
        return this;
    }

    @Override
    public int getStepCount() {
        return this.stepCount;
    }

    @Override
    public IntervalProgressLogger setStepCount(int stepCount) {
        this.stepCount = stepCount;
        return this;
    }

    @Override
    public boolean getEnabled() {
        return this.intervalLogger.getEnabled();
    }

    @Override
    public IntervalProgressLogger setEnabled(boolean enabled) {
        this.intervalLogger.setEnabled(enabled);
        return this;
    }

    private IntervalProgressLogger triggerOutput() {
        return this.triggerOutput(false);
    }

    private IntervalProgressLogger triggerOutput(boolean printImmediately) {
        if (this.stepCount != 0) {
            double progress = Math.min(100.0, (double)this.currentStep / (double)this.stepCount * 100.0);
            String logMessage = this.taskName + ": " + new DecimalFormat("0.00").format(progress) + "% ..." + (this.currentStep >= this.stepCount ? " [DONE]" : "");
            this.intervalLogger.info(logMessage);
            if (printImmediately) {
                this.intervalLogger.triggerOutput(true);
            }
        }
        return this;
    }
}

