/*
 * Decompiled with CFR 0.152.
 */
package io.ipfs.api;

import io.ipfs.api.JSONParser;
import io.ipfs.cid.Cid;
import io.ipfs.multihash.Multihash;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class MerkleNode {
    public final Multihash hash;
    public final Optional<String> name;
    public final Optional<Integer> size;
    public final Optional<String> largeSize;
    public final Optional<Integer> type;
    public final List<MerkleNode> links;
    public final Optional<byte[]> data;

    public MerkleNode(String hash, Optional<String> name, Optional<Integer> size, Optional<String> largeSize, Optional<Integer> type, List<MerkleNode> links, Optional<byte[]> data) {
        this.name = name;
        this.hash = Cid.decode((String)hash);
        this.size = size;
        this.largeSize = largeSize;
        this.type = type;
        this.links = links;
        this.data = data;
    }

    public MerkleNode(String hash) {
        this(hash, Optional.empty());
    }

    public MerkleNode(String hash, Optional<String> name) {
        this(hash, name, Optional.empty(), Optional.empty(), Optional.empty(), Arrays.asList(new MerkleNode[0]), Optional.empty());
    }

    public boolean equals(Object b) {
        if (!(b instanceof MerkleNode)) {
            return false;
        }
        MerkleNode other = (MerkleNode)b;
        return this.hash.equals((Object)other.hash);
    }

    public int hashCode() {
        return this.hash.hashCode();
    }

    public static MerkleNode fromJSON(Object rawjson) {
        if (rawjson instanceof String) {
            return new MerkleNode((String)rawjson);
        }
        Map json = (Map)rawjson;
        if ("error".equals(json.get("Type"))) {
            throw new IllegalStateException("Remote IPFS error: " + json.get("Message"));
        }
        String hash = (String)json.get("Hash");
        if (hash == null) {
            hash = (String)json.get("Key");
        }
        if (hash == null && json.containsKey("Cid")) {
            hash = (String)((Map)json.get("Cid")).get("/");
        }
        Optional<String> name = json.containsKey("Name") ? Optional.of((String)json.get("Name")) : Optional.empty();
        Object rawSize = json.get("Size");
        Optional<Integer> size = rawSize instanceof Integer ? Optional.of((Integer)rawSize) : Optional.empty();
        Optional<String> largeSize = rawSize instanceof String ? Optional.of((String)json.get("Size")) : Optional.empty();
        Optional<Integer> type = json.containsKey("Type") ? Optional.of((Integer)json.get("Type")) : Optional.empty();
        List linksRaw = (List)json.get("Links");
        List<MerkleNode> links = linksRaw == null ? Collections.emptyList() : linksRaw.stream().map(x -> MerkleNode.fromJSON(x)).collect(Collectors.toList());
        Optional<byte[]> data = json.containsKey("Data") ? Optional.of(((String)json.get("Data")).getBytes()) : Optional.empty();
        return new MerkleNode(hash, name, size, largeSize, type, links, data);
    }

    public Object toJSON() {
        TreeMap<String, Object> res = new TreeMap<String, Object>();
        res.put("Hash", this.hash);
        res.put("Links", this.links.stream().map(x -> x.hash).collect(Collectors.toList()));
        this.data.ifPresent(bytes -> res.put("Data", bytes));
        this.name.ifPresent(s -> res.put("Name", s));
        if (this.size.isPresent()) {
            res.put("Size", this.size.get());
        } else {
            this.largeSize.ifPresent(s -> res.put("Size", s));
        }
        this.type.ifPresent(integer -> res.put("Type", integer));
        return res;
    }

    public String toJSONString() {
        return JSONParser.toString(this.toJSON());
    }
}

