/*
 * Decompiled with CFR 0.152.
 */
package io.ipfs.api;

import java.util.function.Function;

public class Pair<L, R> {
    public final L left;
    public final R right;

    public Pair(L left, R right) {
        this.left = left;
        this.right = right;
    }

    public Pair<R, L> swapped() {
        return new Pair<R, L>(this.right, this.left);
    }

    public <B, D> Pair<B, D> apply(Function<L, B> applyLeft, Function<R, D> applyRight) {
        return new Pair<B, D>(applyLeft.apply(this.left), applyRight.apply(this.right));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        if (this.left != null ? !this.left.equals(pair.left) : pair.left != null) {
            return false;
        }
        return this.right != null ? this.right.equals(pair.right) : pair.right == null;
    }

    public int hashCode() {
        int result = this.left != null ? this.left.hashCode() : 0;
        result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("(%s, %s)", this.left.toString(), this.right.toString());
    }
}

