/*
 * Decompiled with CFR 0.152.
 */
package io.ipfs.multibase;

import io.ipfs.multibase.Base16;
import io.ipfs.multibase.Base58;
import java.util.Map;
import java.util.TreeMap;

public class Multibase {
    public static String encode(Base b, byte[] data) {
        switch (b) {
            case Base58BTC: {
                return b.prefix + Base58.encode(data);
            }
            case Base16: {
                return b.prefix + Base16.encode(data);
            }
        }
        throw new IllegalStateException("Unsupported base encoding: " + b.name());
    }

    public static Base encoding(String data) {
        return Base.lookup(data.charAt(0));
    }

    public static byte[] decode(String data) {
        Base b = Multibase.encoding(data);
        String rest = data.substring(1);
        switch (b) {
            case Base58BTC: {
                return Base58.decode(rest);
            }
            case Base16: {
                return Base16.decode(rest);
            }
        }
        throw new IllegalStateException("Unsupported base encoding: " + b.name());
    }

    public static enum Base {
        Base1('1'),
        Base2('0'),
        Base8('7'),
        Base10('9'),
        Base16('f'),
        Base58Flickr('Z'),
        Base58BTC('z');

        public char prefix;
        private static Map<Character, Base> lookup;

        private Base(char prefix) {
            this.prefix = prefix;
        }

        public static Base lookup(char p) {
            if (!lookup.containsKey(Character.valueOf(p))) {
                throw new IllegalStateException("Unknown Multibase type: " + p);
            }
            return lookup.get(Character.valueOf(p));
        }

        static {
            lookup = new TreeMap<Character, Base>();
            for (Base b : Base.values()) {
                lookup.put(Character.valueOf(b.prefix), b);
            }
        }
    }
}

