/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.quad;

import java.math.BigDecimal;
import java.util.List;
import org.drools.model.Global;
import org.drools.model.RuleItemBuilder;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.function.ToIntQuadFunction;
import org.optaplanner.core.api.function.ToLongQuadFunction;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintFactory;
import org.optaplanner.core.impl.score.stream.drools.quad.DroolsAbstractQuadConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.quad.DroolsQuadCondition;

public final class DroolsScoringQuadConstraintStream<Solution_, A, B, C, D>
extends DroolsAbstractQuadConstraintStream<Solution_, A, B, C, D> {
    private final boolean noMatchWeigher;
    private final ToIntQuadFunction<A, B, C, D> intMatchWeigher;
    private final ToLongQuadFunction<A, B, C, D> longMatchWeigher;
    private final QuadFunction<A, B, C, D, BigDecimal> bigDecimalMatchWeigher;

    public DroolsScoringQuadConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractQuadConstraintStream<Solution_, A, B, C, D> parent) {
        this(constraintFactory, parent, true, null, null, null);
    }

    public DroolsScoringQuadConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractQuadConstraintStream<Solution_, A, B, C, D> parent, ToIntQuadFunction<A, B, C, D> intMatchWeigher) {
        this(constraintFactory, parent, false, intMatchWeigher, null, null);
        if (intMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    public DroolsScoringQuadConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractQuadConstraintStream<Solution_, A, B, C, D> parent, ToLongQuadFunction<A, B, C, D> longMatchWeigher) {
        this(constraintFactory, parent, false, null, longMatchWeigher, null);
        if (longMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    public DroolsScoringQuadConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractQuadConstraintStream<Solution_, A, B, C, D> parent, QuadFunction<A, B, C, D, BigDecimal> bigDecimalMatchWeigher) {
        this(constraintFactory, parent, false, null, null, bigDecimalMatchWeigher);
        if (bigDecimalMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    private DroolsScoringQuadConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractQuadConstraintStream<Solution_, A, B, C, D> parent, boolean noMatchWeigher, ToIntQuadFunction<A, B, C, D> intMatchWeigher, ToLongQuadFunction<A, B, C, D> longMatchWeigher, QuadFunction<A, B, C, D, BigDecimal> bigDecimalMatchWeigher) {
        super(constraintFactory, parent);
        this.noMatchWeigher = noMatchWeigher;
        this.intMatchWeigher = intMatchWeigher;
        this.longMatchWeigher = longMatchWeigher;
        this.bigDecimalMatchWeigher = bigDecimalMatchWeigher;
    }

    @Override
    public List<RuleItemBuilder<?>> createRuleItemBuilders(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal) {
        DroolsQuadCondition<A, B, C, D, ?> condition = ((DroolsAbstractQuadConstraintStream)this.parent).getCondition();
        if (this.intMatchWeigher != null) {
            return condition.completeWithScoring(scoreHolderGlobal, this.intMatchWeigher);
        }
        if (this.longMatchWeigher != null) {
            return condition.completeWithScoring(scoreHolderGlobal, this.longMatchWeigher);
        }
        if (this.bigDecimalMatchWeigher != null) {
            return condition.completeWithScoring(scoreHolderGlobal, this.bigDecimalMatchWeigher);
        }
        if (this.noMatchWeigher) {
            return condition.completeWithScoring(scoreHolderGlobal);
        }
        throw new IllegalStateException("Impossible state: noMatchWeigher (" + this.noMatchWeigher + ").");
    }

    @Override
    public DroolsQuadCondition<A, B, C, D, ?> getCondition() {
        throw new UnsupportedOperationException("Scoring stream does not have its own QuadCondition.");
    }

    @Override
    public Class[] getExpectedJustificationTypes() {
        return ((DroolsAbstractQuadConstraintStream)this.parent).getCondition().getExpectedJustificationTypes();
    }

    public String toString() {
        return "QuadScoring()";
    }
}

