/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.tri;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.function.UnaryOperator;
import org.drools.model.DSL;
import org.drools.model.Drools;
import org.drools.model.Global;
import org.drools.model.PatternDSL;
import org.drools.model.RuleItemBuilder;
import org.drools.model.Variable;
import org.drools.model.consequences.ConsequenceBuilder;
import org.drools.model.functions.Block5;
import org.drools.model.functions.Function3;
import org.drools.model.functions.Predicate4;
import org.drools.model.functions.Predicate5;
import org.optaplanner.core.api.function.QuadPredicate;
import org.optaplanner.core.api.function.ToIntTriFunction;
import org.optaplanner.core.api.function.ToLongTriFunction;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.function.TriPredicate;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;
import org.optaplanner.core.api.score.stream.quad.QuadJoiner;
import org.optaplanner.core.api.score.stream.tri.TriConstraintCollector;
import org.optaplanner.core.impl.score.stream.drools.bi.DroolsBiCondition;
import org.optaplanner.core.impl.score.stream.drools.common.BiTuple;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsCondition;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsPatternBuilder;
import org.optaplanner.core.impl.score.stream.drools.common.QuadTuple;
import org.optaplanner.core.impl.score.stream.drools.common.TriTuple;
import org.optaplanner.core.impl.score.stream.drools.quad.DroolsQuadCondition;
import org.optaplanner.core.impl.score.stream.drools.quad.DroolsQuadRuleStructure;
import org.optaplanner.core.impl.score.stream.drools.tri.DroolsTriAccumulateFunctionBridge;
import org.optaplanner.core.impl.score.stream.drools.tri.DroolsTriGroupByInvoker;
import org.optaplanner.core.impl.score.stream.drools.tri.DroolsTriRuleStructure;
import org.optaplanner.core.impl.score.stream.drools.tri.DroolsTriToBiGroupByInvoker;
import org.optaplanner.core.impl.score.stream.drools.tri.DroolsTriToQuadGroupByInvoker;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsUniCondition;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsUniRuleStructure;
import org.optaplanner.core.impl.score.stream.quad.AbstractQuadJoiner;
import org.optaplanner.core.impl.score.stream.quad.FilteringQuadJoiner;
import org.optaplanner.core.impl.score.stream.quad.NoneQuadJoiner;
import org.optaplanner.core.impl.score.stream.tri.NoneTriJoiner;

public final class DroolsTriCondition<A, B, C, PatternVar>
extends DroolsCondition<PatternVar, DroolsTriRuleStructure<A, B, C, PatternVar>> {
    public DroolsTriCondition(DroolsTriRuleStructure<A, B, C, PatternVar> ruleStructure) {
        super(ruleStructure);
    }

    public DroolsTriCondition<A, B, C, PatternVar> andFilter(TriPredicate<A, B, C> predicate) {
        Predicate4 & Serializable filter = (Predicate4 & Serializable)(__, a, b, c) -> predicate.test(a, b, c);
        Variable aVariable = ((DroolsTriRuleStructure)this.ruleStructure).getA();
        Variable bVariable = ((DroolsTriRuleStructure)this.ruleStructure).getB();
        Variable cVariable = ((DroolsTriRuleStructure)this.ruleStructure).getC();
        DroolsPatternBuilder newTargetPattern = ((DroolsTriRuleStructure)this.ruleStructure).getPrimaryPatternBuilder().expand(p -> p.expr("Filter using " + predicate, aVariable, bVariable, cVariable, filter));
        DroolsTriRuleStructure newRuleStructure = new DroolsTriRuleStructure(aVariable, bVariable, cVariable, newTargetPattern, ((DroolsTriRuleStructure)this.ruleStructure).getShelvedRuleItems(), ((DroolsTriRuleStructure)this.ruleStructure).getPrerequisites(), ((DroolsTriRuleStructure)this.ruleStructure).getDependents(), ((DroolsTriRuleStructure)this.ruleStructure).getVariableIdSupplier());
        return new DroolsTriCondition(newRuleStructure);
    }

    public <D, DPatternVar> DroolsQuadCondition<A, B, C, D, DPatternVar> andJoin(DroolsUniCondition<D, DPatternVar> dCondition, AbstractQuadJoiner<A, B, C, D> quadJoiner) {
        DroolsUniRuleStructure dRuleStructure = (DroolsUniRuleStructure)dCondition.getRuleStructure();
        Variable dVariable = dRuleStructure.getA();
        UnaryOperator expander = p -> p.expr("Filter using " + quadJoiner, ((DroolsTriRuleStructure)this.ruleStructure).getA(), ((DroolsTriRuleStructure)this.ruleStructure).getB(), ((DroolsTriRuleStructure)this.ruleStructure).getC(), dVariable, (Predicate5 & Serializable)(__, a, b, c, d) -> quadJoiner.matches(a, b, c, d));
        DroolsUniRuleStructure newDRuleStructure = dRuleStructure.amend(expander);
        return new DroolsQuadCondition(new DroolsQuadRuleStructure((DroolsTriRuleStructure)this.ruleStructure, newDRuleStructure, ((DroolsTriRuleStructure)this.ruleStructure).getVariableIdSupplier()));
    }

    @SafeVarargs
    public final <D> DroolsTriCondition<A, B, C, PatternVar> andIfExists(Class<D> otherClass, QuadJoiner<A, B, C, D> ... joiners) {
        return this.andIfExistsOrNot(true, otherClass, joiners);
    }

    @SafeVarargs
    public final <D> DroolsTriCondition<A, B, C, PatternVar> andIfNotExists(Class<D> otherClass, QuadJoiner<A, B, C, D> ... joiners) {
        return this.andIfExistsOrNot(false, otherClass, joiners);
    }

    @SafeVarargs
    private final <D> DroolsTriCondition<A, B, C, PatternVar> andIfExistsOrNot(boolean shouldExist, Class<D> otherClass, QuadJoiner<A, B, C, D> ... joiners) {
        int indexOfFirstFilter = -1;
        AbstractQuadJoiner finalJoiner = null;
        QuadPredicate finalFilter = null;
        for (int i = 0; i < joiners.length; ++i) {
            boolean hasAFilter;
            AbstractQuadJoiner joiner = (AbstractQuadJoiner)joiners[i];
            boolean bl = hasAFilter = indexOfFirstFilter >= 0;
            if (joiner instanceof NoneQuadJoiner && joiners.length > 1) {
                throw new IllegalStateException("If present, " + NoneTriJoiner.class + " must be the only joiner, got " + Arrays.toString(joiners) + " instead.");
            }
            if (!(joiner instanceof FilteringQuadJoiner)) {
                if (hasAFilter) {
                    throw new IllegalStateException("Indexing joiner (" + joiner + ") must not follow a filtering joiner (" + joiners[indexOfFirstFilter] + ").");
                }
                finalJoiner = finalJoiner == null ? joiner : AbstractQuadJoiner.merge(finalJoiner, joiner);
                continue;
            }
            if (!hasAFilter) {
                indexOfFirstFilter = i;
            }
            finalFilter = finalFilter == null ? joiner.getFilter() : finalFilter.and(joiner.getFilter());
        }
        return this.applyJoiners(otherClass, finalJoiner, finalFilter, shouldExist);
    }

    private <D> DroolsTriCondition<A, B, C, PatternVar> applyJoiners(Class<D> otherClass, AbstractQuadJoiner<A, B, C, D> joiner, QuadPredicate<A, B, C, D> predicate, boolean shouldExist) {
        Variable<D> toExist = ((DroolsTriRuleStructure)this.ruleStructure).createVariable(otherClass, "triToExist");
        PatternDSL.PatternDef existencePattern = PatternDSL.pattern(toExist);
        if (joiner == null) {
            return this.applyFilters(existencePattern, predicate, shouldExist);
        }
        QuadPredicate<Object, Object, Object, Object> joinFilter = joiner::matches;
        QuadPredicate<Object, Object, Object, Object> result = predicate == null ? joinFilter : joinFilter.and(predicate);
        return this.applyFilters(existencePattern, result, shouldExist);
    }

    private <D> DroolsTriCondition<A, B, C, PatternVar> applyFilters(PatternDSL.PatternDef<D> existencePattern, QuadPredicate<A, B, C, D> predicate, boolean shouldExist) {
        PatternDSL.PatternDef possiblyFilteredExistencePattern = predicate == null ? existencePattern : existencePattern.expr("Filter using " + predicate, ((DroolsTriRuleStructure)this.ruleStructure).getA(), ((DroolsTriRuleStructure)this.ruleStructure).getB(), ((DroolsTriRuleStructure)this.ruleStructure).getC(), (Predicate4 & Serializable)(d, a, b, c) -> predicate.test(a, b, c, d));
        return new DroolsTriCondition(((DroolsTriRuleStructure)this.ruleStructure).existsOrNot(possiblyFilteredExistencePattern, shouldExist));
    }

    public <NewA, __> DroolsUniCondition<NewA, NewA> andCollect(TriConstraintCollector<A, B, C, __, NewA> collector) {
        DroolsTriAccumulateFunctionBridge<A, B, C, __, NewA> bridge = new DroolsTriAccumulateFunctionBridge<A, B, C, __, NewA>(collector);
        return this.collect(bridge, (pattern, tuple) -> pattern.bind(tuple, ((DroolsTriRuleStructure)this.ruleStructure).getA(), ((DroolsTriRuleStructure)this.ruleStructure).getB(), (Function3 & Serializable)(c, a, b) -> new TriTuple<Object, Object, Object>(a, b, c)));
    }

    public <NewA> DroolsUniCondition<NewA, NewA> andGroup(TriFunction<A, B, C, NewA> groupKeyMapping) {
        return super.group((pattern, tuple) -> pattern.bind(tuple, ((DroolsTriRuleStructure)this.ruleStructure).getA(), ((DroolsTriRuleStructure)this.ruleStructure).getB(), (Function3 & Serializable)(c, a, b) -> groupKeyMapping.apply(a, b, c)));
    }

    public <NewA, NewB> DroolsBiCondition<NewA, NewB, BiTuple<NewA, NewB>> andGroupWithCollect(TriFunction<A, B, C, NewA> groupKeyMapping, TriConstraintCollector<A, B, C, ?, NewB> collector) {
        return this.groupWithCollect(() -> new DroolsTriToBiGroupByInvoker(groupKeyMapping, collector, ((DroolsTriRuleStructure)this.getRuleStructure()).getA(), ((DroolsTriRuleStructure)this.getRuleStructure()).getB(), ((DroolsTriRuleStructure)this.getRuleStructure()).getC()));
    }

    public <NewA, NewB> DroolsBiCondition<NewA, NewB, BiTuple<NewA, NewB>> andGroupBi(TriFunction<A, B, C, NewA> groupKeyAMapping, TriFunction<A, B, C, NewB> groupKeyBMapping) {
        return this.groupBi((pattern, tuple) -> pattern.bind(tuple, ((DroolsTriRuleStructure)this.ruleStructure).getA(), ((DroolsTriRuleStructure)this.ruleStructure).getB(), (Function3 & Serializable)(c, a, b) -> {
            Object newA = groupKeyAMapping.apply(a, b, c);
            Object newB = groupKeyBMapping.apply(a, b, c);
            return new BiTuple(newA, newB);
        }));
    }

    public <NewA, NewB, NewC> DroolsTriCondition<NewA, NewB, NewC, TriTuple<NewA, NewB, NewC>> andGroupBiWithCollect(TriFunction<A, B, C, NewA> groupKeyAMapping, TriFunction<A, B, C, NewB> groupKeyBMapping, TriConstraintCollector<A, B, C, ?, NewC> collector) {
        return this.groupBiWithCollect(() -> new DroolsTriGroupByInvoker(groupKeyAMapping, groupKeyBMapping, collector, ((DroolsTriRuleStructure)this.getRuleStructure()).getA(), ((DroolsTriRuleStructure)this.getRuleStructure()).getB(), ((DroolsTriRuleStructure)this.getRuleStructure()).getC()));
    }

    public <NewA, NewB, NewC, NewD> DroolsQuadCondition<NewA, NewB, NewC, NewD, QuadTuple<NewA, NewB, NewC, NewD>> andGroupBiWithCollectBi(TriFunction<A, B, C, NewA> groupKeyAMapping, TriFunction<A, B, C, NewB> groupKeyBMapping, TriConstraintCollector<A, B, C, ?, NewC> collectorC, TriConstraintCollector<A, B, C, ?, NewD> collectorD) {
        return this.groupBiWithCollectBi(() -> new DroolsTriToQuadGroupByInvoker(groupKeyAMapping, groupKeyBMapping, collectorC, collectorD, ((DroolsTriRuleStructure)this.getRuleStructure()).getA(), ((DroolsTriRuleStructure)this.getRuleStructure()).getB(), ((DroolsTriRuleStructure)this.getRuleStructure()).getC()));
    }

    public List<RuleItemBuilder<?>> completeWithScoring(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal) {
        return this.completeWithScoring(scoreHolderGlobal, (Block5 & Serializable)(drools, scoreHolder, a, b, c) -> this.impactScore((Drools)drools, scoreHolder));
    }

    public List<RuleItemBuilder<?>> completeWithScoring(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal, ToIntTriFunction<A, B, C> matchWeighter) {
        return this.completeWithScoring(scoreHolderGlobal, (Block5 & Serializable)(drools, scoreHolder, a, b, c) -> this.impactScore((Drools)drools, scoreHolder, matchWeighter.applyAsInt(a, b, c)));
    }

    public List<RuleItemBuilder<?>> completeWithScoring(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal, ToLongTriFunction<A, B, C> matchWeighter) {
        return this.completeWithScoring(scoreHolderGlobal, (Block5 & Serializable)(drools, scoreHolder, a, b, c) -> this.impactScore((Drools)drools, scoreHolder, matchWeighter.applyAsLong(a, b, c)));
    }

    public List<RuleItemBuilder<?>> completeWithScoring(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal, TriFunction<A, B, C, BigDecimal> matchWeighter) {
        return this.completeWithScoring(scoreHolderGlobal, (Block5 & Serializable)(drools, scoreHolder, a, b, c) -> this.impactScore((Drools)drools, scoreHolder, (BigDecimal)matchWeighter.apply(a, b, c)));
    }

    private <ScoreHolder extends AbstractScoreHolder<?>> List<RuleItemBuilder<?>> completeWithScoring(Global<ScoreHolder> scoreHolderGlobal, Block5<Drools, ScoreHolder, A, B, C> consequenceImpl) {
        ConsequenceBuilder._4 consequence = DSL.on(scoreHolderGlobal, ((DroolsTriRuleStructure)this.ruleStructure).getA(), ((DroolsTriRuleStructure)this.ruleStructure).getB(), ((DroolsTriRuleStructure)this.ruleStructure).getC()).execute(consequenceImpl);
        return ((DroolsTriRuleStructure)this.ruleStructure).finish((ConsequenceBuilder.AbstractValidBuilder<?>)consequence);
    }
}

