/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.impl;

import org.drools.model.Variable;
import org.drools.model.impl.ModelComponent;
import org.drools.model.impl.NamesGenerator;

public abstract class VariableImpl<T>
implements Variable<T>,
ModelComponent {
    private final Class<T> type;
    private final String name;

    public VariableImpl(Class<T> type) {
        this(type, NamesGenerator.generateName("var"));
    }

    public VariableImpl(Class<T> type, String name) {
        this.type = type;
        this.name = name;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return "Variable " + this.name + " of type " + this.type;
    }

    @Override
    public boolean isEqualTo(ModelComponent o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Variable var = (Variable)((Object)o);
        return this.type.getName().equals(var.getType().getName());
    }
}

