/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.optaplanner.core.impl.score.stream.drools.common.GroupByAccumulator;

public abstract class DroolsAbstractUniCollectingGroupByAccumulator<ResultContainer, InTuple, KeyTuple, OutTuple>
implements GroupByAccumulator<InTuple, OutTuple> {
    private final Map<ResultContainer, Long> containersInUseMap = new IdentityHashMap<ResultContainer, Long>(0);
    private final Map<KeyTuple, ResultContainer> containersMap = new LinkedHashMap<KeyTuple, ResultContainer>(0);
    private final transient Set<OutTuple> resultSet = new LinkedHashSet<OutTuple>(0);

    @Override
    public Runnable accumulate(InTuple input) {
        KeyTuple key = this.toKey(input);
        Object container = this.containersMap.computeIfAbsent(key, __ -> this.newContainer());
        Runnable undo = this.process(input, container);
        this.containersInUseMap.compute(container, (__, count) -> DroolsAbstractUniCollectingGroupByAccumulator.increment(count));
        return () -> {
            undo.run();
            Long currentCount = this.containersInUseMap.compute(container, (__, count) -> DroolsAbstractUniCollectingGroupByAccumulator.decrement(count));
            if (currentCount == null) {
                this.containersMap.remove(key);
            }
        };
    }

    private static Long increment(Long count) {
        return count == null ? 1L : count + 1L;
    }

    private static Long decrement(Long count) {
        return count == 1L ? null : Long.valueOf(count - 1L);
    }

    @Override
    public Set<OutTuple> finish() {
        this.resultSet.clear();
        for (Map.Entry<KeyTuple, ResultContainer> entry : this.containersMap.entrySet()) {
            this.resultSet.add(this.toResult(entry.getKey(), entry.getValue()));
        }
        return this.resultSet;
    }

    protected abstract KeyTuple toKey(InTuple var1);

    protected abstract ResultContainer newContainer();

    protected abstract Runnable process(InTuple var1, ResultContainer var2);

    protected abstract OutTuple toResult(KeyTuple var1, ResultContainer var2);
}

