/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.definition;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;

public abstract class AbstractScoreDefinition<S extends Score<S>>
implements ScoreDefinition<S>,
Serializable {
    private final String[] levelLabels;

    protected static int sanitize(int number) {
        return number == 0 ? 1 : number;
    }

    protected static long sanitize(long number) {
        return number == 0L ? 1L : number;
    }

    protected static double sanitize(double number) {
        return number == 0.0 ? 1.0 : number;
    }

    protected static BigDecimal sanitize(BigDecimal number) {
        return number.signum() == 0 ? BigDecimal.ONE : number;
    }

    protected static int divide(int dividend, int divisor) {
        return (int)Math.floor(AbstractScoreDefinition.divide((double)dividend, (double)divisor));
    }

    protected static long divide(long dividend, long divisor) {
        return (long)Math.floor(AbstractScoreDefinition.divide((double)dividend, (double)divisor));
    }

    protected static double divide(double dividend, double divisor) {
        return dividend / divisor;
    }

    protected static BigDecimal divide(BigDecimal dividend, BigDecimal divisor) {
        return dividend.divide(divisor, dividend.scale() - divisor.scale(), RoundingMode.FLOOR);
    }

    public AbstractScoreDefinition(String[] levelLabels) {
        this.levelLabels = levelLabels;
    }

    @Override
    public String getInitLabel() {
        return "init score";
    }

    @Override
    public int getLevelsSize() {
        return this.levelLabels.length;
    }

    @Override
    public String[] getLevelLabels() {
        return this.levelLabels;
    }

    @Override
    public String formatScore(S score) {
        return score.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

