/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.language;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.camel.AfterPropertiesConfigured;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Expression;
import org.apache.camel.NoSuchLanguageException;
import org.apache.camel.Predicate;
import org.apache.camel.model.ExpressionSubElementDefinition;
import org.apache.camel.model.language.ConstantExpression;
import org.apache.camel.model.language.ExchangePropertyExpression;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.language.GroovyExpression;
import org.apache.camel.model.language.HeaderExpression;
import org.apache.camel.model.language.Hl7TerserExpression;
import org.apache.camel.model.language.JsonPathExpression;
import org.apache.camel.model.language.LanguageExpression;
import org.apache.camel.model.language.MethodCallExpression;
import org.apache.camel.model.language.MvelExpression;
import org.apache.camel.model.language.OgnlExpression;
import org.apache.camel.model.language.RefExpression;
import org.apache.camel.model.language.SimpleExpression;
import org.apache.camel.model.language.SpELExpression;
import org.apache.camel.model.language.TokenizerExpression;
import org.apache.camel.model.language.XMLTokenizerExpression;
import org.apache.camel.model.language.XPathExpression;
import org.apache.camel.model.language.XQueryExpression;
import org.apache.camel.reifier.AbstractReifier;
import org.apache.camel.reifier.language.JsonPathExpressionReifier;
import org.apache.camel.reifier.language.MethodCallExpressionReifier;
import org.apache.camel.reifier.language.SimpleExpressionReifier;
import org.apache.camel.reifier.language.TokenizerExpressionReifier;
import org.apache.camel.reifier.language.XMLTokenizerExpressionReifier;
import org.apache.camel.reifier.language.XPathExpressionReifier;
import org.apache.camel.reifier.language.XQueryExpressionReifier;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerAware;
import org.apache.camel.spi.ReifierStrategy;
import org.apache.camel.support.ExpressionToPredicateAdapter;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.ScriptHelper;
import org.apache.camel.util.ObjectHelper;

public class ExpressionReifier<T extends ExpressionDefinition>
extends AbstractReifier {
    private static final Map<Class<?>, BiFunction<CamelContext, ExpressionDefinition, ExpressionReifier<? extends ExpressionDefinition>>> EXPRESSIONS;
    protected final T definition;

    public ExpressionReifier(CamelContext camelContext, T definition) {
        super(camelContext);
        this.definition = definition;
    }

    public static ExpressionReifier<? extends ExpressionDefinition> reifier(CamelContext camelContext, ExpressionSubElementDefinition definition) {
        return ExpressionReifier.reifier(camelContext, definition.getExpressionType());
    }

    public static ExpressionReifier<? extends ExpressionDefinition> reifier(CamelContext camelContext, ExpressionDefinition definition) {
        BiFunction<CamelContext, ExpressionDefinition, ExpressionReifier<? extends ExpressionDefinition>> reifier = EXPRESSIONS.get(definition.getClass());
        if (reifier != null) {
            return reifier.apply(camelContext, definition);
        }
        throw new IllegalStateException("Unsupported definition: " + definition);
    }

    public static void clearReifiers() {
        EXPRESSIONS.clear();
    }

    public Expression createExpression() {
        Expression expression = ((ExpressionDefinition)this.definition).getExpressionValue();
        if (expression == null) {
            if (((ExpressionDefinition)this.definition).getExpressionType() != null) {
                expression = ExpressionReifier.reifier(this.camelContext, ((ExpressionDefinition)this.definition).getExpressionType()).createExpression();
            } else {
                ObjectHelper.notNull((Object)((ExpressionDefinition)this.definition).getLanguage(), (String)"language");
                Language language = this.camelContext.resolveLanguage(((ExpressionDefinition)this.definition).getLanguage());
                if (language == null) {
                    throw new NoSuchLanguageException(((ExpressionDefinition)this.definition).getLanguage());
                }
                String exp = this.parseString(((ExpressionDefinition)this.definition).getExpression());
                boolean isTrim = this.parseBoolean(((ExpressionDefinition)this.definition).getTrim(), true);
                if (exp != null && isTrim) {
                    exp = exp.trim();
                }
                exp = ScriptHelper.resolveOptionalExternalScript((CamelContext)this.camelContext, (String)exp);
                this.configureLanguage(language);
                expression = language.createExpression(exp);
                this.configureExpression(expression);
            }
        }
        if (expression instanceof CamelContextAware) {
            ((CamelContextAware)expression).setCamelContext(this.camelContext);
        }
        expression.init(this.camelContext);
        return expression;
    }

    public Predicate createPredicate() {
        Predicate predicate = ((ExpressionDefinition)this.definition).getPredicate();
        if (predicate == null) {
            if (((ExpressionDefinition)this.definition).getExpressionType() != null) {
                predicate = ExpressionReifier.reifier(this.camelContext, ((ExpressionDefinition)this.definition).getExpressionType()).createPredicate();
            } else if (((ExpressionDefinition)this.definition).getExpressionValue() != null) {
                predicate = new ExpressionToPredicateAdapter(((ExpressionDefinition)this.definition).getExpressionValue());
            } else if (((ExpressionDefinition)this.definition).getExpression() != null) {
                ObjectHelper.notNull((Object)((ExpressionDefinition)this.definition).getLanguage(), (String)"language");
                Language language = this.camelContext.resolveLanguage(((ExpressionDefinition)this.definition).getLanguage());
                if (language == null) {
                    throw new NoSuchLanguageException(((ExpressionDefinition)this.definition).getLanguage());
                }
                String exp = this.parseString(((ExpressionDefinition)this.definition).getExpression());
                boolean isTrim = this.parseBoolean(((ExpressionDefinition)this.definition).getTrim(), true);
                if (exp != null && isTrim) {
                    exp = exp.trim();
                }
                exp = ScriptHelper.resolveOptionalExternalScript((CamelContext)this.camelContext, (String)exp);
                this.configureLanguage(language);
                predicate = language.createPredicate(exp);
                this.configurePredicate(predicate);
            }
        }
        if (predicate instanceof CamelContextAware) {
            ((CamelContextAware)predicate).setCamelContext(this.camelContext);
        }
        predicate.init(this.camelContext);
        return predicate;
    }

    protected void configureLanguage(Language language) {
    }

    protected void configurePredicate(Predicate predicate) {
        if (predicate instanceof AfterPropertiesConfigured) {
            ((AfterPropertiesConfigured)predicate).afterPropertiesConfigured(this.camelContext);
        }
    }

    protected void configureExpression(Expression expression) {
        if (expression instanceof AfterPropertiesConfigured) {
            ((AfterPropertiesConfigured)expression).afterPropertiesConfigured(this.camelContext);
        }
    }

    protected void setProperties(Object target, Map<String, Object> properties) {
        properties.entrySet().removeIf(e -> e.getValue() == null);
        PropertyConfigurer configurer = null;
        if (target instanceof PropertyConfigurerAware) {
            configurer = ((PropertyConfigurerAware)target).getPropertyConfigurer(target);
        } else if (target instanceof PropertyConfigurer) {
            configurer = (PropertyConfigurer)target;
        }
        PropertyBindingSupport.build().withConfigurer(configurer).bind(this.camelContext, target, properties);
    }

    static {
        LinkedHashMap map = new LinkedHashMap();
        map.put(ConstantExpression.class, ExpressionReifier::new);
        map.put(ExchangePropertyExpression.class, ExpressionReifier::new);
        map.put(ExpressionDefinition.class, ExpressionReifier::new);
        map.put(GroovyExpression.class, ExpressionReifier::new);
        map.put(HeaderExpression.class, ExpressionReifier::new);
        map.put(Hl7TerserExpression.class, ExpressionReifier::new);
        map.put(JsonPathExpression.class, JsonPathExpressionReifier::new);
        map.put(LanguageExpression.class, ExpressionReifier::new);
        map.put(MethodCallExpression.class, MethodCallExpressionReifier::new);
        map.put(MvelExpression.class, ExpressionReifier::new);
        map.put(OgnlExpression.class, ExpressionReifier::new);
        map.put(RefExpression.class, ExpressionReifier::new);
        map.put(SimpleExpression.class, SimpleExpressionReifier::new);
        map.put(SpELExpression.class, ExpressionReifier::new);
        map.put(TokenizerExpression.class, TokenizerExpressionReifier::new);
        map.put(XMLTokenizerExpression.class, XMLTokenizerExpressionReifier::new);
        map.put(XPathExpression.class, XPathExpressionReifier::new);
        map.put(XQueryExpression.class, XQueryExpressionReifier::new);
        EXPRESSIONS = map;
        ReifierStrategy.addReifierClearer(ExpressionReifier::clearReifiers);
    }
}

