/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;

public class DescriptorPolicy {
    private Map<String, MemberAccessor> fromSolutionValueRangeProviderMap = new LinkedHashMap<String, MemberAccessor>();
    private Map<String, MemberAccessor> fromEntityValueRangeProviderMap = new LinkedHashMap<String, MemberAccessor>();

    public void addFromSolutionValueRangeProvider(MemberAccessor memberAccessor) {
        String id = this.extractValueRangeProviderId(memberAccessor);
        this.fromSolutionValueRangeProviderMap.put(id, memberAccessor);
    }

    public boolean hasFromSolutionValueRangeProvider(String id) {
        return this.fromSolutionValueRangeProviderMap.containsKey(id);
    }

    public MemberAccessor getFromSolutionValueRangeProvider(String id) {
        return this.fromSolutionValueRangeProviderMap.get(id);
    }

    public void addFromEntityValueRangeProvider(MemberAccessor memberAccessor) {
        String id = this.extractValueRangeProviderId(memberAccessor);
        this.fromEntityValueRangeProviderMap.put(id, memberAccessor);
    }

    public boolean hasFromEntityValueRangeProvider(String id) {
        return this.fromEntityValueRangeProviderMap.containsKey(id);
    }

    public MemberAccessor getFromEntityValueRangeProvider(String id) {
        return this.fromEntityValueRangeProviderMap.get(id);
    }

    private String extractValueRangeProviderId(MemberAccessor memberAccessor) {
        ValueRangeProvider annotation = memberAccessor.getAnnotation(ValueRangeProvider.class);
        String id = annotation.id();
        if (StringUtils.isEmpty((CharSequence)id)) {
            throw new IllegalStateException("The " + ValueRangeProvider.class.getSimpleName() + " annotated member (" + memberAccessor + ")'s id (" + id + ") must not be empty.");
        }
        this.validateUniqueValueRangeProviderId(id, memberAccessor);
        return id;
    }

    private void validateUniqueValueRangeProviderId(String id, MemberAccessor memberAccessor) {
        MemberAccessor duplicate = this.fromSolutionValueRangeProviderMap.get(id);
        if (duplicate != null) {
            throw new IllegalStateException("2 members (" + duplicate + ", " + memberAccessor + ") with a " + ValueRangeProvider.class.getSimpleName() + " annotation must not have the same id (" + id + ").");
        }
        duplicate = this.fromEntityValueRangeProviderMap.get(id);
        if (duplicate != null) {
            throw new IllegalStateException("2 members (" + duplicate + ", " + memberAccessor + ") with a " + ValueRangeProvider.class.getSimpleName() + " annotation must not have the same id (" + id + ").");
        }
    }

    public Collection<String> getValueRangeProviderIds() {
        ArrayList<String> valueRangeProviderIds = new ArrayList<String>(this.fromSolutionValueRangeProviderMap.size() + this.fromEntityValueRangeProviderMap.size());
        valueRangeProviderIds.addAll(this.fromSolutionValueRangeProviderMap.keySet());
        valueRangeProviderIds.addAll(this.fromEntityValueRangeProviderMap.keySet());
        return valueRangeProviderIds;
    }
}

