/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.util.Collection;
import java.util.EventListener;
import java.util.Timer;
import java.util.TimerTask;
import org.drools.compiler.kie.builder.impl.event.KieScannerEventSupport;
import org.drools.core.impl.InternalKieContainer;
import org.kie.api.builder.KieScanner;
import org.kie.api.builder.ReleaseId;
import org.kie.api.event.kiescanner.KieScannerEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKieScanner<T>
implements KieScanner {
    private Timer timer;
    private static final Logger log = LoggerFactory.getLogger(KieScanner.class);
    protected InternalKieContainer kieContainer;
    private volatile KieScanner.Status status = KieScanner.Status.STARTING;
    private long pollingInterval;
    protected KieScannerEventSupport listeners = new KieScannerEventSupport();

    public final void addListener(KieScannerEventListener listener) {
        this.listeners.addEventListener((EventListener)listener);
    }

    public final void removeListener(KieScannerEventListener listener) {
        this.listeners.removeEventListener((EventListener)listener);
    }

    public final Collection<KieScannerEventListener> getListeners() {
        return this.listeners.getEventListeners();
    }

    protected final void changeStatus(KieScanner.Status status) {
        this.status = status;
        this.listeners.fireKieScannerStatusChangeEventImpl(status);
    }

    public final synchronized ReleaseId getScannerReleaseId() {
        return this.kieContainer.getContainerReleaseId();
    }

    public final synchronized ReleaseId getCurrentReleaseId() {
        return this.kieContainer.getReleaseId();
    }

    public final synchronized KieScanner.Status getStatus() {
        return this.status;
    }

    public final synchronized void start(long pollingInterval) {
        if (this.getStatus() == KieScanner.Status.SHUTDOWN) {
            throw new IllegalStateException("The scanner was shut down and can no longer be started.");
        }
        if (pollingInterval <= 0L) {
            throw new IllegalArgumentException("pollingInterval must be positive");
        }
        if (this.timer != null) {
            throw new IllegalStateException("The scanner is already running");
        }
        this.startScanTask(pollingInterval);
    }

    public final synchronized void stop() {
        if (this.getStatus() == KieScanner.Status.SHUTDOWN) {
            throw new IllegalStateException("The scanner was already shut down.");
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.pollingInterval = 0L;
        this.changeStatus(KieScanner.Status.STOPPED);
    }

    public final synchronized long getPollingInterval() {
        return this.pollingInterval;
    }

    public final void shutdown() {
        if (this.getStatus() != KieScanner.Status.SHUTDOWN) {
            this.stop();
            this.changeStatus(KieScanner.Status.SHUTDOWN);
        }
    }

    private void startScanTask(long pollingInterval) {
        this.changeStatus(KieScanner.Status.RUNNING);
        this.pollingInterval = pollingInterval;
        this.timer = new Timer(true);
        this.timer.schedule((TimerTask)new ScanTask(), pollingInterval, pollingInterval);
    }

    public final synchronized void scanNow() {
        if (this.getStatus() == KieScanner.Status.SHUTDOWN) {
            throw new IllegalStateException("The scanner was already shut down and can no longer be used.");
        }
        KieScanner.Status originalStatus = this.status;
        try {
            this.changeStatus(KieScanner.Status.SCANNING);
            T updatedArtifacts = this.internalScan();
            if (updatedArtifacts == null) {
                this.changeStatus(originalStatus);
                return;
            }
            this.changeStatus(KieScanner.Status.UPDATING);
            this.internalUpdate(updatedArtifacts);
        }
        finally {
            this.changeStatus(originalStatus);
        }
    }

    protected abstract T internalScan();

    protected abstract void internalUpdate(T var1);

    private class ScanTask
    extends TimerTask {
        private ScanTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AbstractKieScanner abstractKieScanner = AbstractKieScanner.this;
            synchronized (abstractKieScanner) {
                if (AbstractKieScanner.this.status == KieScanner.Status.STOPPED) {
                    return;
                }
                AbstractKieScanner.this.scanNow();
                AbstractKieScanner.this.changeStatus(KieScanner.Status.RUNNING);
            }
        }
    }
}

