/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.model.Consequence;
import org.drools.model.Rule;
import org.drools.model.View;
import org.drools.model.impl.ModelComponent;
import org.drools.model.patterns.CompositePatterns;

public class RuleImpl
implements Rule,
ModelComponent {
    public static final String DEFAULT_CONSEQUENCE_NAME = "default";
    private final String pkg;
    private final String name;
    private final String unit;
    private final View view;
    private final Map<String, Consequence> consequences;
    private Map<Rule.Attribute, Object> attributes;
    private Map<String, Object> metaAttributes;

    public RuleImpl(String pkg, String name, String unit, View view, Consequence consequence, Map<Rule.Attribute, Object> attributes, Map<String, Object> metaAttributes) {
        this.pkg = pkg;
        this.name = name;
        this.unit = unit;
        this.view = view;
        this.consequences = new HashMap<String, Consequence>();
        this.consequences.put(DEFAULT_CONSEQUENCE_NAME, consequence);
        this.attributes = attributes;
        this.metaAttributes = metaAttributes;
    }

    public RuleImpl(String pkg, String name, String unit, CompositePatterns view, Map<Rule.Attribute, Object> attributes, Map<String, Object> metaAttributes) {
        this.pkg = pkg;
        this.name = name;
        this.unit = unit;
        this.view = view;
        this.consequences = view.getConsequences();
        this.attributes = attributes;
        this.metaAttributes = metaAttributes;
    }

    @Override
    public View getView() {
        return this.view;
    }

    @Override
    public Consequence getDefaultConsequence() {
        return this.consequences.get(DEFAULT_CONSEQUENCE_NAME);
    }

    @Override
    public Map<String, Consequence> getConsequences() {
        return this.consequences;
    }

    @Override
    public <T> T getAttribute(Rule.Attribute<T> attribute) {
        Object value = this.attributes != null ? this.attributes.get(attribute) : null;
        return (T)(value != null ? value : attribute.getDefaultValue());
    }

    @Override
    public Map<String, Object> getMetaData() {
        return Collections.unmodifiableMap(this.metaAttributes);
    }

    @Override
    public Object getMetaData(String name) {
        return this.metaAttributes.get(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPackage() {
        return this.pkg;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    @Override
    public boolean isEqualTo(ModelComponent o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuleImpl rule = (RuleImpl)o;
        if (!this.pkg.equals(rule.pkg)) {
            return false;
        }
        if (!this.name.equals(rule.name)) {
            return false;
        }
        if (this.unit != null ? !this.unit.equals(rule.unit) : rule.unit != null) {
            return false;
        }
        if (!ModelComponent.areEqualInModel(this.view, rule.view)) {
            return false;
        }
        if (!ModelComponent.areEqualInModel(this.consequences, rule.consequences)) {
            return false;
        }
        return this.attributes != null ? this.attributes.equals(rule.attributes) : rule.attributes == null;
    }

    public String toString() {
        return "Rule: " + this.pkg + "." + this.name + " (view: " + this.view + ", consequences: " + this.consequences + ")";
    }
}

