/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class ChangeMove<Solution_>
extends AbstractMove<Solution_> {
    protected final Object entity;
    protected final GenuineVariableDescriptor<Solution_> variableDescriptor;
    protected final Object toPlanningValue;

    public ChangeMove(Object entity, GenuineVariableDescriptor<Solution_> variableDescriptor, Object toPlanningValue) {
        this.entity = entity;
        this.variableDescriptor = variableDescriptor;
        this.toPlanningValue = toPlanningValue;
    }

    public Object getEntity() {
        return this.entity;
    }

    public String getVariableName() {
        return this.variableDescriptor.getVariableName();
    }

    public Object getToPlanningValue() {
        return this.toPlanningValue;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
        Object oldValue = this.variableDescriptor.getValue(this.entity);
        return !Objects.equals(oldValue, this.toPlanningValue);
    }

    @Override
    public ChangeMove<Solution_> createUndoMove(ScoreDirector<Solution_> scoreDirector) {
        Object oldValue = this.variableDescriptor.getValue(this.entity);
        return new ChangeMove<Solution_>(this.entity, this.variableDescriptor, oldValue);
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        scoreDirector.beforeVariableChanged(this.variableDescriptor, this.entity);
        this.variableDescriptor.setValue(this.entity, this.toPlanningValue);
        scoreDirector.afterVariableChanged(this.variableDescriptor, this.entity);
    }

    @Override
    public ChangeMove<Solution_> rebase(ScoreDirector<Solution_> destinationScoreDirector) {
        return new ChangeMove<Solution_>(destinationScoreDirector.lookUpWorkingObject(this.entity), this.variableDescriptor, destinationScoreDirector.lookUpWorkingObject(this.toPlanningValue));
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return this.getClass().getSimpleName() + "(" + this.variableDescriptor.getSimpleEntityAndVariableName() + ")";
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        return Collections.singletonList(this.entity);
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        return Collections.singletonList(this.toPlanningValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeMove other = (ChangeMove)o;
        return Objects.equals(this.entity, other.entity) && Objects.equals(this.variableDescriptor, other.variableDescriptor) && Objects.equals(this.toPlanningValue, other.toPlanningValue);
    }

    public int hashCode() {
        return Objects.hash(this.entity, this.variableDescriptor, this.toPlanningValue);
    }

    public String toString() {
        Object oldValue = this.variableDescriptor.getValue(this.entity);
        return this.entity + " {" + oldValue + " -> " + this.toPlanningValue + "}";
    }
}

