/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvelcompiler;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.mvel.parser.MvelParser;
import org.drools.mvel.parser.ast.expr.ModifyStatement;
import org.drools.mvel.parser.ast.expr.WithStatement;
import org.drools.mvelcompiler.LHSPhase;
import org.drools.mvelcompiler.ParsingResult;
import org.drools.mvelcompiler.PreprocessPhase;
import org.drools.mvelcompiler.RHSPhase;
import org.drools.mvelcompiler.ReProcessRHSPhase;
import org.drools.mvelcompiler.ast.TypedExpression;
import org.drools.mvelcompiler.context.MvelCompilerContext;

public class MvelCompiler {
    private final MvelCompilerContext mvelCompilerContext;
    private final PreprocessPhase preprocessPhase = new PreprocessPhase();

    public MvelCompiler(MvelCompilerContext mvelCompilerContext) {
        this.mvelCompilerContext = mvelCompilerContext;
    }

    public ParsingResult compile(String mvelBlock) {
        BlockStmt mvelExpression = MvelParser.parseBlock((String)mvelBlock);
        this.preprocessPhase.removeEmptyStmt(mvelExpression);
        HashSet<String> allUsedBindings = new HashSet<String>();
        List modifyUsedBindings = mvelExpression.findAll(ModifyStatement.class).stream().flatMap(this::transformStatementWithPreprocessing).collect(Collectors.toList());
        List withUsedBindings = mvelExpression.findAll(WithStatement.class).stream().flatMap(this::transformStatementWithPreprocessing).collect(Collectors.toList());
        allUsedBindings.addAll(modifyUsedBindings);
        allUsedBindings.addAll(withUsedBindings);
        ArrayList<Statement> statements = new ArrayList<Statement>();
        for (Statement s : mvelExpression.getStatements()) {
            this.processWithMvelCompiler(statements, s);
        }
        return new ParsingResult(statements).setUsedBindings(allUsedBindings);
    }

    private Stream<String> transformStatementWithPreprocessing(Statement s) {
        PreprocessPhase.PreprocessPhaseResult invoke = this.preprocessPhase.invoke(s);
        s.getParentNode().ifPresent(p -> {
            BlockStmt parentBlockStmt = (BlockStmt)p;
            parentBlockStmt.getStatements().addAll(0, invoke.getNewObjectStatements());
            parentBlockStmt.getStatements().addAll(invoke.getOtherStatements());
        });
        s.remove();
        return invoke.getUsedBindings().stream();
    }

    private void processWithMvelCompiler(List<Statement> statements, Statement s) {
        if (s.isBlockStmt()) {
            BlockStmt body = s.asBlockStmt();
            for (Statement children : body.getStatements()) {
                this.processWithMvelCompiler(statements, children);
            }
        } else if (s instanceof IfStmt) {
            IfStmt ifStmt = s.asIfStmt();
            NodeList thenStmts = NodeList.nodeList((Node[])new Statement[0]);
            this.processWithMvelCompiler((List<Statement>)thenStmts, ifStmt.getThenStmt());
            NodeList elseStmts = NodeList.nodeList((Node[])new Statement[0]);
            ifStmt.getElseStmt().ifPresent(elseStmt -> this.processWithMvelCompiler((List<Statement>)elseStmts, (Statement)elseStmt));
            statements.add((Statement)new IfStmt(ifStmt.getCondition(), (Statement)new BlockStmt(thenStmts), (Statement)new BlockStmt(elseStmts)));
        } else {
            TypedExpression rhs = new RHSPhase(this.mvelCompilerContext).invoke(s);
            TypedExpression lhs = new LHSPhase(this.mvelCompilerContext, Optional.ofNullable(rhs)).invoke(s);
            Optional<TypedExpression> postProcessedRHS = new ReProcessRHSPhase().invoke(rhs, lhs);
            TypedExpression postProcessedLHS = postProcessedRHS.map(ppr -> new LHSPhase(this.mvelCompilerContext, Optional.of(ppr)).invoke(s)).orElse(lhs);
            statements.add((Statement)postProcessedLHS.toJavaExpression());
        }
    }
}

