/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.quad;

import java.util.Objects;
import java.util.function.Function;
import org.drools.model.Variable;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.score.stream.quad.QuadConstraintCollector;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractGroupBy;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractGroupByAccumulator;
import org.optaplanner.core.impl.score.stream.drools.common.QuadTuple;
import org.optaplanner.core.impl.score.stream.drools.quad.DroolsQuadToTriGroupBy;
import org.optaplanner.core.impl.score.stream.quad.DefaultQuadConstraintCollector;

public class DroolsQuadToTriGroupByAccumulator<A, B, C, D, NewA, NewB, NewC>
extends DroolsAbstractGroupByAccumulator<QuadTuple<A, B, C, D>> {
    private final QuadConstraintCollector<A, B, C, D, ?, NewC> collector;
    private final QuadFunction<A, B, C, D, NewA> groupKeyAMapping;
    private final QuadFunction<A, B, C, D, NewB> groupKeyBMapping;
    private final Variable<A> aVariable;
    private final Variable<B> bVariable;
    private final Variable<C> cVariable;
    private final Variable<D> dVariable;

    public DroolsQuadToTriGroupByAccumulator(QuadFunction<A, B, C, D, NewA> groupKeyAMapping, QuadFunction<A, B, C, D, NewB> groupKeyBMapping, QuadConstraintCollector<A, B, C, D, ?, NewC> collector, Variable<A> aVariable, Variable<B> bVariable, Variable<C> cVariable, Variable<D> dVariable) {
        this.groupKeyAMapping = Objects.requireNonNull(groupKeyAMapping);
        this.groupKeyBMapping = Objects.requireNonNull(groupKeyBMapping);
        this.collector = collector != null ? collector : DefaultQuadConstraintCollector.noop();
        this.aVariable = Objects.requireNonNull(aVariable);
        this.bVariable = Objects.requireNonNull(bVariable);
        this.cVariable = Objects.requireNonNull(cVariable);
        this.dVariable = Objects.requireNonNull(dVariable);
    }

    @Override
    protected DroolsAbstractGroupBy<QuadTuple<A, B, C, D>, ?> newContext() {
        return new DroolsQuadToTriGroupBy<A, B, C, D, NewA, NewB, NewC>(this.groupKeyAMapping, this.groupKeyBMapping, this.collector);
    }

    @Override
    protected <X> QuadTuple<A, B, C, D> createInput(Function<Variable<X>, X> valueFinder) {
        A a = DroolsQuadToTriGroupByAccumulator.materialize(this.aVariable, valueFinder);
        B b = DroolsQuadToTriGroupByAccumulator.materialize(this.bVariable, valueFinder);
        C c = DroolsQuadToTriGroupByAccumulator.materialize(this.cVariable, valueFinder);
        D d = DroolsQuadToTriGroupByAccumulator.materialize(this.dVariable, valueFinder);
        return new QuadTuple<A, B, C, D>(a, b, c, d);
    }
}

