/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.parser;

import com.github.javaparser.ParseProblemException;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.Problem;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.printer.PrettyPrinterConfiguration;
import com.github.javaparser.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import org.drools.mvel.parser.GeneratedMvelParser;
import org.drools.mvel.parser.ParseStart;
import org.drools.mvel.parser.Provider;
import org.drools.mvel.parser.Providers;
import org.drools.mvel.parser.printer.ConstraintPrintVisitor;

public final class MvelParser {
    private final ParserConfiguration configuration;
    private GeneratedMvelParser astParser = null;
    private static ParserConfiguration staticConfiguration = new ParserConfiguration();

    public MvelParser() {
        this(new ParserConfiguration());
    }

    public MvelParser(ParserConfiguration configuration) {
        this.configuration = configuration;
        configuration.getPostProcessors().clear();
    }

    public static ParserConfiguration getStaticConfiguration() {
        return staticConfiguration;
    }

    public static void setStaticConfiguration(ParserConfiguration staticConfiguration) {
        MvelParser.staticConfiguration = staticConfiguration;
    }

    public ParserConfiguration getParserConfiguration() {
        return this.configuration;
    }

    private GeneratedMvelParser getParserForProvider(Provider provider) {
        if (this.astParser == null) {
            this.astParser = new GeneratedMvelParser(provider);
        } else {
            this.astParser.reset(provider);
        }
        this.astParser.setTabSize(this.configuration.getTabSize());
        this.astParser.setStoreTokens(this.configuration.isStoreTokens());
        return this.astParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <N extends Node> ParseResult<N> parse(ParseStart<N> start, Provider provider) {
        Utils.assertNotNull(start);
        Utils.assertNotNull((Object)provider);
        GeneratedMvelParser parser = this.getParserForProvider(provider);
        try {
            Node resultNode = (Node)start.parse(parser);
            ParseResult result = new ParseResult((Object)resultNode, parser.problems, parser.getCommentsCollection());
            this.configuration.getPostProcessors().forEach(postProcessor -> postProcessor.process(result, this.configuration));
            result.getProblems().sort(Problem.PROBLEM_BY_BEGIN_POSITION);
            ParseResult parseResult = result;
            return parseResult;
        }
        catch (Exception e) {
            String message = e.getMessage() == null ? "Unknown error" : e.getMessage();
            parser.problems.add(new Problem(message, null, (Throwable)e));
            ParseResult parseResult = new ParseResult(null, parser.problems, parser.getCommentsCollection());
            return parseResult;
        }
        finally {
            try {
                provider.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static Expression parse(InputStream in, Charset encoding) {
        return MvelParser.simplifiedParse(ParseStart.EXPRESSION, Providers.provider(in, encoding));
    }

    public static Expression parse(InputStream in) {
        return MvelParser.parse(in, Providers.UTF8);
    }

    public static Expression parseResource(String path) throws IOException {
        return MvelParser.simplifiedParse(ParseStart.EXPRESSION, Providers.resourceProvider(path));
    }

    public static Expression parseResource(String path, Charset encoding) throws IOException {
        return MvelParser.simplifiedParse(ParseStart.EXPRESSION, Providers.resourceProvider(path, encoding));
    }

    public static Expression parseResource(ClassLoader classLoader, String path, Charset encoding) throws IOException {
        return MvelParser.simplifiedParse(ParseStart.EXPRESSION, Providers.resourceProvider(classLoader, path, encoding));
    }

    public static Expression parse(Reader reader) {
        return MvelParser.simplifiedParse(ParseStart.EXPRESSION, Providers.provider(reader));
    }

    public static Expression parse(String code) {
        return MvelParser.simplifiedParse(ParseStart.EXPRESSION, Providers.provider(code));
    }

    private static <T extends Node> T simplifiedParse(ParseStart<T> context, Provider provider) {
        ParseResult<T> result = new MvelParser(staticConfiguration).parse(context, provider);
        if (result.isSuccessful()) {
            return (T)((Node)result.getResult().orElseThrow(() -> new IllegalStateException("ParseResult doesn't contain any result although marked as successful!")));
        }
        throw new ParseProblemException(result.getProblems());
    }

    public static BlockStmt parseBlock(String blockStatement) {
        return MvelParser.simplifiedParse(ParseStart.BLOCK, Providers.provider(blockStatement));
    }

    public static <T extends Expression> T parseExpression(String expression) {
        return (T)MvelParser.simplifiedParse(ParseStart.EXPRESSION, Providers.provider(expression));
    }

    public static ClassOrInterfaceType parseClassOrInterfaceType(String type) {
        return MvelParser.simplifiedParse(ParseStart.CLASS_OR_INTERFACE_TYPE, Providers.provider(type));
    }

    public static Type parseType(String type) {
        return MvelParser.simplifiedParse(ParseStart.TYPE, Providers.provider(type));
    }

    public static ExplicitConstructorInvocationStmt parseExplicitConstructorInvocationStmt(String statement) {
        return MvelParser.simplifiedParse(ParseStart.EXPLICIT_CONSTRUCTOR_INVOCATION_STMT, Providers.provider(statement));
    }

    public static Name parseName(String qualifiedName) {
        return MvelParser.simplifiedParse(ParseStart.NAME, Providers.provider(qualifiedName));
    }

    public static SimpleName parseSimpleName(String name) {
        return MvelParser.simplifiedParse(ParseStart.SIMPLE_NAME, Providers.provider(name));
    }

    static {
        PrettyPrinterConfiguration prettyPrinterConfiguration = new PrettyPrinterConfiguration();
        prettyPrinterConfiguration.setVisitorFactory(ConstraintPrintVisitor::new);
        Node.setToStringPrettyPrinterConfiguration((PrettyPrinterConfiguration)prettyPrinterConfiguration);
    }
}

