/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.functions;

import java.util.Objects;
import java.util.Optional;

public class PredicateInformation {
    public static final PredicateInformation EMPTY_PREDICATE_INFORMATION = new PredicateInformation("", "", "");
    private final String stringConstraint;
    private final String ruleName;
    private final String ruleFileName;

    public PredicateInformation(String stringConstraint, String ruleName, String ruleFileName) {
        this.stringConstraint = this.defaultToEmptyString(stringConstraint);
        this.ruleName = this.defaultToEmptyString(ruleName);
        this.ruleFileName = this.defaultToEmptyString(ruleFileName);
    }

    private String defaultToEmptyString(String stringConstraint) {
        return Optional.ofNullable(stringConstraint).orElse("");
    }

    public RuntimeException betterErrorMessage(RuntimeException originalException) {
        if ("".equals(this.stringConstraint)) {
            return originalException;
        }
        String errorMessage = String.format("Error evaluating constraint '%s' in [Rule \"%s\" in %s]", this.stringConstraint, this.ruleName, this.ruleFileName);
        return new RuntimeException(errorMessage, originalException);
    }

    public String getStringConstraint() {
        return this.stringConstraint;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public String getRuleFileName() {
        return this.ruleFileName;
    }

    public boolean isEmpty() {
        return EMPTY_PREDICATE_INFORMATION.equals(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PredicateInformation that = (PredicateInformation)o;
        return Objects.equals(this.stringConstraint, that.stringConstraint) && Objects.equals(this.ruleName, that.ruleName) && Objects.equals(this.ruleFileName, that.ruleFileName);
    }

    public int hashCode() {
        return Objects.hash(this.stringConstraint, this.ruleName, this.ruleFileName);
    }

    public String toString() {
        return "PredicateInformation{stringConstraint='" + this.stringConstraint + '\'' + ", ruleName='" + this.ruleName + '\'' + ", ruleFileName='" + this.ruleFileName + '\'' + '}';
    }
}

