/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.hardmediumsoftlong;

import org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore;
import org.optaplanner.core.impl.score.inliner.LongWeightedScoreImpacter;
import org.optaplanner.core.impl.score.inliner.ScoreInliner;

public class HardMediumSoftLongScoreInliner
extends ScoreInliner<HardMediumSoftLongScore> {
    protected long hardScore;
    protected long mediumScore;
    protected long softScore;

    protected HardMediumSoftLongScoreInliner(boolean constraintMatchEnabled) {
        super(constraintMatchEnabled);
    }

    public LongWeightedScoreImpacter buildWeightedScoreImpacter(HardMediumSoftLongScore constraintWeight) {
        if (constraintWeight.equals(HardMediumSoftLongScore.ZERO)) {
            throw new IllegalArgumentException("The constraintWeight (" + constraintWeight + ") cannot be zero, this constraint should have been culled during node creation.");
        }
        long hardConstraintWeight = constraintWeight.getHardScore();
        long mediumConstraintWeight = constraintWeight.getMediumScore();
        long softConstraintWeight = constraintWeight.getSoftScore();
        if (mediumConstraintWeight == 0L && softConstraintWeight == 0L) {
            return (matchWeight, matchScoreConsumer) -> {
                long hardImpact = hardConstraintWeight * matchWeight;
                this.hardScore += hardImpact;
                if (this.constraintMatchEnabled) {
                    matchScoreConsumer.accept(HardMediumSoftLongScore.ofHard(hardImpact));
                }
                return () -> this.hardScore -= hardImpact;
            };
        }
        if (hardConstraintWeight == 0L && softConstraintWeight == 0L) {
            return (matchWeight, matchScoreConsumer) -> {
                long mediumImpact = mediumConstraintWeight * matchWeight;
                this.mediumScore += mediumImpact;
                if (this.constraintMatchEnabled) {
                    matchScoreConsumer.accept(HardMediumSoftLongScore.ofMedium(mediumImpact));
                }
                return () -> this.mediumScore -= mediumImpact;
            };
        }
        if (hardConstraintWeight == 0L && mediumConstraintWeight == 0L) {
            return (matchWeight, matchScoreConsumer) -> {
                long softImpact = softConstraintWeight * matchWeight;
                this.softScore += softImpact;
                if (this.constraintMatchEnabled) {
                    matchScoreConsumer.accept(HardMediumSoftLongScore.ofSoft(softImpact));
                }
                return () -> this.softScore -= softImpact;
            };
        }
        return (matchWeight, matchScoreConsumer) -> {
            long hardImpact = hardConstraintWeight * matchWeight;
            long mediumImpact = mediumConstraintWeight * matchWeight;
            long softImpact = softConstraintWeight * matchWeight;
            this.hardScore += hardImpact;
            this.mediumScore += mediumImpact;
            this.softScore += softImpact;
            if (this.constraintMatchEnabled) {
                matchScoreConsumer.accept(HardMediumSoftLongScore.of(hardImpact, mediumImpact, softImpact));
            }
            return () -> {
                this.hardScore -= hardImpact;
                this.mediumScore -= mediumImpact;
                this.softScore -= softImpact;
            };
        };
    }

    @Override
    public HardMediumSoftLongScore extractScore(int initScore) {
        return HardMediumSoftLongScore.ofUninitialized(initScore, this.hardScore, this.mediumScore, this.softScore);
    }

    public String toString() {
        return HardMediumSoftLongScore.class.getSimpleName() + " inliner";
    }
}

