/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Message;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterExists;
import org.apache.camel.TypeConverterExistsException;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.TypeConverters;
import org.apache.camel.converter.ObjectConverter;
import org.apache.camel.impl.converter.ArrayTypeConverter;
import org.apache.camel.impl.converter.AsyncProcessorTypeConverter;
import org.apache.camel.impl.converter.EnumTypeConverter;
import org.apache.camel.impl.converter.FutureTypeConverter;
import org.apache.camel.impl.converter.ToStringTypeConverter;
import org.apache.camel.impl.converter.TypeConvertersLoader;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.TypeConverterSupport;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.DoubleMap;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTypeConverterRegistry
extends ServiceSupport
implements TypeConverter,
TypeConverterRegistry {
    public static final String META_INF_SERVICES_TYPE_CONVERTER_LOADER = "META-INF/services/org/apache/camel/TypeConverterLoader";
    public static final String META_INF_SERVICES_FALLBACK_TYPE_CONVERTER = "META-INF/services/org/apache/camel/FallbackTypeConverter";
    protected static final TypeConverter MISS_CONVERTER = new TypeConverterSupport(){

        public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
            return (T)MISS_VALUE;
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger(BaseTypeConverterRegistry.class);
    protected final DoubleMap<Class<?>, Class<?>, TypeConverter> typeMappings = new DoubleMap(200);
    protected final List<TypeConverterLoader> typeConverterLoaders = new ArrayList<TypeConverterLoader>();
    protected final List<FallbackTypeConverter> fallbackConverters = new CopyOnWriteArrayList<FallbackTypeConverter>();
    protected CamelContext camelContext;
    protected PackageScanClassResolver resolver;
    protected Injector injector;
    protected final FactoryFinder factoryFinder;
    protected TypeConverterExists typeConverterExists = TypeConverterExists.Override;
    protected LoggingLevel typeConverterExistsLoggingLevel = LoggingLevel.WARN;
    protected final TypeConverterRegistry.Statistics statistics = new UtilizationStatistics();
    protected final LongAdder noopCounter = new LongAdder();
    protected final LongAdder attemptCounter = new LongAdder();
    protected final LongAdder missCounter = new LongAdder();
    protected final LongAdder hitCounter = new LongAdder();
    protected final LongAdder failedCounter = new LongAdder();

    public BaseTypeConverterRegistry(CamelContext camelContext, PackageScanClassResolver resolver, Injector injector, FactoryFinder factoryFinder) {
        this.camelContext = camelContext;
        this.injector = injector;
        this.factoryFinder = factoryFinder;
        this.resolver = resolver;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public List<TypeConverterLoader> getTypeConverterLoaders() {
        return this.typeConverterLoaders;
    }

    public <T> T convertTo(Class<T> type, Object value) {
        return this.convertTo(type, null, value);
    }

    public <T> T convertTo(Class<T> type, Exchange exchange, Object value) {
        if (value != null) {
            Class<?> cls;
            if (type.isInstance(value)) {
                return (T)value;
            }
            if (type == Boolean.TYPE) {
                Boolean answer = ObjectConverter.toBoolean(value);
                if (answer == null) {
                    throw new TypeConversionException(value, type, (Throwable)new IllegalArgumentException("Cannot convert type: " + value.getClass().getName() + " to boolean"));
                }
                return (T)answer;
            }
            if (type == Boolean.class && value instanceof String) {
                String str = (String)value;
                if ("true".equalsIgnoreCase(str)) {
                    return (T)Boolean.TRUE;
                }
                if ("false".equalsIgnoreCase(str)) {
                    return (T)Boolean.FALSE;
                }
            } else if (type.isPrimitive()) {
                Class<?> cls2 = value.getClass();
                if (cls2 == Integer.class || cls2 == Long.class) {
                    return (T)value;
                }
            } else if (type == String.class && ((cls = value.getClass()).isPrimitive() || cls == Boolean.class || cls == Boolean.TYPE || cls == Integer.class || cls == Integer.TYPE || cls == Long.class || cls == Long.TYPE)) {
                return (T)value.toString();
            }
        }
        return (T)this.doConvertTo(type, exchange, value, false, false);
    }

    public <T> T mandatoryConvertTo(Class<T> type, Object value) throws NoTypeConversionAvailableException {
        return this.mandatoryConvertTo(type, null, value);
    }

    public <T> T mandatoryConvertTo(Class<T> type, Exchange exchange, Object value) throws NoTypeConversionAvailableException {
        Object answer;
        if (value != null) {
            Class<?> cls;
            if (type.isInstance(value)) {
                return (T)value;
            }
            if (type == Boolean.TYPE) {
                Boolean answer2 = ObjectConverter.toBoolean(value);
                if (answer2 == null) {
                    throw new TypeConversionException(value, type, (Throwable)new IllegalArgumentException("Cannot convert type: " + value.getClass().getName() + " to boolean"));
                }
                return (T)answer2;
            }
            if (type == Boolean.class && value instanceof String) {
                String str = (String)value;
                if ("true".equalsIgnoreCase(str)) {
                    return (T)Boolean.TRUE;
                }
                if ("false".equalsIgnoreCase(str)) {
                    return (T)Boolean.FALSE;
                }
            } else if (type.isPrimitive()) {
                cls = value.getClass();
                if (cls == Integer.class || cls == Long.class) {
                    return (T)value;
                }
            } else if (type == String.class && ((cls = value.getClass()).isPrimitive() || cls == Boolean.class || cls == Boolean.TYPE || cls == Integer.class || cls == Integer.TYPE || cls == Long.class || cls == Long.TYPE)) {
                return (T)value.toString();
            }
        }
        if ((answer = this.doConvertTo(type, exchange, value, true, false)) == null) {
            throw new NoTypeConversionAvailableException(value, type);
        }
        return (T)answer;
    }

    public <T> T tryConvertTo(Class<T> type, Object value) {
        return this.tryConvertTo(type, null, value);
    }

    public <T> T tryConvertTo(Class<T> type, Exchange exchange, Object value) {
        return (T)this.doConvertTo(type, exchange, value, false, true);
    }

    protected Object doConvertTo(Class<?> type, Exchange exchange, Object value, boolean mandatory, boolean tryConvert) {
        Object answer;
        try {
            answer = this.doConvertTo(type, exchange, value, tryConvert);
        }
        catch (Exception e) {
            boolean execution;
            if (this.statistics.isStatisticsEnabled()) {
                this.failedCounter.increment();
            }
            if (tryConvert) {
                return null;
            }
            boolean bl = execution = ObjectHelper.getException(ExecutionException.class, (Throwable)e) != null || ObjectHelper.getException(CamelExecutionException.class, (Throwable)e) != null;
            if (execution) {
                throw CamelExecutionException.wrapCamelExecutionException((Exchange)exchange, (Throwable)e);
            }
            throw this.createTypeConversionException(exchange, type, value, e);
        }
        if (answer == MISS_VALUE) {
            if (this.statistics.isStatisticsEnabled()) {
                this.missCounter.increment();
            }
            return null;
        }
        if (this.statistics.isStatisticsEnabled()) {
            this.hitCounter.increment();
        }
        return answer;
    }

    protected Object doConvertTo(Class<?> type, Exchange exchange, Object value, boolean tryConvert) throws Exception {
        Object rc;
        Class<?> fromType;
        TypeConverter tc;
        Class primitiveType;
        TypeConverter converter;
        boolean trace = LOG.isTraceEnabled();
        boolean statisticsEnabled = this.statistics.isStatisticsEnabled();
        if (trace) {
            LOG.trace("Finding type converter to convert {} -> {} with value: {}", new Object[]{value == null ? "null" : value.getClass().getCanonicalName(), type.getCanonicalName(), value});
        }
        if (value == null) {
            if (statisticsEnabled) {
                this.noopCounter.increment();
            }
            if (type.isPrimitive()) {
                if (Boolean.TYPE == type) {
                    return Boolean.FALSE;
                }
                if (Integer.TYPE == type) {
                    return 0;
                }
                if (Long.TYPE == type) {
                    return 0L;
                }
                if (Byte.TYPE == type) {
                    return (byte)0;
                }
                if (Short.TYPE == type) {
                    return (short)0;
                }
                if (Double.TYPE == type) {
                    return 0.0;
                }
                if (Float.TYPE == type) {
                    return Float.valueOf(0.0f);
                }
                if (Character.TYPE == type) {
                    return Character.valueOf('\u0000');
                }
            }
            return null;
        }
        if (type.isInstance(value)) {
            if (statisticsEnabled) {
                this.noopCounter.increment();
            }
            return value;
        }
        if (statisticsEnabled) {
            this.attemptCounter.increment();
        }
        if ((converter = this.getOrFindTypeConverter(type, value.getClass())) != null) {
            Object rc2;
            if (trace) {
                LOG.trace("Using converter: {} to convert [{}=>{}]", new Object[]{converter, value.getClass(), type});
            }
            if ((rc2 = tryConvert ? converter.tryConvertTo(type, exchange, value) : converter.convertTo(type, exchange, value)) != null) {
                return rc2;
            }
            if (converter.allowNull()) {
                return null;
            }
        }
        if (type.isPrimitive() && (primitiveType = ObjectHelper.convertPrimitiveTypeToWrapperType(type)) != type && (tc = this.getOrFindTypeConverter(primitiveType, fromType = value.getClass())) != null) {
            this.addTypeConverter(type, fromType, tc);
            rc = tryConvert ? tc.tryConvertTo(primitiveType, exchange, value) : tc.convertTo(primitiveType, exchange, value);
            if (rc == null && tc.allowNull()) {
                return null;
            }
            if (rc != null) {
                return rc;
            }
        }
        for (FallbackTypeConverter fallback : this.fallbackConverters) {
            tc = fallback.getFallbackTypeConverter();
            rc = tryConvert ? tc.tryConvertTo(type, exchange, value) : tc.convertTo(type, exchange, value);
            if (rc == null && tc.allowNull()) {
                return null;
            }
            if (rc == MISS_VALUE) {
                return MISS_VALUE;
            }
            if (rc == null) continue;
            if (fallback.isCanPromote()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Promoting fallback type converter as a known type converter to convert from: {} to: {} for the fallback converter: {}", new Object[]{type.getCanonicalName(), value.getClass().getCanonicalName(), fallback.getFallbackTypeConverter()});
                }
                this.addTypeConverter(type, value.getClass(), fallback.getFallbackTypeConverter());
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Fallback type converter {} converted type from: {} to: {}", new Object[]{fallback.getFallbackTypeConverter(), type.getCanonicalName(), value.getClass().getCanonicalName()});
            }
            return rc;
        }
        if (!tryConvert) {
            this.typeMappings.put(type, value.getClass(), (Object)MISS_CONVERTER);
        }
        return MISS_VALUE;
    }

    public void addTypeConverter(Class<?> toType, Class<?> fromType, TypeConverter typeConverter) {
        LOG.trace("Adding type converter: {}", (Object)typeConverter);
        TypeConverter converter = (TypeConverter)this.typeMappings.get(toType, fromType);
        if (typeConverter != converter) {
            boolean add = true;
            if (converter != null) {
                if (this.typeConverterExists == TypeConverterExists.Override) {
                    CamelLogger logger = new CamelLogger(LOG, this.typeConverterExistsLoggingLevel);
                    logger.log("Overriding type converter from: " + converter + " to: " + typeConverter);
                } else if (this.typeConverterExists == TypeConverterExists.Ignore) {
                    CamelLogger logger = new CamelLogger(LOG, this.typeConverterExistsLoggingLevel);
                    logger.log("Ignoring duplicate type converter from: " + converter + " to: " + typeConverter);
                    add = false;
                } else {
                    throw new TypeConverterExistsException(toType, fromType);
                }
            }
            if (add) {
                this.typeMappings.put(toType, fromType, (Object)typeConverter);
            }
        }
    }

    public void addTypeConverters(TypeConverters typeConverters) {
        LOG.trace("Adding type converters: {}", (Object)typeConverters);
        try {
            TypeConvertersLoader loader = new TypeConvertersLoader(typeConverters);
            loader.load(this);
        }
        catch (TypeConverterLoaderException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public boolean removeTypeConverter(Class<?> toType, Class<?> fromType) {
        LOG.trace("Removing type converter from: {} to: {}", fromType, toType);
        return this.typeMappings.remove(toType, fromType);
    }

    public void addFallbackTypeConverter(TypeConverter typeConverter, boolean canPromote) {
        LOG.trace("Adding fallback type converter: {} which can promote: {}", (Object)typeConverter, (Object)canPromote);
        this.fallbackConverters.add(0, new FallbackTypeConverter(typeConverter, canPromote));
        if (typeConverter instanceof CamelContextAware) {
            CamelContextAware camelContextAware = (CamelContextAware)typeConverter;
            if (this.camelContext != null) {
                camelContextAware.setCamelContext(this.camelContext);
            }
        }
    }

    private void addCoreFallbackTypeConverterToList(TypeConverter typeConverter, boolean canPromote, List<FallbackTypeConverter> converters) {
        LOG.trace("Adding core fallback type converter: {} which can promote: {}", (Object)typeConverter, (Object)canPromote);
        converters.add(0, new FallbackTypeConverter(typeConverter, canPromote));
        if (typeConverter instanceof CamelContextAware) {
            CamelContextAware camelContextAware = (CamelContextAware)typeConverter;
            if (this.camelContext != null) {
                camelContextAware.setCamelContext(this.camelContext);
            }
        }
    }

    public TypeConverter getTypeConverter(Class<?> toType, Class<?> fromType) {
        return (TypeConverter)this.typeMappings.get(toType, fromType);
    }

    public Injector getInjector() {
        return this.injector;
    }

    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    public PackageScanClassResolver getResolver() {
        return this.resolver;
    }

    protected <T> TypeConverter getOrFindTypeConverter(Class<?> toType, Class<?> fromType) {
        TypeConverter converter = (TypeConverter)this.typeMappings.get(toType, fromType);
        if (converter == null && (converter = this.lookup(toType, fromType)) != null) {
            this.typeMappings.put(toType, fromType, (Object)converter);
        }
        return converter;
    }

    public TypeConverter lookup(Class<?> toType, Class<?> fromType) {
        return this.doLookup(toType, fromType, false);
    }

    protected TypeConverter doLookup(Class<?> toType, Class<?> fromType, boolean isSuper) {
        TypeConverter converter;
        if (fromType != null) {
            converter = this.getTypeConverter(toType, fromType);
            if (converter != null) {
                return converter;
            }
            for (Class<?> type : fromType.getInterfaces()) {
                converter = this.getTypeConverter(toType, type);
                if (converter == null) continue;
                return converter;
            }
            Class<?> fromSuperClass = fromType.getSuperclass();
            if (fromSuperClass != null && !fromSuperClass.equals(Object.class) && (converter = this.doLookup(toType, fromSuperClass, true)) != null) {
                return converter;
            }
        }
        if (!isSuper && fromType != null && !fromType.equals(Object.class)) {
            converter = (TypeConverter)this.typeMappings.getFirst(toType::isAssignableFrom, from -> !from.equals(Object.class) && from.isAssignableFrom(fromType));
            if (converter != null) {
                return converter;
            }
            converter = this.getTypeConverter(toType, Object.class);
            if (converter != null) {
                return converter;
            }
        }
        return null;
    }

    public List<Class<?>[]> listAllTypeConvertersFromTo() {
        ArrayList<Class<?>[]> answer = new ArrayList<Class<?>[]>();
        this.typeMappings.forEach((k1, k2, v) -> answer.add(new Class[]{k2, k1}));
        return answer;
    }

    public void loadCoreAndFastTypeConverters() throws Exception {
        Collection<String> names = this.findTypeConverterLoaderClasses();
        for (String name : names) {
            ClassLoader loader2;
            LOG.debug("Resolving TypeConverterLoader: {}", (Object)name);
            Class<?> clazz = null;
            for (ClassLoader loader2 : this.getResolver().getClassLoaders()) {
                try {
                    clazz = loader2.loadClass(name);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (clazz == null) continue;
                break;
            }
            if (clazz == null) {
                throw new ClassNotFoundException(name);
            }
            Object obj = this.getInjector().newInstance(clazz, false);
            if (!(obj instanceof TypeConverterLoader)) continue;
            loader2 = (TypeConverterLoader)obj;
            LOG.debug("TypeConverterLoader: {} loading converters", (Object)name);
            loader2.load(this);
        }
    }

    protected Collection<String> findTypeConverterLoaderClasses() throws IOException {
        LinkedHashSet<String> loaders = new LinkedHashSet<String>();
        Collection<URL> loaderResources = this.getLoaderUrls();
        for (URL url : loaderResources) {
            String line;
            LOG.debug("Loading file {} to retrieve list of type converters, from url: {}", (Object)META_INF_SERVICES_TYPE_CONVERTER_LOADER, (Object)url);
            BufferedReader reader = IOHelper.buffered((Reader)new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
            do {
                if ((line = reader.readLine()) == null || line.startsWith("#") || line.isEmpty()) continue;
                loaders.add(line);
            } while (line != null);
            IOHelper.close((Closeable)reader);
        }
        return loaders;
    }

    protected Collection<URL> getLoaderUrls() throws IOException {
        ArrayList<URL> loaderResources = new ArrayList<URL>();
        for (ClassLoader classLoader : this.resolver.getClassLoaders()) {
            Enumeration<URL> resources = classLoader.getResources(META_INF_SERVICES_TYPE_CONVERTER_LOADER);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                loaderResources.add(url);
            }
        }
        return loaderResources;
    }

    protected void loadTypeConverters() throws Exception {
        for (TypeConverterLoader typeConverterLoader : this.getTypeConverterLoaders()) {
            typeConverterLoader.load((TypeConverterRegistry)this);
        }
        try {
            this.loadFallbackTypeConverters();
        }
        catch (NoFactoryAvailableException noFactoryAvailableException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<String> findFallbackTypeConverterClasses() throws IOException {
        LinkedHashSet<String> loaders = new LinkedHashSet<String>();
        Collection<URL> loaderResources = this.getFallbackUrls();
        for (URL url : loaderResources) {
            LOG.debug("Loading file {} to retrieve list of fallback type converters, from url: {}", (Object)META_INF_SERVICES_FALLBACK_TYPE_CONVERTER, (Object)url);
            BufferedReader reader = IOHelper.buffered((Reader)new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
            try {
                reader.lines().map(String::trim).filter(l -> !l.isEmpty()).filter(l -> !l.startsWith("#")).forEach(loaders::add);
            }
            finally {
                IOHelper.close((Closeable)reader, (String)url.toString(), (Logger)LOG);
            }
        }
        return loaders;
    }

    protected Collection<URL> getFallbackUrls() throws IOException {
        ArrayList<URL> loaderResources = new ArrayList<URL>();
        for (ClassLoader classLoader : this.resolver.getClassLoaders()) {
            Enumeration<URL> resources = classLoader.getResources(META_INF_SERVICES_FALLBACK_TYPE_CONVERTER);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                loaderResources.add(url);
            }
        }
        return loaderResources;
    }

    protected void loadFallbackTypeConverters() throws IOException, ClassNotFoundException {
        Collection<String> names = this.findFallbackTypeConverterClasses();
        for (String name : names) {
            LOG.debug("Resolving FallbackTypeConverter: {}", (Object)name);
            Class clazz = this.getResolver().getClassLoaders().stream().map(cl -> ObjectHelper.loadClass((String)name, (ClassLoader)cl)).filter(Objects::nonNull).findAny().orElseThrow(() -> new ClassNotFoundException(name));
            Object obj = this.getInjector().newInstance(clazz, false);
            if (!(obj instanceof TypeConverter)) continue;
            TypeConverter fb = (TypeConverter)obj;
            LOG.debug("Adding loaded FallbackTypeConverter: {}", (Object)name);
            this.addFallbackTypeConverter(fb, false);
        }
    }

    protected TypeConversionException createTypeConversionException(Exchange exchange, Class<?> type, Object value, Throwable cause) {
        if (cause instanceof TypeConversionException && ((TypeConversionException)cause).getToType() == type) {
            return (TypeConversionException)cause;
        }
        Object body = exchange != null ? MessageHelper.extractValueForLogging((Object)value, (Message)exchange.getIn()) : value;
        return new TypeConversionException(body, type, cause);
    }

    public TypeConverterRegistry.Statistics getStatistics() {
        return this.statistics;
    }

    public int size() {
        return this.typeMappings.size();
    }

    public LoggingLevel getTypeConverterExistsLoggingLevel() {
        return this.typeConverterExistsLoggingLevel;
    }

    public void setTypeConverterExistsLoggingLevel(LoggingLevel typeConverterExistsLoggingLevel) {
        this.typeConverterExistsLoggingLevel = typeConverterExistsLoggingLevel;
    }

    public TypeConverterExists getTypeConverterExists() {
        return this.typeConverterExists;
    }

    public void setTypeConverterExists(TypeConverterExists typeConverterExists) {
        this.typeConverterExists = typeConverterExists;
    }

    protected void doInit() {
        if (this.injector == null && this.camelContext != null) {
            this.injector = this.camelContext.getInjector();
        }
        if (this.resolver == null && this.camelContext != null) {
            this.resolver = ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getPackageScanClassResolver();
        }
        ArrayList<FallbackTypeConverter> fallbacks = new ArrayList<FallbackTypeConverter>();
        this.addCoreFallbackTypeConverterToList((TypeConverter)new ToStringTypeConverter(), false, fallbacks);
        this.addCoreFallbackTypeConverterToList((TypeConverter)new EnumTypeConverter(), true, fallbacks);
        this.addCoreFallbackTypeConverterToList((TypeConverter)new ArrayTypeConverter(), true, fallbacks);
        this.addCoreFallbackTypeConverterToList((TypeConverter)new FutureTypeConverter(this), false, fallbacks);
        this.addCoreFallbackTypeConverterToList((TypeConverter)new AsyncProcessorTypeConverter(), true, fallbacks);
        this.fallbackConverters.addAll(fallbacks);
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
        if (this.statistics.isStatisticsEnabled()) {
            String info = this.statistics.toString();
            AtomicInteger misses = new AtomicInteger();
            this.typeMappings.forEach((k1, k2, v) -> {
                if (v == MISS_CONVERTER) {
                    misses.incrementAndGet();
                }
            });
            info = info + String.format(" mappings[total=%s, misses=%s]", this.typeMappings.size(), misses);
            LOG.info(info);
        }
        this.typeMappings.clear();
        this.statistics.reset();
    }

    protected static class FallbackTypeConverter {
        private final boolean canPromote;
        private final TypeConverter fallbackTypeConverter;

        FallbackTypeConverter(TypeConverter fallbackTypeConverter, boolean canPromote) {
            this.canPromote = canPromote;
            this.fallbackTypeConverter = fallbackTypeConverter;
        }

        public boolean isCanPromote() {
            return this.canPromote;
        }

        public TypeConverter getFallbackTypeConverter() {
            return this.fallbackTypeConverter;
        }
    }

    private final class UtilizationStatistics
    implements TypeConverterRegistry.Statistics {
        private boolean statisticsEnabled;

        private UtilizationStatistics() {
        }

        public long getNoopCounter() {
            return BaseTypeConverterRegistry.this.noopCounter.longValue();
        }

        public long getAttemptCounter() {
            return BaseTypeConverterRegistry.this.attemptCounter.longValue();
        }

        public long getHitCounter() {
            return BaseTypeConverterRegistry.this.hitCounter.longValue();
        }

        public long getMissCounter() {
            return BaseTypeConverterRegistry.this.missCounter.longValue();
        }

        public long getFailedCounter() {
            return BaseTypeConverterRegistry.this.failedCounter.longValue();
        }

        public void reset() {
            BaseTypeConverterRegistry.this.noopCounter.reset();
            BaseTypeConverterRegistry.this.attemptCounter.reset();
            BaseTypeConverterRegistry.this.hitCounter.reset();
            BaseTypeConverterRegistry.this.missCounter.reset();
            BaseTypeConverterRegistry.this.failedCounter.reset();
        }

        public boolean isStatisticsEnabled() {
            return this.statisticsEnabled;
        }

        public void setStatisticsEnabled(boolean statisticsEnabled) {
            this.statisticsEnabled = statisticsEnabled;
        }

        public String toString() {
            return String.format("TypeConverterRegistry utilization[noop=%s, attempts=%s, hits=%s, misses=%s, failures=%s]", this.getNoopCounter(), this.getAttemptCounter(), this.getHitCounter(), this.getMissCounter(), this.getFailedCounter());
        }
    }
}

