/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import org.apache.jackrabbit.core.query.lucene.PropertyMetaData;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.index.Payload;

public final class SingletonTokenStream
extends TokenStream {
    private String value;
    private Payload payload;
    private TermAttribute termAttribute;
    private PayloadAttribute payloadAttribute;
    private boolean consumed = false;

    public SingletonTokenStream(String value, Payload payload) {
        this.value = value;
        this.payload = payload;
        this.termAttribute = (TermAttribute)this.addAttribute(TermAttribute.class);
        this.payloadAttribute = (PayloadAttribute)this.addAttribute(PayloadAttribute.class);
    }

    public SingletonTokenStream(String value, int type) {
        this(value, new Payload(new PropertyMetaData(type).toByteArray()));
    }

    public boolean incrementToken() throws IOException {
        if (this.consumed) {
            return false;
        }
        this.clearAttributes();
        this.termAttribute.setTermBuffer(this.value);
        this.payloadAttribute.setPayload(this.payload);
        this.consumed = true;
        return true;
    }

    public void reset() throws IOException {
        this.consumed = false;
    }

    public void close() throws IOException {
        this.consumed = true;
        this.value = null;
        this.payload = null;
        this.payloadAttribute = null;
        this.termAttribute = null;
    }
}

