/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;

class MultiScorer
extends Scorer {
    private final Scorer[] scorers;
    private final int[] starts;
    private int currentScorer;
    private int currentDoc = -1;

    MultiScorer(Similarity similarity, Scorer[] scorers, int[] starts) {
        super(similarity);
        this.scorers = scorers;
        this.starts = starts;
    }

    public int nextDoc() throws IOException {
        while (this.currentDoc != Integer.MAX_VALUE) {
            if (this.scorers[this.currentScorer] != null && this.scorers[this.currentScorer].nextDoc() != Integer.MAX_VALUE) {
                this.currentDoc = this.scorers[this.currentScorer].docID() + this.starts[this.currentScorer];
                return this.currentDoc;
            }
            if (++this.currentScorer < this.scorers.length) continue;
            this.currentDoc = Integer.MAX_VALUE;
        }
        return this.currentDoc;
    }

    public int docID() {
        return this.currentDoc;
    }

    public float score() throws IOException {
        return this.scorers[this.currentScorer].score();
    }

    public int advance(int target) throws IOException {
        if (this.currentDoc == Integer.MAX_VALUE) {
            return this.currentDoc;
        }
        if (target == Integer.MAX_VALUE) {
            for (Scorer s : this.scorers) {
                if (s.docID() == target) continue;
                s.advance(target);
            }
            this.currentDoc = Integer.MAX_VALUE;
            return this.currentDoc;
        }
        this.currentScorer = this.scorerIndex(target);
        if (this.scorers[this.currentScorer].advance(target - this.starts[this.currentScorer]) != Integer.MAX_VALUE) {
            this.currentDoc = this.scorers[this.currentScorer].docID() + this.starts[this.currentScorer];
            return this.currentDoc;
        }
        if (++this.currentScorer < this.scorers.length) {
            this.currentDoc = this.nextDoc();
            return this.currentDoc;
        }
        this.currentDoc = Integer.MAX_VALUE;
        return this.currentDoc;
    }

    private int scorerIndex(int n) {
        int lo = 0;
        int hi = this.scorers.length - 1;
        while (hi >= lo) {
            int mid = lo + hi >> 1;
            int midValue = this.starts[mid];
            if (n < midValue) {
                hi = mid - 1;
                continue;
            }
            if (n > midValue) {
                lo = mid + 1;
                continue;
            }
            while (mid + 1 < this.scorers.length && this.starts[mid + 1] == midValue) {
                ++mid;
            }
            return mid;
        }
        return hi;
    }
}

