/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.id;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.UUID;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.id.NodeId;

public class NodeIdFactory {
    public static final String SEQUENTIAL_NODE_ID = "jackrabbit.sequentialNodeId";
    private static final String NODE_ID_FILE = "nodeId.properties";
    private static final String NODE_ID_FILE_TEMP = "nodeId.properties.temp";
    private static final String MSB = "msb";
    private static final String NEXT_LSB = "nextLsb";
    private static final int DEFAULT_CACHE_SIZE = 128;
    private final String repositoryHome;
    private boolean createRandom;
    private long msb;
    private long nextLsb;
    private long storedLsb;
    private int cacheSize = 128;

    public NodeIdFactory(String repositoryHome) {
        this.repositoryHome = repositoryHome;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws RepositoryException {
        String seq = System.getProperty(SEQUENTIAL_NODE_ID);
        if (seq == null) {
            this.createRandom = true;
            return;
        }
        try {
            String m;
            File n = new File(this.repositoryHome, NODE_ID_FILE);
            if (!n.exists()) {
                File temp = new File(this.repositoryHome, NODE_ID_FILE_TEMP);
                if (temp.exists()) {
                    temp.renameTo(n);
                } else {
                    n.getParentFile().mkdirs();
                    n.createNewFile();
                }
            }
            Properties p = new Properties();
            try (FileInputStream in = new FileInputStream(n);){
                p.load(in);
            }
            String defaultMsb = "";
            String defaultLsb = "0";
            int index = seq.indexOf("/");
            if (index >= 0) {
                defaultMsb = seq.substring(0, index);
                defaultLsb = seq.substring(index + 1);
            }
            if ((m = p.getProperty(MSB, defaultMsb)).length() == 0) {
                this.msb = UUID.randomUUID().getMostSignificantBits();
                this.msb &= 0xFFFFFFFFFFFF0FFFL;
            } else {
                this.msb = m.length() == 16 ? Long.parseLong(m.substring(0, 8), 16) << 32 | Long.parseLong(m.substring(8), 16) : Long.parseLong(m, 16);
            }
            this.storedLsb = this.nextLsb = Long.parseLong(p.getProperty(NEXT_LSB, defaultLsb), 16);
        }
        catch (Exception e) {
            throw new RepositoryException("Could not open node id factory", (Throwable)e);
        }
    }

    public void close() throws RepositoryException {
        if (!this.createRandom) {
            this.store(this.nextLsb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(long lsb) throws RepositoryException {
        this.storedLsb = lsb;
        Properties p = new Properties();
        p.setProperty(MSB, Long.toHexString(this.msb));
        p.setProperty(NEXT_LSB, Long.toHexString(lsb));
        try {
            File temp = new File(this.repositoryHome, NODE_ID_FILE_TEMP);
            try (FileOutputStream out = new FileOutputStream(temp);){
                p.store(out, null);
            }
            File n = new File(this.repositoryHome, NODE_ID_FILE);
            n.delete();
            temp.renameTo(n);
        }
        catch (IOException e) {
            throw new RepositoryException("Could not store next node id", (Throwable)e);
        }
    }

    public NodeId newNodeId() throws RepositoryException {
        long lsb;
        if (this.createRandom) {
            return NodeId.randomId();
        }
        if ((lsb = this.nextLsb++) >= this.storedLsb) {
            this.store(lsb + (long)this.cacheSize);
        }
        return new NodeId(this.msb, lsb);
    }
}

