/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jdbc;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class JdbcEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":dataSourceName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "jdbc".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "dataSourceName", null, true, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(15);
        props.add("resetAutoCommit");
        props.add("synchronous");
        props.add("outputType");
        props.add("transacted");
        props.add("useHeadersAsParameters");
        props.add("allowNamedParameters");
        props.add("dataSourceName");
        props.add("useJDBC4ColumnNameAndLabelSemantics");
        props.add("prepareStatementStrategy");
        props.add("lazyStartProducer");
        props.add("beanRowMapper");
        props.add("useGetBytesForBlob");
        props.add("outputClass");
        props.add("parameters");
        props.add("readSize");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

