/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.std.UntypedObjectDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import java.io.IOException;
import java.util.LinkedHashMap;

public class AvroUntypedDeserializer
extends UntypedObjectDeserializer
implements ResolvableDeserializer {
    private static final long serialVersionUID = 1L;
    protected JavaType _typeObject;
    protected TypeDeserializer _typeDeserializer;

    public void resolve(DeserializationContext ctxt) throws JsonMappingException {
        this._typeObject = ctxt.constructType(Object.class);
        this._typeDeserializer = ctxt.getConfig().findTypeDeserializer(this._typeObject);
    }

    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        TypeIdResolver resolver;
        Object typeId;
        if (p.canReadTypeId() && (typeId = p.getTypeId()) != null && this._typeDeserializer != null && (resolver = this._typeDeserializer.getTypeIdResolver()) != null && resolver.typeFromId((DatabindContext)ctxt, typeId.toString()) != null) {
            return this._typeDeserializer.deserializeTypedFromAny(p, ctxt);
        }
        return super.deserialize(p, ctxt);
    }

    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        TypeIdResolver resolver;
        if (p.canReadTypeId() && p.getTypeId() != null && typeDeserializer != null && (resolver = typeDeserializer.getTypeIdResolver()) != null && resolver.typeFromId((DatabindContext)ctxt, p.getTypeId().toString()) != null) {
            return typeDeserializer.deserializeTypedFromAny(p, ctxt);
        }
        return super.deserializeWithType(p, ctxt, typeDeserializer);
    }

    protected Object mapObject(JsonParser p, DeserializationContext ctxt) throws IOException {
        TypeIdResolver idResolver;
        JavaType keyType;
        Object key1;
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            key1 = p.nextFieldName();
        } else if (t == JsonToken.FIELD_NAME) {
            key1 = p.getCurrentName();
        } else {
            if (t != JsonToken.END_OBJECT) {
                return ctxt.handleUnexpectedToken(this.handledType(), p);
            }
            key1 = null;
        }
        if (key1 == null) {
            return new LinkedHashMap(2);
        }
        KeyDeserializer deserializer = null;
        if (p.getTypeId() != null && this._typeDeserializer != null && (keyType = (idResolver = this._typeDeserializer.getTypeIdResolver()).typeFromId((DatabindContext)ctxt, p.getTypeId().toString())) != null) {
            deserializer = ctxt.findKeyDeserializer(keyType, null);
        }
        if (deserializer != null) {
            key1 = deserializer.deserializeKey(key1.toString(), ctxt);
        }
        p.nextToken();
        Object value1 = this.deserialize(p, ctxt);
        Object key2 = p.nextFieldName();
        if (key2 == null) {
            LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>(2);
            result.put(key1, value1);
            return result;
        }
        if (deserializer != null) {
            key2 = deserializer.deserializeKey(key2.toString(), ctxt);
        }
        p.nextToken();
        Object value2 = this.deserialize(p, ctxt);
        Object key = p.nextFieldName();
        if (key == null) {
            LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>(4);
            result.put(key1, value1);
            result.put(key2, value2);
            return result;
        }
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
        result.put(key1, value1);
        result.put(key2, value2);
        do {
            if (deserializer != null) {
                key = deserializer.deserializeKey(key.toString(), ctxt);
            }
            p.nextToken();
            result.put(key, this.deserialize(p, ctxt));
        } while ((key = p.nextFieldName()) != null);
        return result;
    }
}

