/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jdbc;

import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.component.jdbc.JdbcEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.PropertiesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.apache.camel.spi.annotations.Component(value="jdbc")
public class JdbcComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcComponent.class);
    @Metadata
    private DataSource dataSource;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String dataSourceRef;
        DataSource dataSource;
        if (this.dataSource != null) {
            dataSource = this.dataSource;
            dataSourceRef = "component";
        } else {
            DataSource target = (DataSource)CamelContextHelper.lookup((CamelContext)this.getCamelContext(), (String)remaining, DataSource.class);
            if (target == null && !JdbcComponent.isDefaultDataSourceName(remaining)) {
                throw new NoSuchBeanException(remaining, DataSource.class.getName());
            }
            if (target == null) {
                Set dataSources = this.getCamelContext().getRegistry().findByType(DataSource.class);
                if (dataSources.size() > 1) {
                    throw new IllegalArgumentException("Multiple DataSources found in the registry and no explicit configuration provided");
                }
                if (dataSources.size() == 1) {
                    target = (DataSource)dataSources.iterator().next();
                }
                if (target == null) {
                    throw new IllegalArgumentException("No default DataSource found in the registry");
                }
                LOG.debug("Using default DataSource discovered from registry: {}", (Object)target);
            }
            dataSource = target;
            dataSourceRef = remaining;
        }
        Map params = PropertiesHelper.extractProperties(parameters, (String)"statement.");
        JdbcEndpoint jdbc = new JdbcEndpoint(uri, (Component)this, dataSource);
        jdbc.setDataSourceName(dataSourceRef);
        jdbc.setParameters(params);
        this.setProperties((Endpoint)jdbc, parameters);
        return jdbc;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    private static boolean isDefaultDataSourceName(String remaining) {
        return "dataSource".equalsIgnoreCase(remaining) || "default".equalsIgnoreCase(remaining);
    }
}

