/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.component.jdbc.JdbcEndpoint;
import org.apache.camel.component.jdbc.JdbcHelper;
import org.apache.camel.component.jdbc.JdbcOutputType;
import org.apache.camel.component.jdbc.ResultSetIterator;
import org.apache.camel.component.jdbc.StreamListIterator;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.PropertyBindingSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class JdbcProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcProducer.class);
    private DataSource dataSource;
    private int readSize;
    private Map<String, Object> parameters;

    public JdbcProducer(JdbcEndpoint endpoint, DataSource dataSource, int readSize, Map<String, Object> parameters) throws Exception {
        super((Endpoint)endpoint);
        this.dataSource = dataSource;
        this.readSize = readSize;
        this.parameters = parameters;
    }

    public JdbcEndpoint getEndpoint() {
        return (JdbcEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        if (this.getEndpoint().isResetAutoCommit()) {
            this.processingSqlBySettingAutoCommit(exchange);
        } else {
            this.processingSqlWithoutSettingAutoCommit(exchange);
        }
    }

    private void processingSqlBySettingAutoCommit(Exchange exchange) throws Exception {
        String sql = (String)exchange.getIn().getBody(String.class);
        Connection conn = null;
        Boolean autoCommit = null;
        boolean shouldCloseResources = true;
        try {
            conn = DataSourceUtils.getConnection((DataSource)this.dataSource);
            autoCommit = conn.getAutoCommit();
            if (autoCommit.booleanValue()) {
                conn.setAutoCommit(false);
            }
            shouldCloseResources = this.createAndExecuteSqlStatement(exchange, sql, conn);
            conn.commit();
        }
        catch (Exception e) {
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (Throwable sqle) {
                LOG.warn("Error occurred during JDBC rollback. This exception will be ignored.", sqle);
            }
            throw e;
        }
        finally {
            if (shouldCloseResources) {
                this.resetAutoCommit(conn, autoCommit);
                this.closeQuietly(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processingSqlWithoutSettingAutoCommit(Exchange exchange) throws Exception {
        String sql = (String)exchange.getIn().getBody(String.class);
        Connection conn = null;
        boolean shouldCloseResources = true;
        try {
            conn = DataSourceUtils.getConnection((DataSource)this.dataSource);
            shouldCloseResources = this.createAndExecuteSqlStatement(exchange, sql, conn);
        }
        finally {
            if (shouldCloseResources && !DataSourceUtils.isConnectionTransactional((Connection)conn, (DataSource)this.dataSource)) {
                this.closeQuietly(conn);
            }
        }
    }

    private boolean createAndExecuteSqlStatement(Exchange exchange, String sql, Connection conn) throws Exception {
        if (this.getEndpoint().isUseHeadersAsParameters()) {
            return this.doCreateAndExecuteSqlStatementWithHeaders(exchange, sql, conn);
        }
        return this.doCreateAndExecuteSqlStatement(exchange, sql, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean doCreateAndExecuteSqlStatementWithHeaders(Exchange exchange, String sql, Connection conn) throws Exception {
        PreparedStatement ps = null;
        ResultSet rs = null;
        boolean shouldCloseResources = true;
        try {
            int expectedCount;
            String preparedQuery = this.getEndpoint().getPrepareStatementStrategy().prepareQuery(sql, this.getEndpoint().isAllowNamedParameters());
            Boolean shouldRetrieveGeneratedKeys = (Boolean)exchange.getIn().getHeader("CamelRetrieveGeneratedKeys", (Object)false, Boolean.class);
            if (shouldRetrieveGeneratedKeys.booleanValue()) {
                Object expectedGeneratedColumns = exchange.getIn().getHeader("CamelGeneratedColumns");
                if (expectedGeneratedColumns == null) {
                    ps = conn.prepareStatement(preparedQuery, 1);
                } else if (expectedGeneratedColumns instanceof String[]) {
                    ps = conn.prepareStatement(preparedQuery, (String[])expectedGeneratedColumns);
                } else {
                    if (!(expectedGeneratedColumns instanceof int[])) throw new IllegalArgumentException("Header specifying expected returning columns isn't an instance of String[] or int[] but " + expectedGeneratedColumns.getClass());
                    ps = conn.prepareStatement(preparedQuery, (int[])expectedGeneratedColumns);
                }
            } else {
                ps = conn.prepareStatement(preparedQuery);
            }
            if ((expectedCount = ps.getParameterMetaData().getParameterCount()) > 0) {
                Iterator<?> it = this.getEndpoint().getPrepareStatementStrategy().createPopulateIterator(sql, preparedQuery, expectedCount, exchange, exchange.getIn().getBody());
                this.getEndpoint().getPrepareStatementStrategy().populateStatement(ps, it, expectedCount);
            }
            LOG.debug("Executing JDBC PreparedStatement: {}", (Object)sql);
            boolean stmtExecutionResult = ps.execute();
            if (stmtExecutionResult) {
                rs = ps.getResultSet();
                shouldCloseResources = this.setResultSet(exchange, conn, rs);
            } else {
                int updateCount = ps.getUpdateCount();
                exchange.getMessage().setHeader("CamelJdbcUpdateCount", (Object)updateCount);
            }
            if (shouldRetrieveGeneratedKeys.booleanValue()) {
                this.setGeneratedKeys(exchange, conn, ps.getGeneratedKeys());
            }
            if (!shouldCloseResources) return shouldCloseResources;
            this.closeQuietly(rs);
            this.closeQuietly(ps);
            return shouldCloseResources;
        }
        catch (Throwable throwable) {
            if (!shouldCloseResources) throw throwable;
            this.closeQuietly(rs);
            this.closeQuietly(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean doCreateAndExecuteSqlStatement(Exchange exchange, String sql, Connection conn) throws Exception {
        Statement stmt = null;
        ResultSet rs = null;
        boolean shouldCloseResources = true;
        try {
            boolean stmtExecutionResult;
            stmt = conn.createStatement();
            if (this.parameters != null && !this.parameters.isEmpty()) {
                HashMap<String, Object> copy = new HashMap<String, Object>(this.parameters);
                PropertyBindingSupport.bindProperties((CamelContext)exchange.getContext(), (Object)stmt, copy);
            }
            LOG.debug("Executing JDBC Statement: {}", (Object)sql);
            Boolean shouldRetrieveGeneratedKeys = (Boolean)exchange.getIn().getHeader("CamelRetrieveGeneratedKeys", (Object)false, Boolean.class);
            if (shouldRetrieveGeneratedKeys.booleanValue()) {
                Object expectedGeneratedColumns = exchange.getIn().getHeader("CamelGeneratedColumns");
                if (expectedGeneratedColumns == null) {
                    stmtExecutionResult = stmt.execute(sql, 1);
                } else if (expectedGeneratedColumns instanceof String[]) {
                    stmtExecutionResult = stmt.execute(sql, (String[])expectedGeneratedColumns);
                } else {
                    if (!(expectedGeneratedColumns instanceof int[])) throw new IllegalArgumentException("Header specifying expected returning columns isn't an instance of String[] or int[] but " + expectedGeneratedColumns.getClass());
                    stmtExecutionResult = stmt.execute(sql, (int[])expectedGeneratedColumns);
                }
            } else {
                stmtExecutionResult = stmt.execute(sql);
            }
            if (stmtExecutionResult) {
                rs = stmt.getResultSet();
                shouldCloseResources = this.setResultSet(exchange, conn, rs);
            } else {
                int updateCount = stmt.getUpdateCount();
                exchange.getMessage().setHeader("CamelJdbcUpdateCount", (Object)updateCount);
            }
            if (shouldRetrieveGeneratedKeys.booleanValue()) {
                this.setGeneratedKeys(exchange, conn, stmt.getGeneratedKeys());
            }
            if (!shouldCloseResources) return shouldCloseResources;
            this.closeQuietly(rs);
            this.closeQuietly(stmt);
            return shouldCloseResources;
        }
        catch (Throwable throwable) {
            if (!shouldCloseResources) throw throwable;
            this.closeQuietly(rs);
            this.closeQuietly(stmt);
            throw throwable;
        }
    }

    private void closeQuietly(ResultSet rs) {
        if (rs != null) {
            try {
                if (!rs.isClosed()) {
                    rs.close();
                }
            }
            catch (Throwable sqle) {
                LOG.debug("Error by closing result set", sqle);
            }
        }
    }

    private void closeQuietly(Statement stmt) {
        if (stmt != null) {
            try {
                if (!stmt.isClosed()) {
                    stmt.close();
                }
            }
            catch (Throwable sqle) {
                LOG.debug("Error by closing statement", sqle);
            }
        }
    }

    private void resetAutoCommit(Connection con, Boolean autoCommit) {
        if (con != null && autoCommit != null) {
            try {
                con.setAutoCommit(autoCommit);
            }
            catch (Throwable sqle) {
                LOG.debug("Error by resetting auto commit to its original value", sqle);
            }
        }
    }

    private void closeQuietly(Connection con) {
        if (con != null) {
            try {
                if (!con.isClosed()) {
                    con.close();
                }
            }
            catch (Throwable sqle) {
                LOG.debug("Error by closing connection", sqle);
            }
        }
    }

    protected void setGeneratedKeys(Exchange exchange, Connection conn, ResultSet generatedKeys) throws SQLException {
        if (generatedKeys != null) {
            ResultSetIterator iterator = new ResultSetIterator(conn, generatedKeys, this.getEndpoint().isUseJDBC4ColumnNameAndLabelSemantics(), this.getEndpoint().isUseGetBytesForBlob());
            List data = this.extractRows(iterator);
            exchange.getMessage().setHeader("CamelGeneratedKeysRowCount", (Object)data.size());
            exchange.getMessage().setHeader("CamelGeneratedKeysRows", (Object)data);
        }
    }

    protected boolean setResultSet(Exchange exchange, Connection conn, ResultSet rs) throws SQLException {
        boolean answer = true;
        ResultSetIterator iterator = new ResultSetIterator(conn, rs, this.getEndpoint().isUseJDBC4ColumnNameAndLabelSemantics(), this.getEndpoint().isUseGetBytesForBlob());
        JdbcOutputType outputType = this.getEndpoint().getOutputType();
        exchange.getMessage().setHeader("CamelJdbcColumnNames", iterator.getColumnNames());
        if (outputType == JdbcOutputType.StreamList) {
            exchange.getMessage().setBody((Object)new StreamListIterator(this.getEndpoint().getCamelContext(), this.getEndpoint().getOutputClass(), this.getEndpoint().getBeanRowMapper(), iterator));
            ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).addOnCompletion((Synchronization)new ResultSetIteratorCompletion(iterator));
            answer = false;
        } else if (outputType == JdbcOutputType.SelectList) {
            List list = this.extractRows(iterator);
            exchange.getMessage().setHeader("CamelJdbcRowCount", (Object)list.size());
            exchange.getMessage().setBody((Object)list);
        } else if (outputType == JdbcOutputType.SelectOne) {
            exchange.getMessage().setBody(this.extractSingleRow(iterator));
        }
        return answer;
    }

    private List extractRows(ResultSetIterator iterator) throws SQLException {
        ArrayList<Object> result = new ArrayList<Object>();
        int maxRowCount = this.readSize == 0 ? Integer.MAX_VALUE : this.readSize;
        for (int i = 0; iterator.hasNext() && i < maxRowCount; ++i) {
            Object row = iterator.next();
            Object value = this.getEndpoint().getOutputClass() != null ? JdbcHelper.newBeanInstance(this.getEndpoint().getCamelContext(), this.getEndpoint().getOutputClass(), this.getEndpoint().getBeanRowMapper(), (Map<String, Object>)row) : row;
            result.add(value);
        }
        return result;
    }

    private Object extractSingleRow(ResultSetIterator iterator) throws SQLException {
        if (!iterator.hasNext()) {
            return null;
        }
        Object row = iterator.next();
        if (iterator.hasNext()) {
            throw new SQLDataException("Query result not unique for outputType=SelectOne.");
        }
        if (this.getEndpoint().getOutputClass() != null) {
            return JdbcHelper.newBeanInstance(this.getEndpoint().getCamelContext(), this.getEndpoint().getOutputClass(), this.getEndpoint().getBeanRowMapper(), (Map<String, Object>)row);
        }
        if (row.size() == 1) {
            return row.values().iterator().next();
        }
        return row;
    }

    private static final class ResultSetIteratorCompletion
    implements Synchronization {
        private final ResultSetIterator iterator;

        private ResultSetIteratorCompletion(ResultSetIterator iterator) {
            this.iterator = iterator;
        }

        public void onComplete(Exchange exchange) {
            this.iterator.close();
            this.iterator.closeConnection();
        }

        public void onFailure(Exchange exchange) {
            this.iterator.close();
            this.iterator.closeConnection();
        }
    }
}

