/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class CamelFilterWrapper
implements Filter {
    private Filter wrapped;

    public CamelFilterWrapper(Filter wrapped) {
        this.wrapped = wrapped;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request.getAttribute("CamelExchange") == null) {
            this.wrapped.doFilter(request, response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
        this.wrapped.destroy();
    }

    public void init(FilterConfig config) throws ServletException {
        Object o = config.getServletContext().getAttribute("javax.servlet.context.tempdir");
        if (o == null) {
            try {
                File file = Files.createTempFile("camel", "", new FileAttribute[0]).toFile();
                file.delete();
                config.getServletContext().setAttribute("javax.servlet.context.tempdir", (Object)file.getParentFile());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.wrapped.init(config);
    }
}

