/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.http.common;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeoutException;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StreamCache;
import org.apache.camel.attachment.AttachmentMessage;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.http.common.CamelFileDataSource;
import org.apache.camel.http.common.HttpBinding;
import org.apache.camel.http.common.HttpCommonEndpoint;
import org.apache.camel.http.common.HttpHeaderFilterStrategy;
import org.apache.camel.http.common.HttpHelper;
import org.apache.camel.http.common.HttpMessage;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.GZIPHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpBinding
implements HttpBinding {
    public static final String DATE_LOCALE_CONVERSION = "CamelHttpBindingDateLocaleConversion";
    public static final String DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHttpBinding.class);
    private static final TimeZone TIME_ZONE_GMT = TimeZone.getTimeZone("GMT");
    private boolean useReaderForPayload;
    private boolean eagerCheckContentAvailable;
    private boolean transferException;
    private boolean muteException;
    private boolean allowJavaSerializedObject;
    private boolean mapHttpMessageBody = true;
    private boolean mapHttpMessageHeaders = true;
    private boolean mapHttpMessageFormUrlEncodedBody = true;
    private HeaderFilterStrategy headerFilterStrategy = new HttpHeaderFilterStrategy();
    private String fileNameExtWhitelist;

    public DefaultHttpBinding() {
    }

    @Deprecated
    public DefaultHttpBinding(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    @Deprecated
    public DefaultHttpBinding(HttpCommonEndpoint endpoint) {
        this.headerFilterStrategy = endpoint.getHeaderFilterStrategy();
        this.transferException = endpoint.isTransferException();
        this.muteException = endpoint.isMuteException();
        if (endpoint.getComponent() != null) {
            this.allowJavaSerializedObject = endpoint.getComponent().isAllowJavaSerializedObject();
        }
    }

    @Override
    public void readRequest(HttpServletRequest request, HttpMessage message) {
        LOG.trace("readRequest {}", (Object)request);
        if (this.mapHttpMessageBody) {
            this.readBody(request, message);
        }
        if (this.mapHttpMessageHeaders) {
            this.readHeaders(request, message);
        }
        if (this.mapHttpMessageFormUrlEncodedBody) {
            try {
                this.readFormUrlEncodedBody(request, message);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeCamelException("Cannot read Form URL encoded body due " + e.getMessage(), (Throwable)e);
            }
        }
        Map headers = message.getHeaders();
        String rawPath = this.getRawPath(request);
        headers.put("CamelHttpMethod", request.getMethod());
        headers.put("CamelHttpQuery", request.getQueryString());
        headers.put("CamelHttpUrl", request.getRequestURL().toString());
        headers.put("CamelHttpUri", request.getRequestURI());
        headers.put("CamelHttpPath", rawPath);
        if (!headers.containsKey("Content-Type")) {
            headers.put("Content-Type", request.getContentType());
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("HTTP method {}", (Object)request.getMethod());
            LOG.trace("HTTP query {}", (Object)request.getQueryString());
            LOG.trace("HTTP url {}", (Object)request.getRequestURL());
            LOG.trace("HTTP uri {}", (Object)request.getRequestURI());
            LOG.trace("HTTP path {}", (Object)rawPath);
            LOG.trace("HTTP content-type {}", headers.get("Content-Type"));
        }
    }

    protected void readHeaders(HttpServletRequest request, HttpMessage message) {
        LOG.trace("readHeaders {}", (Object)request);
        Map headers = message.getHeaders();
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = request.getHeader(name);
            Object extracted = HttpHelper.extractHttpParameterValue(value);
            if (name.toLowerCase().equals("content-type")) {
                name = "Content-Type";
            }
            if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name, extracted, message.getExchange())) continue;
            HttpHelper.appendHeader(headers, name, extracted);
        }
        if (request.getCharacterEncoding() != null) {
            headers.put("CamelHttpCharacterEncoding", request.getCharacterEncoding());
            message.getExchange().setProperty("CamelCharsetName", (Object)request.getCharacterEncoding());
        }
        try {
            this.populateRequestParameters(request, message);
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Cannot read request parameters due " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void readBody(HttpServletRequest request, HttpMessage message) {
        DefaultHttpBinding.LOG.trace("readBody {}", (Object)request);
        body = message.getBody();
        if (body instanceof StreamCache) {
            ((StreamCache)body).reset();
        }
        if (request.getContentType() != null && "application/x-java-serialized-object".equals(request.getContentType())) {
            if (this.allowJavaSerializedObject || this.isTransferException()) {
                try {
                    is = (InputStream)message.getExchange().getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, body);
                    object = HttpHelper.deserializeJavaObjectFromStream(is, message.getExchange().getContext());
                    if (object == null) ** GOTO lbl16
                    message.setBody(object);
                }
                catch (Exception e) {
                    throw new RuntimeCamelException("Cannot deserialize body to Java object", (Throwable)e);
                }
            } else {
                message.setBody(null);
            }
        }
lbl16:
        // 5 sources

        this.populateAttachments(request, message);
    }

    protected void populateRequestParameters(HttpServletRequest request, HttpMessage message) throws Exception {
        Map headers = message.getHeaders();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String[] values = request.getParameterValues(name);
            LOG.trace("HTTP parameter {} = {}", (Object)name, (Object)values);
            if (values == null) continue;
            for (String value : values) {
                if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name, (Object)value, message.getExchange())) continue;
                HttpHelper.appendHeader(headers, name, value);
            }
        }
    }

    protected void readFormUrlEncodedBody(HttpServletRequest request, HttpMessage message) throws UnsupportedEncodingException {
        LOG.trace("readFormUrlEncodedBody {}", (Object)request);
        if (this.mapHttpMessageBody && this.mapHttpMessageHeaders) {
            boolean skipWwwFormUrlEncoding;
            LOG.trace("HTTP method {} with Content-Type {}", (Object)request.getMethod(), (Object)request.getContentType());
            Map headers = message.getHeaders();
            Boolean flag = (Boolean)message.getHeader("CamelSkipWwwFormUrlEncoding", Boolean.class);
            boolean bl = skipWwwFormUrlEncoding = flag != null ? flag : false;
            if (request.getMethod().equals("POST") && request.getContentType() != null && request.getContentType().startsWith("application/x-www-form-urlencoded") && !skipWwwFormUrlEncoding) {
                String text;
                Object body;
                String charset = request.getCharacterEncoding();
                if (charset == null) {
                    charset = "UTF-8";
                }
                if ((body = message.getBody()) instanceof StreamCache) {
                    ((StreamCache)body).reset();
                }
                if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)(text = (String)message.getBody(String.class)))) {
                    for (String param : text.split("&")) {
                        String[] pair = param.split("=", 2);
                        if (pair.length == 2) {
                            String name = URLDecoder.decode(pair[0], charset);
                            String value = URLDecoder.decode(pair[1], charset);
                            if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name, (Object)value, message.getExchange())) continue;
                            HttpHelper.appendHeader(headers, name, value);
                            continue;
                        }
                        throw new IllegalArgumentException("Invalid parameter, expected to be a pair but was " + param);
                    }
                }
                if (body instanceof StreamCache) {
                    ((StreamCache)body).reset();
                }
            }
        }
    }

    private String getRawPath(HttpServletRequest request) {
        String uri = request.getRequestURI();
        String contextPath = request.getContextPath() == null ? "" : request.getContextPath();
        String servletPath = request.getServletPath() == null ? "" : request.getServletPath();
        return uri.substring(contextPath.length() + servletPath.length());
    }

    protected void populateAttachments(HttpServletRequest request, HttpMessage message) {
        Enumeration names = request.getAttributeNames();
        while (names.hasMoreElements()) {
            String ext;
            String name = (String)names.nextElement();
            Object object = request.getAttribute(name);
            LOG.trace("HTTP attachment {} = {}", (Object)name, object);
            if (!(object instanceof File)) continue;
            String fileName = request.getParameter(name);
            boolean accepted = true;
            if (this.fileNameExtWhitelist != null && (ext = FileUtil.onlyExt((String)fileName)) != null) {
                ext = ext.toLowerCase(Locale.US);
                this.fileNameExtWhitelist = this.fileNameExtWhitelist.toLowerCase(Locale.US);
                if (!this.fileNameExtWhitelist.equals("*") && !this.fileNameExtWhitelist.contains(ext)) {
                    accepted = false;
                }
            }
            if (accepted) {
                AttachmentMessage am = (AttachmentMessage)message.getExchange().getMessage(AttachmentMessage.class);
                am.addAttachment(fileName, new DataHandler((DataSource)new CamelFileDataSource((File)object, fileName)));
                continue;
            }
            LOG.debug("Cannot add file as attachment: {} because the file is not accepted according to fileNameExtWhitelist: {}", (Object)fileName, (Object)this.fileNameExtWhitelist);
        }
    }

    @Override
    public void writeResponse(Exchange exchange, HttpServletResponse response) throws IOException {
        Message target = exchange.getMessage();
        if (exchange.isFailed()) {
            if (exchange.getException() != null) {
                this.doWriteExceptionResponse(exchange.getException(), response);
            } else {
                this.doWriteFaultResponse(target, response, exchange);
            }
        } else {
            if (exchange.hasOut()) {
                this.copyProtocolHeaders(exchange.getIn(), exchange.getOut());
            }
            this.doWriteResponse(target, response, exchange);
        }
    }

    private void copyProtocolHeaders(Message request, Message response) {
        if (request.getHeader("Content-Encoding") != null) {
            String contentEncoding = (String)request.getHeader("Content-Encoding", String.class);
            response.setHeader("Content-Encoding", (Object)contentEncoding);
        }
        if (this.checkChunked(response, response.getExchange())) {
            response.setHeader("Transfer-Encoding", (Object)"chunked");
        }
    }

    @Override
    public void doWriteExceptionResponse(Throwable exception, HttpServletResponse response) throws IOException {
        if (exception instanceof TimeoutException) {
            response.setStatus(504);
            response.setContentType("text/plain");
            response.getWriter().write("Timeout error");
        } else if (this.isMuteException()) {
            response.setStatus(500);
            response.setContentType("text/plain");
            response.getWriter().write("Exception");
        } else {
            response.setStatus(500);
            if (this.isTransferException()) {
                HttpHelper.writeObjectToServletResponse((ServletResponse)response, exception);
            } else {
                response.setContentType("text/plain");
                PrintWriter pw = response.getWriter();
                exception.printStackTrace(pw);
                pw.flush();
            }
        }
    }

    @Override
    public void doWriteFaultResponse(Message message, HttpServletResponse response, Exchange exchange) throws IOException {
        this.doWriteResponse(message, response, exchange);
    }

    @Override
    public void doWriteResponse(Message message, HttpServletResponse response, Exchange exchange) throws IOException {
        int statusCode = this.determineResponseCode(exchange, exchange.getMessage().getBody());
        response.setStatus(statusCode);
        String contentType = MessageHelper.getContentType((Message)message);
        if (contentType != null) {
            response.setContentType(contentType);
        }
        for (Map.Entry entry : message.getHeaders().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Iterator it = ObjectHelper.createIterator(value, null, (boolean)true);
            while (it.hasNext()) {
                String headerValue = this.convertHeaderValueToString(exchange, it.next());
                if (headerValue == null || this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToCamelHeaders(key, (Object)headerValue, exchange)) continue;
                response.addHeader(key, headerValue);
            }
        }
        if (message.getBody() != null) {
            if (GZIPHelper.isGzip((Message)message)) {
                this.doWriteGZIPResponse(message, response, exchange);
            } else {
                this.doWriteDirectResponse(message, response, exchange);
            }
        }
    }

    private int determineResponseCode(Exchange camelExchange, Object body) {
        int codeToUse;
        boolean failed = camelExchange.isFailed();
        int defaultCode = failed ? 500 : 200;
        Message message = camelExchange.getMessage();
        Integer currentCode = (Integer)message.getHeader("CamelHttpResponseCode", Integer.class);
        int n = codeToUse = currentCode == null ? defaultCode : currentCode;
        if (codeToUse != 500 && (body == null || body instanceof String && ((String)body).trim().isEmpty())) {
            codeToUse = currentCode == null ? 204 : currentCode;
        }
        return codeToUse;
    }

    protected String convertHeaderValueToString(Exchange exchange, Object headerValue) {
        if ((headerValue instanceof Date || headerValue instanceof Locale) && this.convertDateAndLocaleLocally(exchange)) {
            if (headerValue instanceof Date) {
                return DefaultHttpBinding.toHttpDate((Date)headerValue);
            }
            return DefaultHttpBinding.toHttpLanguage((Locale)headerValue);
        }
        return (String)exchange.getContext().getTypeConverter().convertTo(String.class, headerValue);
    }

    protected boolean convertDateAndLocaleLocally(Exchange exchange) {
        return (Boolean)exchange.getProperty(DATE_LOCALE_CONVERSION, (Object)Boolean.TRUE, Boolean.class);
    }

    protected boolean isText(String contentType) {
        String temp;
        return contentType != null && ((temp = contentType.toLowerCase()).contains("text") || temp.contains("html"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int copyStream(InputStream is, OutputStream os, int bufferSize) throws IOException {
        int n;
        try {
            n = IOHelper.copy((InputStream)is, (OutputStream)os, (int)bufferSize, (boolean)true);
        }
        catch (Throwable throwable) {
            IOHelper.close((Closeable[])new Closeable[]{os, is});
            throw throwable;
        }
        IOHelper.close((Closeable[])new Closeable[]{os, is});
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWriteDirectResponse(Message message, HttpServletResponse response, Exchange exchange) throws IOException {
        block19: {
            block20: {
                ServletOutputStream os;
                InputStream is;
                block21: {
                    block18: {
                        String contentType = (String)message.getHeader("Content-Type", String.class);
                        if ("application/x-java-serialized-object".equals(contentType)) {
                            if (this.allowJavaSerializedObject || this.isTransferException()) {
                                try {
                                    Object object = message.getMandatoryBody(Serializable.class);
                                    HttpHelper.writeObjectToServletResponse((ServletResponse)response, object);
                                    return;
                                }
                                catch (InvalidPayloadException e) {
                                    throw new IOException(e);
                                }
                            }
                            throw new RuntimeCamelException("Content-type application/x-java-serialized-object is not allowed");
                        }
                        is = null;
                        if (this.checkChunked(message, exchange)) {
                            is = (InputStream)message.getBody(InputStream.class);
                        } else if (!this.isText(contentType)) {
                            is = (InputStream)exchange.getContext().getTypeConverter().tryConvertTo(InputStream.class, message.getBody());
                        }
                        if (is == null) break block20;
                        os = response.getOutputStream();
                        if (this.checkChunked(message, exchange)) break block21;
                        CachedOutputStream stream = new CachedOutputStream(exchange);
                        try {
                            int len = this.copyStream(is, (OutputStream)stream, response.getBufferSize());
                            response.setContentLength(len);
                            OutputStream current = stream.getCurrentStream();
                            if (current instanceof ByteArrayOutputStream) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("Streaming (direct) response in non-chunked mode with content-length {}", (Object)len);
                                }
                                ByteArrayOutputStream bos = (ByteArrayOutputStream)current;
                                bos.writeTo((OutputStream)os);
                                break block18;
                            }
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Streaming response in non-chunked mode with content-length {} and buffer size: {}", (Object)len, (Object)len);
                            }
                            this.copyStream(stream.getInputStream(), (OutputStream)os, len);
                        }
                        catch (Throwable throwable) {
                            IOHelper.close((Closeable[])new Closeable[]{is, os});
                            throw throwable;
                        }
                    }
                    IOHelper.close((Closeable[])new Closeable[]{is, os});
                    break block19;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Streaming response in chunked mode with buffer size {}", (Object)response.getBufferSize());
                }
                this.copyStream(is, (OutputStream)os, response.getBufferSize());
                break block19;
            }
            String data = (String)message.getBody(String.class);
            if (data != null) {
                String charset = ExchangeHelper.getCharsetName((Exchange)exchange, (boolean)true);
                int dataByteLength = data.getBytes(charset).length;
                response.setCharacterEncoding(charset);
                response.setContentLength(dataByteLength);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Writing response in non-chunked mode as plain text with content-length {} and buffer size: {}", (Object)dataByteLength, (Object)response.getBufferSize());
                }
                try {
                    response.getWriter().print(data);
                }
                finally {
                    response.getWriter().flush();
                }
            }
        }
    }

    protected boolean checkChunked(Message message, Exchange exchange) {
        boolean answer = true;
        if (message.getHeader("CamelHttpChunked") == null) {
            Endpoint endpoint = exchange.getFromEndpoint();
            if (endpoint instanceof HttpCommonEndpoint) {
                answer = ((HttpCommonEndpoint)endpoint).isChunked();
            }
        } else {
            answer = (Boolean)message.getHeader("CamelHttpChunked", Boolean.TYPE);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWriteGZIPResponse(Message message, HttpServletResponse response, Exchange exchange) throws IOException {
        byte[] bytes;
        try {
            bytes = (byte[])message.getMandatoryBody(byte[].class);
        }
        catch (InvalidPayloadException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        byte[] data = GZIPHelper.compressGZIP((byte[])bytes);
        ServletOutputStream os = response.getOutputStream();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Streaming response as GZIP in non-chunked mode with content-length {} and buffer size: {}", (Object)data.length, (Object)response.getBufferSize());
            }
            response.setContentLength(data.length);
            os.write(data);
            os.flush();
        }
        finally {
            IOHelper.close((Closeable)os);
        }
    }

    @Override
    public Object parseBody(HttpMessage httpMessage) throws IOException {
        ServletInputStream is;
        HttpServletRequest request = httpMessage.getRequest();
        int len = request.getContentLength();
        LOG.trace("HttpServletRequest content-length: {}", (Object)len);
        if (len == 0) {
            return null;
        }
        if (this.isUseReaderForPayload()) {
            return request.getReader();
        }
        if (len < 0 && this.isEagerCheckContentAvailable() && (is = request.getInputStream()).available() == 0) {
            return null;
        }
        return HttpHelper.readRequestBodyFromServletRequest(request, httpMessage.getExchange());
    }

    @Override
    public boolean isUseReaderForPayload() {
        return this.useReaderForPayload;
    }

    @Override
    public void setUseReaderForPayload(boolean useReaderForPayload) {
        this.useReaderForPayload = useReaderForPayload;
    }

    @Override
    public boolean isEagerCheckContentAvailable() {
        return this.eagerCheckContentAvailable;
    }

    @Override
    public void setEagerCheckContentAvailable(boolean eagerCheckContentAvailable) {
        this.eagerCheckContentAvailable = eagerCheckContentAvailable;
    }

    @Override
    public boolean isTransferException() {
        return this.transferException;
    }

    @Override
    public void setTransferException(boolean transferException) {
        this.transferException = transferException;
    }

    @Override
    public boolean isMuteException() {
        return this.muteException;
    }

    @Override
    public void setMuteException(boolean muteException) {
        this.muteException = muteException;
    }

    @Override
    public boolean isAllowJavaSerializedObject() {
        return this.allowJavaSerializedObject;
    }

    @Override
    public void setAllowJavaSerializedObject(boolean allowJavaSerializedObject) {
        this.allowJavaSerializedObject = allowJavaSerializedObject;
    }

    @Override
    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    @Override
    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    @Override
    public boolean isMapHttpMessageBody() {
        return this.mapHttpMessageBody;
    }

    @Override
    public void setMapHttpMessageBody(boolean mapHttpMessageBody) {
        this.mapHttpMessageBody = mapHttpMessageBody;
    }

    @Override
    public boolean isMapHttpMessageHeaders() {
        return this.mapHttpMessageHeaders;
    }

    @Override
    public void setMapHttpMessageHeaders(boolean mapHttpMessageHeaders) {
        this.mapHttpMessageHeaders = mapHttpMessageHeaders;
    }

    @Override
    public boolean isMapHttpMessageFormUrlEncodedBody() {
        return this.mapHttpMessageFormUrlEncodedBody;
    }

    @Override
    public void setMapHttpMessageFormUrlEncodedBody(boolean mapHttpMessageFormUrlEncodedBody) {
        this.mapHttpMessageFormUrlEncodedBody = mapHttpMessageFormUrlEncodedBody;
    }

    @Override
    public String getFileNameExtWhitelist() {
        return this.fileNameExtWhitelist;
    }

    @Override
    public void setFileNameExtWhitelist(String fileNameExtWhitelist) {
        this.fileNameExtWhitelist = fileNameExtWhitelist;
    }

    protected static SimpleDateFormat getHttpDateFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT, Locale.US);
        dateFormat.setTimeZone(TIME_ZONE_GMT);
        return dateFormat;
    }

    protected static String toHttpDate(Date date) {
        SimpleDateFormat format = DefaultHttpBinding.getHttpDateFormat();
        return format.format(date);
    }

    protected static String toHttpLanguage(Locale locale) {
        StringBuilder sb = new StringBuilder();
        sb.append(locale.getLanguage());
        if (locale.getCountry() != null) {
            sb.append('-').append(locale.getCountry());
        }
        return sb.toString();
    }
}

