/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.camel.Expression;
import org.apache.camel.processor.aggregate.AggregationStrategyMethodInfo;
import org.apache.camel.processor.aggregate.AggregationStrategyParameterInfo;
import org.apache.camel.support.builder.ExpressionBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregationStrategyBeanInfo {
    private static final Logger LOG = LoggerFactory.getLogger(AggregationStrategyBeanInfo.class);
    private final Class<?> type;
    private final Method method;

    public AggregationStrategyBeanInfo(Class<?> type, Method method) {
        this.type = type;
        this.method = method;
    }

    protected AggregationStrategyMethodInfo createMethodInfo() {
        AggregationStrategyParameterInfo info;
        int i;
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        int size = parameterTypes.length;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating MethodInfo for class: {} method: {} having {} parameters", new Object[]{this.type, this.method, size});
        }
        if (size < 2) {
            throw new IllegalArgumentException("The method " + this.method.getName() + " must have at least two parameters, has: " + size);
        }
        if (size % 2 != 0) {
            throw new IllegalArgumentException("The method " + this.method.getName() + " must have equal number of parameters, has: " + size);
        }
        Annotation[][] parameterAnnotations = this.method.getParameterAnnotations();
        for (int i2 = 0; i2 < parameterAnnotations.length; ++i2) {
            Annotation[] annotations = parameterAnnotations[i2];
            if (annotations.length <= 0) continue;
            throw new IllegalArgumentException("Method parameter annotation: " + annotations[0] + " at index: " + i2 + " is not supported on method: " + this.method);
        }
        ArrayList<AggregationStrategyParameterInfo> oldParameters = new ArrayList<AggregationStrategyParameterInfo>();
        ArrayList<AggregationStrategyParameterInfo> newParameters = new ArrayList<AggregationStrategyParameterInfo>();
        for (i = 0; i < size / 2; ++i) {
            Class<?> oldType = parameterTypes[i];
            if (oldParameters.size() == 0) {
                Expression oldBody = ExpressionBuilder.mandatoryBodyExpression(oldType);
                info = new AggregationStrategyParameterInfo(i, oldType, oldBody);
                oldParameters.add(info);
                continue;
            }
            if (oldParameters.size() == 1) {
                Expression oldHeaders = ExpressionBuilder.headersExpression();
                info = new AggregationStrategyParameterInfo(i, oldType, oldHeaders);
                oldParameters.add(info);
                continue;
            }
            if (oldParameters.size() != 2) continue;
            Expression oldProperties = ExpressionBuilder.exchangePropertiesExpression();
            info = new AggregationStrategyParameterInfo(i, oldType, oldProperties);
            oldParameters.add(info);
        }
        for (i = size / 2; i < size; ++i) {
            Class<?> newType = parameterTypes[i];
            if (newParameters.size() == 0) {
                Expression newBody = ExpressionBuilder.mandatoryBodyExpression(newType);
                info = new AggregationStrategyParameterInfo(i, newType, newBody);
                newParameters.add(info);
                continue;
            }
            if (newParameters.size() == 1) {
                Expression newHeaders = ExpressionBuilder.headersExpression();
                info = new AggregationStrategyParameterInfo(i, newType, newHeaders);
                newParameters.add(info);
                continue;
            }
            if (newParameters.size() != 2) continue;
            Expression newProperties = ExpressionBuilder.exchangePropertiesExpression();
            info = new AggregationStrategyParameterInfo(i, newType, newProperties);
            newParameters.add(info);
        }
        return new AggregationStrategyMethodInfo(this.method, oldParameters, newParameters);
    }
}

