/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.jetty;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelJettySourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_JETTY_PATH_HTTP_URI_CONF = "camel.source.path.httpUri";
    public static final String CAMEL_SOURCE_JETTY_PATH_HTTP_URI_DOC = "The url of the HTTP endpoint to call.";
    public static final String CAMEL_SOURCE_JETTY_PATH_HTTP_URI_DEFAULT = null;
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_CHUNKED_CONF = "camel.source.endpoint.chunked";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_CHUNKED_DOC = "If this option is false the Servlet will disable the HTTP streaming and set the content-length header on the response";
    public static final Boolean CAMEL_SOURCE_JETTY_ENDPOINT_CHUNKED_DEFAULT = true;
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_DISABLE_STREAM_CACHE_CONF = "camel.source.endpoint.disableStreamCache";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_DISABLE_STREAM_CACHE_DOC = "Determines whether or not the raw input stream from Servlet is cached or not (Camel will read the stream into a in memory/overflow to file, Stream caching) cache. By default Camel will cache the Servlet input stream to support reading it multiple times to ensure it Camel can retrieve all data from the stream. However you can set this option to true when you for example need to access the raw stream, such as streaming it directly to a file or other persistent store. DefaultHttpBinding will copy the request input stream into a stream cache and put it into message body if this option is false to support reading the stream multiple times. If you use Servlet to bridge/proxy an endpoint then consider enabling this option to improve performance, in case you do not need to read the message payload multiple times. The http producer will by default cache the response body stream. If setting this option to true, then the producers will not cache the response body stream but use the response stream as-is as the message body.";
    public static final Boolean CAMEL_SOURCE_JETTY_ENDPOINT_DISABLE_STREAM_CACHE_DEFAULT = false;
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_HEADER_FILTER_STRATEGY_CONF = "camel.source.endpoint.headerFilterStrategy";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_HEADER_FILTER_STRATEGY_DOC = "To use a custom HeaderFilterStrategy to filter header to and from Camel message.";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_HEADER_FILTER_STRATEGY_DEFAULT = null;
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_HTTP_BINDING_CONF = "camel.source.endpoint.httpBinding";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_HTTP_BINDING_DOC = "To use a custom HttpBinding to control the mapping between Camel message and HttpClient.";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_HTTP_BINDING_DEFAULT = null;
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_ASYNC_CONF = "camel.source.endpoint.async";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_ASYNC_DOC = "Configure the consumer to work in async mode";
    public static final Boolean CAMEL_SOURCE_JETTY_ENDPOINT_ASYNC_DEFAULT = false;
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF = "camel.source.endpoint.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_JETTY_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_CONTINUATION_TIMEOUT_CONF = "camel.source.endpoint.continuationTimeout";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_CONTINUATION_TIMEOUT_DOC = "Allows to set a timeout in millis when using Jetty as consumer (server). By default Jetty uses 30000. You can use a value of = 0 to never expire. If a timeout occurs then the request will be expired and Jetty will return back a http error 503 to the client. This option is only in use when using Jetty with the Asynchronous Routing Engine.";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_CONTINUATION_TIMEOUT_DEFAULT = "30000";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_ENABLE_CORSCONF = "camel.source.endpoint.enableCORS";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_ENABLE_CORSDOC = "If the option is true, Jetty server will setup the CrossOriginFilter which supports the CORS out of box.";
    public static final Boolean CAMEL_SOURCE_JETTY_ENDPOINT_ENABLE_CORSDEFAULT = false;
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_ENABLE_JMX_CONF = "camel.source.endpoint.enableJmx";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_ENABLE_JMX_DOC = "If this option is true, Jetty JMX support will be enabled for this endpoint. See Jetty JMX support for more details.";
    public static final Boolean CAMEL_SOURCE_JETTY_ENDPOINT_ENABLE_JMX_DEFAULT = false;
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_ENABLE_MULTIPART_FILTER_CONF = "camel.source.endpoint.enableMultipartFilter";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_ENABLE_MULTIPART_FILTER_DOC = "Whether org.apache.camel.component.jetty.MultiPartFilter is enabled or not. You should set this value to false when bridging endpoints, to ensure multipart requests is proxied/bridged as well.";
    public static final Boolean CAMEL_SOURCE_JETTY_ENDPOINT_ENABLE_MULTIPART_FILTER_DEFAULT = false;
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_HTTP_METHOD_RESTRICT_CONF = "camel.source.endpoint.httpMethodRestrict";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_HTTP_METHOD_RESTRICT_DOC = "Used to only allow consuming if the HttpMethod matches, such as GET/POST/PUT etc. Multiple methods can be specified separated by comma.";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_HTTP_METHOD_RESTRICT_DEFAULT = null;
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_MATCH_ON_URI_PREFIX_CONF = "camel.source.endpoint.matchOnUriPrefix";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_MATCH_ON_URI_PREFIX_DOC = "Whether or not the consumer should try to find a target consumer by matching the URI prefix if no exact match is found.";
    public static final Boolean CAMEL_SOURCE_JETTY_ENDPOINT_MATCH_ON_URI_PREFIX_DEFAULT = false;
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_MUTE_EXCEPTION_CONF = "camel.source.endpoint.muteException";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_MUTE_EXCEPTION_DOC = "If enabled and an Exchange failed processing on the consumer side the response's body won't contain the exception's stack trace.";
    public static final Boolean CAMEL_SOURCE_JETTY_ENDPOINT_MUTE_EXCEPTION_DEFAULT = false;
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_RESPONSE_BUFFER_SIZE_CONF = "camel.source.endpoint.responseBufferSize";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_RESPONSE_BUFFER_SIZE_DOC = "To use a custom buffer size on the javax.servlet.ServletResponse.";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_RESPONSE_BUFFER_SIZE_DEFAULT = null;
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_SEND_DATE_HEADER_CONF = "camel.source.endpoint.sendDateHeader";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_SEND_DATE_HEADER_DOC = "If the option is true, jetty server will send the date header to the client which sends the request. NOTE please make sure there is no any other camel-jetty endpoint is share the same port, otherwise this option may not work as expected.";
    public static final Boolean CAMEL_SOURCE_JETTY_ENDPOINT_SEND_DATE_HEADER_DEFAULT = false;
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_SEND_SERVER_VERSION_CONF = "camel.source.endpoint.sendServerVersion";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_SEND_SERVER_VERSION_DOC = "If the option is true, jetty will send the server header with the jetty version information to the client which sends the request. NOTE please make sure there is no any other camel-jetty endpoint is share the same port, otherwise this option may not work as expected.";
    public static final Boolean CAMEL_SOURCE_JETTY_ENDPOINT_SEND_SERVER_VERSION_DEFAULT = true;
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_SESSION_SUPPORT_CONF = "camel.source.endpoint.sessionSupport";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_SESSION_SUPPORT_DOC = "Specifies whether to enable the session manager on the server side of Jetty.";
    public static final Boolean CAMEL_SOURCE_JETTY_ENDPOINT_SESSION_SUPPORT_DEFAULT = false;
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_TRANSFER_EXCEPTION_CONF = "camel.source.endpoint.transferException";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_TRANSFER_EXCEPTION_DOC = "If enabled and an Exchange failed processing on the consumer side, and if the caused Exception was send back serialized in the response as a application/x-java-serialized-object content type. On the producer side the exception will be deserialized and thrown as is, instead of the HttpOperationFailedException. The caused exception is required to be serialized. This is by default turned off. If you enable this then be aware that Java will deserialize the incoming data from the request to Java and that can be a potential security risk.";
    public static final Boolean CAMEL_SOURCE_JETTY_ENDPOINT_TRANSFER_EXCEPTION_DEFAULT = false;
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_USE_CONTINUATION_CONF = "camel.source.endpoint.useContinuation";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_USE_CONTINUATION_DOC = "Whether or not to use Jetty continuations for the Jetty Server.";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_USE_CONTINUATION_DEFAULT = null;
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_EAGER_CHECK_CONTENT_AVAILABLE_CONF = "camel.source.endpoint.eagerCheckContentAvailable";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_EAGER_CHECK_CONTENT_AVAILABLE_DOC = "Whether to eager check whether the HTTP requests has content if the content-length header is 0 or not present. This can be turned on in case HTTP clients do not send streamed data.";
    public static final Boolean CAMEL_SOURCE_JETTY_ENDPOINT_EAGER_CHECK_CONTENT_AVAILABLE_DEFAULT = false;
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_EXCEPTION_HANDLER_CONF = "camel.source.endpoint.exceptionHandler";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_EXCEPTION_HANDLER_DOC = "To let the consumer use a custom ExceptionHandler. Notice if the option bridgeErrorHandler is enabled then this option is not in use. By default the consumer will deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_EXCHANGE_PATTERN_CONF = "camel.source.endpoint.exchangePattern";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_EXCHANGE_PATTERN_DOC = "Sets the exchange pattern when the consumer creates an exchange. One of: [InOnly] [InOut] [InOptionalOut]";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_EXCHANGE_PATTERN_DEFAULT = null;
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_FILTER_INIT_PARAMETERS_CONF = "camel.source.endpoint.filterInitParameters";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_FILTER_INIT_PARAMETERS_DOC = "Configuration of the filter init parameters. These parameters will be applied to the filter list before starting the jetty server.";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_FILTER_INIT_PARAMETERS_DEFAULT = null;
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_FILTERS_CONF = "camel.source.endpoint.filters";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_FILTERS_DOC = "Allows using a custom filters which is putted into a list and can be find in the Registry. Multiple values can be separated by comma.";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_FILTERS_DEFAULT = null;
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_HANDLERS_CONF = "camel.source.endpoint.handlers";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_HANDLERS_DOC = "Specifies a comma-delimited set of Handler instances to lookup in your Registry. These handlers are added to the Jetty servlet context (for example, to add security). Important: You can not use different handlers with different Jetty endpoints using the same port number. The handlers is associated to the port number. If you need different handlers, then use different port numbers.";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_HANDLERS_DEFAULT = null;
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_MULTIPART_FILTER_CONF = "camel.source.endpoint.multipartFilter";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_MULTIPART_FILTER_DOC = "Allows using a custom multipart filter. Note: setting multipartFilterRef forces the value of enableMultipartFilter to true.";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_MULTIPART_FILTER_DEFAULT = null;
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_OPTIONS_ENABLED_CONF = "camel.source.endpoint.optionsEnabled";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_OPTIONS_ENABLED_DOC = "Specifies whether to enable HTTP OPTIONS for this Servlet consumer. By default OPTIONS is turned off.";
    public static final Boolean CAMEL_SOURCE_JETTY_ENDPOINT_OPTIONS_ENABLED_DEFAULT = false;
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_TRACE_ENABLED_CONF = "camel.source.endpoint.traceEnabled";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_TRACE_ENABLED_DOC = "Specifies whether to enable HTTP TRACE for this Servlet consumer. By default TRACE is turned off.";
    public static final Boolean CAMEL_SOURCE_JETTY_ENDPOINT_TRACE_ENABLED_DEFAULT = false;
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_MAP_HTTP_MESSAGE_BODY_CONF = "camel.source.endpoint.mapHttpMessageBody";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_MAP_HTTP_MESSAGE_BODY_DOC = "If this option is true then IN exchange Body of the exchange will be mapped to HTTP body. Setting this to false will avoid the HTTP mapping.";
    public static final Boolean CAMEL_SOURCE_JETTY_ENDPOINT_MAP_HTTP_MESSAGE_BODY_DEFAULT = true;
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_MAP_HTTP_MESSAGE_FORM_URL_ENCODED_BODY_CONF = "camel.source.endpoint.mapHttpMessageFormUrlEncodedBody";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_MAP_HTTP_MESSAGE_FORM_URL_ENCODED_BODY_DOC = "If this option is true then IN exchange Form Encoded body of the exchange will be mapped to HTTP. Setting this to false will avoid the HTTP Form Encoded body mapping.";
    public static final Boolean CAMEL_SOURCE_JETTY_ENDPOINT_MAP_HTTP_MESSAGE_FORM_URL_ENCODED_BODY_DEFAULT = true;
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_MAP_HTTP_MESSAGE_HEADERS_CONF = "camel.source.endpoint.mapHttpMessageHeaders";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_MAP_HTTP_MESSAGE_HEADERS_DOC = "If this option is true then IN exchange Headers of the exchange will be mapped to HTTP headers. Setting this to false will avoid the HTTP Headers mapping.";
    public static final Boolean CAMEL_SOURCE_JETTY_ENDPOINT_MAP_HTTP_MESSAGE_HEADERS_DEFAULT = true;
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_SSL_CONTEXT_PARAMETERS_CONF = "camel.source.endpoint.sslContextParameters";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_SSL_CONTEXT_PARAMETERS_DOC = "To configure security using SSLContextParameters";
    public static final String CAMEL_SOURCE_JETTY_ENDPOINT_SSL_CONTEXT_PARAMETERS_DEFAULT = null;
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_BRIDGE_ERROR_HANDLER_CONF = "camel.component.jetty.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_JETTY_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_CONTINUATION_TIMEOUT_CONF = "camel.component.jetty.continuationTimeout";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_CONTINUATION_TIMEOUT_DOC = "Allows to set a timeout in millis when using Jetty as consumer (server). By default Jetty uses 30000. You can use a value of = 0 to never expire. If a timeout occurs then the request will be expired and Jetty will return back a http error 503 to the client. This option is only in use when using Jetty with the Asynchronous Routing Engine.";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_CONTINUATION_TIMEOUT_DEFAULT = "30000";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_ENABLE_JMX_CONF = "camel.component.jetty.enableJmx";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_ENABLE_JMX_DOC = "If this option is true, Jetty JMX support will be enabled for this endpoint.";
    public static final Boolean CAMEL_SOURCE_JETTY_COMPONENT_ENABLE_JMX_DEFAULT = false;
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_MAX_THREADS_CONF = "camel.component.jetty.maxThreads";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_MAX_THREADS_DOC = "To set a value for maximum number of threads in server thread pool. Notice that both a min and max size must be configured.";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_MAX_THREADS_DEFAULT = null;
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_MIN_THREADS_CONF = "camel.component.jetty.minThreads";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_MIN_THREADS_DOC = "To set a value for minimum number of threads in server thread pool. Notice that both a min and max size must be configured.";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_MIN_THREADS_DEFAULT = null;
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_REQUEST_BUFFER_SIZE_CONF = "camel.component.jetty.requestBufferSize";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_REQUEST_BUFFER_SIZE_DOC = "Allows to configure a custom value of the request buffer size on the Jetty connectors.";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_REQUEST_BUFFER_SIZE_DEFAULT = null;
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_REQUEST_HEADER_SIZE_CONF = "camel.component.jetty.requestHeaderSize";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_REQUEST_HEADER_SIZE_DOC = "Allows to configure a custom value of the request header size on the Jetty connectors.";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_REQUEST_HEADER_SIZE_DEFAULT = null;
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_RESPONSE_BUFFER_SIZE_CONF = "camel.component.jetty.responseBufferSize";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_RESPONSE_BUFFER_SIZE_DOC = "Allows to configure a custom value of the response buffer size on the Jetty connectors.";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_RESPONSE_BUFFER_SIZE_DEFAULT = null;
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_RESPONSE_HEADER_SIZE_CONF = "camel.component.jetty.responseHeaderSize";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_RESPONSE_HEADER_SIZE_DOC = "Allows to configure a custom value of the response header size on the Jetty connectors.";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_RESPONSE_HEADER_SIZE_DEFAULT = null;
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_SEND_SERVER_VERSION_CONF = "camel.component.jetty.sendServerVersion";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_SEND_SERVER_VERSION_DOC = "If the option is true, jetty will send the server header with the jetty version information to the client which sends the request. NOTE please make sure there is no any other camel-jetty endpoint is share the same port, otherwise this option may not work as expected.";
    public static final Boolean CAMEL_SOURCE_JETTY_COMPONENT_SEND_SERVER_VERSION_DEFAULT = true;
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_USE_CONTINUATION_CONF = "camel.component.jetty.useContinuation";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_USE_CONTINUATION_DOC = "Whether or not to use Jetty continuations for the Jetty Server.";
    public static final Boolean CAMEL_SOURCE_JETTY_COMPONENT_USE_CONTINUATION_DEFAULT = true;
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_USE_XFORWARDED_FOR_HEADER_CONF = "camel.component.jetty.useXForwardedForHeader";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_USE_XFORWARDED_FOR_HEADER_DOC = "To use the X-Forwarded-For header in HttpServletRequest.getRemoteAddr.";
    public static final Boolean CAMEL_SOURCE_JETTY_COMPONENT_USE_XFORWARDED_FOR_HEADER_DEFAULT = false;
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_THREAD_POOL_CONF = "camel.component.jetty.threadPool";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_THREAD_POOL_DOC = "To use a custom thread pool for the server. This option should only be used in special circumstances.";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_THREAD_POOL_DEFAULT = null;
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_ALLOW_JAVA_SERIALIZED_OBJECT_CONF = "camel.component.jetty.allowJavaSerializedObject";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_ALLOW_JAVA_SERIALIZED_OBJECT_DOC = "Whether to allow java serialization when a request uses context-type=application/x-java-serialized-object. This is by default turned off. If you enable this then be aware that Java will deserialize the incoming data from the request to Java and that can be a potential security risk.";
    public static final Boolean CAMEL_SOURCE_JETTY_COMPONENT_ALLOW_JAVA_SERIALIZED_OBJECT_DEFAULT = false;
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_AUTOWIRED_ENABLED_CONF = "camel.component.jetty.autowiredEnabled";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_AUTOWIRED_ENABLED_DOC = "Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc.";
    public static final Boolean CAMEL_SOURCE_JETTY_COMPONENT_AUTOWIRED_ENABLED_DEFAULT = true;
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_ERROR_HANDLER_CONF = "camel.component.jetty.errorHandler";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_ERROR_HANDLER_DOC = "This option is used to set the ErrorHandler that Jetty server uses.";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_ERROR_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_HTTP_BINDING_CONF = "camel.component.jetty.httpBinding";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_HTTP_BINDING_DOC = "Not to be used - use JettyHttpBinding instead.";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_HTTP_BINDING_DEFAULT = null;
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_HTTP_CONFIGURATION_CONF = "camel.component.jetty.httpConfiguration";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_HTTP_CONFIGURATION_DOC = "Jetty component does not use HttpConfiguration.";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_HTTP_CONFIGURATION_DEFAULT = null;
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_JETTY_HTTP_BINDING_CONF = "camel.component.jetty.jettyHttpBinding";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_JETTY_HTTP_BINDING_DOC = "To use a custom org.apache.camel.component.jetty.JettyHttpBinding, which are used to customize how a response should be written for the producer.";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_JETTY_HTTP_BINDING_DEFAULT = null;
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_MB_CONTAINER_CONF = "camel.component.jetty.mbContainer";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_MB_CONTAINER_DOC = "To use a existing configured org.eclipse.jetty.jmx.MBeanContainer if JMX is enabled that Jetty uses for registering mbeans.";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_MB_CONTAINER_DEFAULT = null;
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_HEADER_FILTER_STRATEGY_CONF = "camel.component.jetty.headerFilterStrategy";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_HEADER_FILTER_STRATEGY_DOC = "To use a custom org.apache.camel.spi.HeaderFilterStrategy to filter header to and from Camel message.";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_HEADER_FILTER_STRATEGY_DEFAULT = null;
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_PROXY_HOST_CONF = "camel.component.jetty.proxyHost";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_PROXY_HOST_DOC = "To use a http proxy to configure the hostname.";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_PROXY_HOST_DEFAULT = null;
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_PROXY_PORT_CONF = "camel.component.jetty.proxyPort";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_PROXY_PORT_DOC = "To use a http proxy to configure the port number.";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_PROXY_PORT_DEFAULT = null;
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_KEYSTORE_CONF = "camel.component.jetty.keystore";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_KEYSTORE_DOC = "Specifies the location of the Java keystore file, which contains the Jetty server's own X.509 certificate in a key entry.";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_KEYSTORE_DEFAULT = null;
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_SOCKET_CONNECTOR_PROPERTIES_CONF = "camel.component.jetty.socketConnectorProperties";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_SOCKET_CONNECTOR_PROPERTIES_DOC = "A map which contains general HTTP connector properties. Uses the same principle as sslSocketConnectorProperties.";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_SOCKET_CONNECTOR_PROPERTIES_DEFAULT = null;
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_SOCKET_CONNECTORS_CONF = "camel.component.jetty.socketConnectors";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_SOCKET_CONNECTORS_DOC = "A map which contains per port number specific HTTP connectors. Uses the same principle as sslSocketConnectors.";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_SOCKET_CONNECTORS_DEFAULT = null;
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_SSL_CONTEXT_PARAMETERS_CONF = "camel.component.jetty.sslContextParameters";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_SSL_CONTEXT_PARAMETERS_DOC = "To configure security using SSLContextParameters";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_SSL_CONTEXT_PARAMETERS_DEFAULT = null;
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_SSL_KEY_PASSWORD_CONF = "camel.component.jetty.sslKeyPassword";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_SSL_KEY_PASSWORD_DOC = "The key password, which is used to access the certificate's key entry in the keystore (this is the same password that is supplied to the keystore command's -keypass option).";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_SSL_KEY_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_SSL_PASSWORD_CONF = "camel.component.jetty.sslPassword";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_SSL_PASSWORD_DOC = "The ssl password, which is required to access the keystore file (this is the same password that is supplied to the keystore command's -storepass option).";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_SSL_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_SSL_SOCKET_CONNECTOR_PROPERTIES_CONF = "camel.component.jetty.sslSocketConnectorProperties";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_SSL_SOCKET_CONNECTOR_PROPERTIES_DOC = "A map which contains general SSL connector properties.";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_SSL_SOCKET_CONNECTOR_PROPERTIES_DEFAULT = null;
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_SSL_SOCKET_CONNECTORS_CONF = "camel.component.jetty.sslSocketConnectors";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_SSL_SOCKET_CONNECTORS_DOC = "A map which contains per port number specific SSL connectors.";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_SSL_SOCKET_CONNECTORS_DEFAULT = null;
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_CONF = "camel.component.jetty.useGlobalSslContextParameters";
    public static final String CAMEL_SOURCE_JETTY_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DOC = "Enable usage of global SSL context parameters";
    public static final Boolean CAMEL_SOURCE_JETTY_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DEFAULT = false;

    public CamelJettySourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelJettySourceConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_JETTY_PATH_HTTP_URI_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JETTY_PATH_HTTP_URI_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_JETTY_PATH_HTTP_URI_DOC);
        conf.define(CAMEL_SOURCE_JETTY_ENDPOINT_CHUNKED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JETTY_ENDPOINT_CHUNKED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_ENDPOINT_CHUNKED_DOC);
        conf.define(CAMEL_SOURCE_JETTY_ENDPOINT_DISABLE_STREAM_CACHE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JETTY_ENDPOINT_DISABLE_STREAM_CACHE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_ENDPOINT_DISABLE_STREAM_CACHE_DOC);
        conf.define(CAMEL_SOURCE_JETTY_ENDPOINT_HEADER_FILTER_STRATEGY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JETTY_ENDPOINT_HEADER_FILTER_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_ENDPOINT_HEADER_FILTER_STRATEGY_DOC);
        conf.define(CAMEL_SOURCE_JETTY_ENDPOINT_HTTP_BINDING_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JETTY_ENDPOINT_HTTP_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_ENDPOINT_HTTP_BINDING_DOC);
        conf.define(CAMEL_SOURCE_JETTY_ENDPOINT_ASYNC_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JETTY_ENDPOINT_ASYNC_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_ENDPOINT_ASYNC_DOC);
        conf.define(CAMEL_SOURCE_JETTY_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JETTY_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_JETTY_ENDPOINT_CONTINUATION_TIMEOUT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JETTY_ENDPOINT_CONTINUATION_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_ENDPOINT_CONTINUATION_TIMEOUT_DOC);
        conf.define(CAMEL_SOURCE_JETTY_ENDPOINT_ENABLE_CORSCONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JETTY_ENDPOINT_ENABLE_CORSDEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_ENDPOINT_ENABLE_CORSDOC);
        conf.define(CAMEL_SOURCE_JETTY_ENDPOINT_ENABLE_JMX_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JETTY_ENDPOINT_ENABLE_JMX_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_ENDPOINT_ENABLE_JMX_DOC);
        conf.define(CAMEL_SOURCE_JETTY_ENDPOINT_ENABLE_MULTIPART_FILTER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JETTY_ENDPOINT_ENABLE_MULTIPART_FILTER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_ENDPOINT_ENABLE_MULTIPART_FILTER_DOC);
        conf.define(CAMEL_SOURCE_JETTY_ENDPOINT_HTTP_METHOD_RESTRICT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JETTY_ENDPOINT_HTTP_METHOD_RESTRICT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_ENDPOINT_HTTP_METHOD_RESTRICT_DOC);
        conf.define(CAMEL_SOURCE_JETTY_ENDPOINT_MATCH_ON_URI_PREFIX_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JETTY_ENDPOINT_MATCH_ON_URI_PREFIX_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_ENDPOINT_MATCH_ON_URI_PREFIX_DOC);
        conf.define(CAMEL_SOURCE_JETTY_ENDPOINT_MUTE_EXCEPTION_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JETTY_ENDPOINT_MUTE_EXCEPTION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_ENDPOINT_MUTE_EXCEPTION_DOC);
        conf.define(CAMEL_SOURCE_JETTY_ENDPOINT_RESPONSE_BUFFER_SIZE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JETTY_ENDPOINT_RESPONSE_BUFFER_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_ENDPOINT_RESPONSE_BUFFER_SIZE_DOC);
        conf.define(CAMEL_SOURCE_JETTY_ENDPOINT_SEND_DATE_HEADER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JETTY_ENDPOINT_SEND_DATE_HEADER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_ENDPOINT_SEND_DATE_HEADER_DOC);
        conf.define(CAMEL_SOURCE_JETTY_ENDPOINT_SEND_SERVER_VERSION_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JETTY_ENDPOINT_SEND_SERVER_VERSION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_ENDPOINT_SEND_SERVER_VERSION_DOC);
        conf.define(CAMEL_SOURCE_JETTY_ENDPOINT_SESSION_SUPPORT_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JETTY_ENDPOINT_SESSION_SUPPORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_ENDPOINT_SESSION_SUPPORT_DOC);
        conf.define(CAMEL_SOURCE_JETTY_ENDPOINT_TRANSFER_EXCEPTION_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JETTY_ENDPOINT_TRANSFER_EXCEPTION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_ENDPOINT_TRANSFER_EXCEPTION_DOC);
        conf.define(CAMEL_SOURCE_JETTY_ENDPOINT_USE_CONTINUATION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JETTY_ENDPOINT_USE_CONTINUATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_ENDPOINT_USE_CONTINUATION_DOC);
        conf.define(CAMEL_SOURCE_JETTY_ENDPOINT_EAGER_CHECK_CONTENT_AVAILABLE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JETTY_ENDPOINT_EAGER_CHECK_CONTENT_AVAILABLE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_ENDPOINT_EAGER_CHECK_CONTENT_AVAILABLE_DOC);
        conf.define(CAMEL_SOURCE_JETTY_ENDPOINT_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JETTY_ENDPOINT_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_ENDPOINT_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_JETTY_ENDPOINT_EXCHANGE_PATTERN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JETTY_ENDPOINT_EXCHANGE_PATTERN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_ENDPOINT_EXCHANGE_PATTERN_DOC);
        conf.define(CAMEL_SOURCE_JETTY_ENDPOINT_FILTER_INIT_PARAMETERS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JETTY_ENDPOINT_FILTER_INIT_PARAMETERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_ENDPOINT_FILTER_INIT_PARAMETERS_DOC);
        conf.define(CAMEL_SOURCE_JETTY_ENDPOINT_FILTERS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JETTY_ENDPOINT_FILTERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_ENDPOINT_FILTERS_DOC);
        conf.define(CAMEL_SOURCE_JETTY_ENDPOINT_HANDLERS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JETTY_ENDPOINT_HANDLERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_ENDPOINT_HANDLERS_DOC);
        conf.define(CAMEL_SOURCE_JETTY_ENDPOINT_MULTIPART_FILTER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JETTY_ENDPOINT_MULTIPART_FILTER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_ENDPOINT_MULTIPART_FILTER_DOC);
        conf.define(CAMEL_SOURCE_JETTY_ENDPOINT_OPTIONS_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JETTY_ENDPOINT_OPTIONS_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_ENDPOINT_OPTIONS_ENABLED_DOC);
        conf.define(CAMEL_SOURCE_JETTY_ENDPOINT_TRACE_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JETTY_ENDPOINT_TRACE_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_ENDPOINT_TRACE_ENABLED_DOC);
        conf.define(CAMEL_SOURCE_JETTY_ENDPOINT_MAP_HTTP_MESSAGE_BODY_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JETTY_ENDPOINT_MAP_HTTP_MESSAGE_BODY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_ENDPOINT_MAP_HTTP_MESSAGE_BODY_DOC);
        conf.define(CAMEL_SOURCE_JETTY_ENDPOINT_MAP_HTTP_MESSAGE_FORM_URL_ENCODED_BODY_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JETTY_ENDPOINT_MAP_HTTP_MESSAGE_FORM_URL_ENCODED_BODY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_ENDPOINT_MAP_HTTP_MESSAGE_FORM_URL_ENCODED_BODY_DOC);
        conf.define(CAMEL_SOURCE_JETTY_ENDPOINT_MAP_HTTP_MESSAGE_HEADERS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JETTY_ENDPOINT_MAP_HTTP_MESSAGE_HEADERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_ENDPOINT_MAP_HTTP_MESSAGE_HEADERS_DOC);
        conf.define(CAMEL_SOURCE_JETTY_ENDPOINT_SSL_CONTEXT_PARAMETERS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JETTY_ENDPOINT_SSL_CONTEXT_PARAMETERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_ENDPOINT_SSL_CONTEXT_PARAMETERS_DOC);
        conf.define(CAMEL_SOURCE_JETTY_COMPONENT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JETTY_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_COMPONENT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_JETTY_COMPONENT_CONTINUATION_TIMEOUT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JETTY_COMPONENT_CONTINUATION_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_COMPONENT_CONTINUATION_TIMEOUT_DOC);
        conf.define(CAMEL_SOURCE_JETTY_COMPONENT_ENABLE_JMX_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JETTY_COMPONENT_ENABLE_JMX_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_COMPONENT_ENABLE_JMX_DOC);
        conf.define(CAMEL_SOURCE_JETTY_COMPONENT_MAX_THREADS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JETTY_COMPONENT_MAX_THREADS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_COMPONENT_MAX_THREADS_DOC);
        conf.define(CAMEL_SOURCE_JETTY_COMPONENT_MIN_THREADS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JETTY_COMPONENT_MIN_THREADS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_COMPONENT_MIN_THREADS_DOC);
        conf.define(CAMEL_SOURCE_JETTY_COMPONENT_REQUEST_BUFFER_SIZE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JETTY_COMPONENT_REQUEST_BUFFER_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_COMPONENT_REQUEST_BUFFER_SIZE_DOC);
        conf.define(CAMEL_SOURCE_JETTY_COMPONENT_REQUEST_HEADER_SIZE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JETTY_COMPONENT_REQUEST_HEADER_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_COMPONENT_REQUEST_HEADER_SIZE_DOC);
        conf.define(CAMEL_SOURCE_JETTY_COMPONENT_RESPONSE_BUFFER_SIZE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JETTY_COMPONENT_RESPONSE_BUFFER_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_COMPONENT_RESPONSE_BUFFER_SIZE_DOC);
        conf.define(CAMEL_SOURCE_JETTY_COMPONENT_RESPONSE_HEADER_SIZE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JETTY_COMPONENT_RESPONSE_HEADER_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_COMPONENT_RESPONSE_HEADER_SIZE_DOC);
        conf.define(CAMEL_SOURCE_JETTY_COMPONENT_SEND_SERVER_VERSION_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JETTY_COMPONENT_SEND_SERVER_VERSION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_COMPONENT_SEND_SERVER_VERSION_DOC);
        conf.define(CAMEL_SOURCE_JETTY_COMPONENT_USE_CONTINUATION_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JETTY_COMPONENT_USE_CONTINUATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_COMPONENT_USE_CONTINUATION_DOC);
        conf.define(CAMEL_SOURCE_JETTY_COMPONENT_USE_XFORWARDED_FOR_HEADER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JETTY_COMPONENT_USE_XFORWARDED_FOR_HEADER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_COMPONENT_USE_XFORWARDED_FOR_HEADER_DOC);
        conf.define(CAMEL_SOURCE_JETTY_COMPONENT_THREAD_POOL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JETTY_COMPONENT_THREAD_POOL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_COMPONENT_THREAD_POOL_DOC);
        conf.define(CAMEL_SOURCE_JETTY_COMPONENT_ALLOW_JAVA_SERIALIZED_OBJECT_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JETTY_COMPONENT_ALLOW_JAVA_SERIALIZED_OBJECT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_COMPONENT_ALLOW_JAVA_SERIALIZED_OBJECT_DOC);
        conf.define(CAMEL_SOURCE_JETTY_COMPONENT_AUTOWIRED_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JETTY_COMPONENT_AUTOWIRED_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_COMPONENT_AUTOWIRED_ENABLED_DOC);
        conf.define(CAMEL_SOURCE_JETTY_COMPONENT_ERROR_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JETTY_COMPONENT_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_COMPONENT_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_JETTY_COMPONENT_HTTP_BINDING_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JETTY_COMPONENT_HTTP_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_COMPONENT_HTTP_BINDING_DOC);
        conf.define(CAMEL_SOURCE_JETTY_COMPONENT_HTTP_CONFIGURATION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JETTY_COMPONENT_HTTP_CONFIGURATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_COMPONENT_HTTP_CONFIGURATION_DOC);
        conf.define(CAMEL_SOURCE_JETTY_COMPONENT_JETTY_HTTP_BINDING_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JETTY_COMPONENT_JETTY_HTTP_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_COMPONENT_JETTY_HTTP_BINDING_DOC);
        conf.define(CAMEL_SOURCE_JETTY_COMPONENT_MB_CONTAINER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JETTY_COMPONENT_MB_CONTAINER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_COMPONENT_MB_CONTAINER_DOC);
        conf.define(CAMEL_SOURCE_JETTY_COMPONENT_HEADER_FILTER_STRATEGY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JETTY_COMPONENT_HEADER_FILTER_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_COMPONENT_HEADER_FILTER_STRATEGY_DOC);
        conf.define(CAMEL_SOURCE_JETTY_COMPONENT_PROXY_HOST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JETTY_COMPONENT_PROXY_HOST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_COMPONENT_PROXY_HOST_DOC);
        conf.define(CAMEL_SOURCE_JETTY_COMPONENT_PROXY_PORT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JETTY_COMPONENT_PROXY_PORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_COMPONENT_PROXY_PORT_DOC);
        conf.define(CAMEL_SOURCE_JETTY_COMPONENT_KEYSTORE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JETTY_COMPONENT_KEYSTORE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_COMPONENT_KEYSTORE_DOC);
        conf.define(CAMEL_SOURCE_JETTY_COMPONENT_SOCKET_CONNECTOR_PROPERTIES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JETTY_COMPONENT_SOCKET_CONNECTOR_PROPERTIES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_COMPONENT_SOCKET_CONNECTOR_PROPERTIES_DOC);
        conf.define(CAMEL_SOURCE_JETTY_COMPONENT_SOCKET_CONNECTORS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JETTY_COMPONENT_SOCKET_CONNECTORS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_COMPONENT_SOCKET_CONNECTORS_DOC);
        conf.define(CAMEL_SOURCE_JETTY_COMPONENT_SSL_CONTEXT_PARAMETERS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JETTY_COMPONENT_SSL_CONTEXT_PARAMETERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_COMPONENT_SSL_CONTEXT_PARAMETERS_DOC);
        conf.define(CAMEL_SOURCE_JETTY_COMPONENT_SSL_KEY_PASSWORD_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JETTY_COMPONENT_SSL_KEY_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_COMPONENT_SSL_KEY_PASSWORD_DOC);
        conf.define(CAMEL_SOURCE_JETTY_COMPONENT_SSL_PASSWORD_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JETTY_COMPONENT_SSL_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_COMPONENT_SSL_PASSWORD_DOC);
        conf.define(CAMEL_SOURCE_JETTY_COMPONENT_SSL_SOCKET_CONNECTOR_PROPERTIES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JETTY_COMPONENT_SSL_SOCKET_CONNECTOR_PROPERTIES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_COMPONENT_SSL_SOCKET_CONNECTOR_PROPERTIES_DOC);
        conf.define(CAMEL_SOURCE_JETTY_COMPONENT_SSL_SOCKET_CONNECTORS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JETTY_COMPONENT_SSL_SOCKET_CONNECTORS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_COMPONENT_SSL_SOCKET_CONNECTORS_DOC);
        conf.define(CAMEL_SOURCE_JETTY_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JETTY_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JETTY_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DOC);
        return conf;
    }
}